/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.liquids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidContainerRegistry {
    public static final int BUCKET_VOLUME = 1000;
    public static final ur EMPTY_BUCKET = new ur(up.aw);
    private static Map<List, LiquidContainerData> mapFilledItemFromLiquid = new HashMap<List, LiquidContainerData>();
    private static Map<List, LiquidContainerData> mapLiquidFromFilledItem = new HashMap<List, LiquidContainerData>();
    private static Set<List> setContainerValidation = new HashSet<List>();
    private static Set<List> setLiquidValidation = new HashSet<List>();
    private static ArrayList<LiquidContainerData> liquids = new ArrayList();

    public static void registerLiquid(LiquidContainerData data) {
        mapFilledItemFromLiquid.put(Arrays.asList(data.container.c, data.container.j(), data.stillLiquid.itemID, data.stillLiquid.itemMeta), data);
        mapLiquidFromFilledItem.put(Arrays.asList(data.filled.c, data.filled.j()), data);
        setContainerValidation.add(Arrays.asList(data.container.c, data.container.j()));
        setLiquidValidation.add(Arrays.asList(data.stillLiquid.itemID, data.stillLiquid.itemMeta));
        liquids.add(data);
    }

    public static LiquidStack getLiquidForFilledItem(ur filledContainer) {
        if (filledContainer == null) {
            return null;
        }
        LiquidContainerData ret = mapLiquidFromFilledItem.get(Arrays.asList(filledContainer.c, filledContainer.j()));
        return ret == null ? null : ret.stillLiquid.copy();
    }

    public static ur fillLiquidContainer(LiquidStack liquid, ur emptyContainer) {
        if (emptyContainer == null || liquid == null) {
            return null;
        }
        LiquidContainerData ret = mapFilledItemFromLiquid.get(Arrays.asList(emptyContainer.c, emptyContainer.j(), liquid.itemID, liquid.itemMeta));
        if (ret != null && liquid.amount >= ret.stillLiquid.amount) {
            return ret.filled.l();
        }
        return null;
    }

    public static boolean containsLiquid(ur filledContainer, LiquidStack liquid) {
        if (filledContainer == null || liquid == null) {
            return false;
        }
        LiquidContainerData ret = mapLiquidFromFilledItem.get(Arrays.asList(filledContainer.c, filledContainer.j()));
        return ret != null && ret.stillLiquid.isLiquidEqual(liquid);
    }

    public static boolean isBucket(ur container) {
        if (container == null) {
            return false;
        }
        if (container.a(EMPTY_BUCKET)) {
            return true;
        }
        LiquidContainerData ret = mapLiquidFromFilledItem.get(Arrays.asList(container.c, container.j()));
        return ret != null && ret.container.a(EMPTY_BUCKET);
    }

    public static boolean isContainer(ur container) {
        return LiquidContainerRegistry.isEmptyContainer(container) || LiquidContainerRegistry.isFilledContainer(container);
    }

    public static boolean isEmptyContainer(ur emptyContainer) {
        return emptyContainer != null && setContainerValidation.contains(Arrays.asList(emptyContainer.c, emptyContainer.j()));
    }

    public static boolean isFilledContainer(ur filledContainer) {
        return filledContainer != null && LiquidContainerRegistry.getLiquidForFilledItem(filledContainer) != null;
    }

    public static boolean isLiquid(ur item) {
        return item != null && setLiquidValidation.contains(Arrays.asList(item.c, item.j()));
    }

    public static LiquidContainerData[] getRegisteredLiquidContainerData() {
        return liquids.toArray(new LiquidContainerData[liquids.size()]);
    }

    static {
        LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur(up.ax), new ur(up.aw)));
        LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(amq.G, 1000), new ur(up.ay), new ur(up.aw)));
        LiquidContainerRegistry.registerLiquid(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur((up)up.bs), new ur(up.bt)));
    }
}

