/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.oredict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.oredict.OreDictionary;

public class ShapedOreRecipe
implements wp {
    private static final int MAX_CRAFT_GRID_WIDTH = 3;
    private static final int MAX_CRAFT_GRID_HEIGHT = 3;
    private ur output = null;
    private Object[] input = null;
    private int width = 0;
    private int height = 0;
    private boolean mirrored = true;

    public ShapedOreRecipe(amq result, Object ... recipe) {
        this(new ur(result), recipe);
    }

    public ShapedOreRecipe(up result, Object ... recipe) {
        this(new ur(result), recipe);
    }

    public ShapedOreRecipe(ur result, Object ... recipe) {
        this.output = result.l();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            this.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s2 : parts) {
                this.width = s2.length();
                shape = shape + (String)s2;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s3 = (String)recipe[idx++];
                shape = shape + s3;
                this.width = s3.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
        HashMap<Character, Object> itemMap = new HashMap<Character, Object>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in2 = recipe[idx + 1];
            if (in2 instanceof ur) {
                itemMap.put(chr, ((ur)in2).l());
            } else if (in2 instanceof up) {
                itemMap.put(chr, new ur((up)in2));
            } else if (in2 instanceof amq) {
                itemMap.put(chr, new ur((amq)in2, 1, -1));
            } else if (in2 instanceof String) {
                itemMap.put(chr, OreDictionary.getOres((String)in2));
            } else {
                String ret = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    ret = ret + tmp + ", ";
                }
                ret = ret + this.output;
                throw new RuntimeException(ret);
            }
            idx += 2;
        }
        this.input = new Object[this.width * this.height];
        int x2 = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x2++] = itemMap.get(Character.valueOf(chr));
        }
    }

    ShapedOreRecipe(wq recipe, Map<ur, String> replacements) {
        this.output = recipe.b();
        this.width = recipe.b;
        this.height = recipe.c;
        this.input = new Object[recipe.d.length];
        block0: for (int i2 = 0; i2 < this.input.length; ++i2) {
            ur ingred = recipe.d[i2];
            if (ingred == null) continue;
            this.input[i2] = recipe.d[i2];
            for (Map.Entry<ur, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches(replace.getKey(), ingred, true)) continue;
                this.input[i2] = OreDictionary.getOres(replace.getValue());
                continue block0;
            }
        }
    }

    public ur a(ry var1) {
        return this.output.l();
    }

    public int a() {
        return this.input.length;
    }

    public ur b() {
        return this.output;
    }

    public boolean a(ry inv, yc world) {
        for (int x2 = 0; x2 <= 3 - this.width; ++x2) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x2, y, true)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x2, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(ry inv, int startX, int startY, boolean mirror) {
        for (int x2 = 0; x2 < 3; ++x2) {
            for (int y = 0; y < 3; ++y) {
                int subX = x2 - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ur slot = inv.b(x2, y);
                if (target instanceof ur) {
                    if (this.checkItemEquals((ur)target, slot)) continue;
                    return false;
                }
                if (target instanceof ArrayList) {
                    boolean matched = false;
                    for (ur item : (ArrayList)target) {
                        matched = matched || this.checkItemEquals(item, slot);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkItemEquals(ur target, ur input) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.c == input.c && (target.j() == -1 || target.j() == input.j());
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }
}

