/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.redpower;

import codechicken.core.ClientUtils;
import codechicken.wirelessredstone.core.ITileReceiver;
import codechicken.wirelessredstone.core.RedstoneEther;
import codechicken.wirelessredstone.redpower.IIcosahedronRender;
import codechicken.wirelessredstone.redpower.TileRPWireless;
import com.eloraam.redpower.core.MathLib;
import com.eloraam.redpower.core.Packet211TileDesc;
import com.eloraam.redpower.core.Quat;
import com.eloraam.redpower.core.RedPowerLib;
import com.eloraam.redpower.core.Vector3;
import java.io.IOException;

public class TileRPReceiver
extends TileRPWireless
implements ITileReceiver,
IIcosahedronRender {
    public int getExtendedID() {
        return 0;
    }

    public int getPoweringMask(int i) {
        if (i != 0) {
            return 0;
        }
        if (this.Powered) {
            return RedPowerLib.mapRotToCon((int)2, (int)this.Rotation);
        }
        return 0;
    }

    public int getLoadTicks() {
        return this.newlyCreated ? 6 : 1;
    }

    public void setActive(boolean on) {
        this.Powered = on;
        this.updateBlockChange();
    }

    @Override
    public void jamTile() {
        super.jamTile();
        this.Disabled = true;
        this.changeSpinState(true);
        this.setActive(false);
    }

    @Override
    public void unjamTile() {
        super.unjamTile();
        this.changeSpinState(false);
        this.addToEther();
    }

    public void changeSpinState(boolean jam) {
        if (!jam && this.spinoffset < 0) {
            int time = (int)(this.k.G() % 100000L);
            this.spinoffset = time + this.spinoffset;
        } else if (jam && this.spinoffset >= 0) {
            int time = (int)((this.k.G() - (long)this.spinoffset) % 100000L);
            this.spinoffset = -time;
        }
    }

    @Override
    public Quat getOrientationBasis() {
        return MathLib.orientQuat((int)(this.Rotation >> 2), (int)(this.Rotation & 3));
    }

    public codechicken.core.vec.Vector3 getFocalPoint() {
        Vector3 focal = new Vector3(0.0755, 0.255, 0.0);
        this.getOrientationBasis().rotate(focal);
        return new codechicken.core.vec.Vector3(focal.x, focal.y, focal.z);
    }

    @Override
    public Vector3 getPearlOffset() {
        Vector3 vec = new Vector3(0.0, RedstoneEther.getSineWave((double)(ClientUtils.getRenderTime() + (double)(this.l * 3) + (double)(this.m * 5) + (double)(this.n * 9)), (int)7) * 0.02, 0.0);
        Quat.aroundAxis((double)0.0, (double)0.0, (double)1.0, (double)0.785385).rotate(vec);
        vec.add(0.08, 0.755, 0.0);
        return vec;
    }

    @Override
    public Quat getPearlQuat() {
        return Quat.aroundAxis((double)0.0, (double)0.0, (double)1.0, (double)0.7854);
    }

    @Override
    public float getPearlScale() {
        return 0.04f;
    }

    @Override
    public float getPearlRotation() {
        if (this.spinoffset < 0) {
            return RedstoneEther.getRotation((double)(-this.spinoffset), (int)this.currentfreq);
        }
        return RedstoneEther.getRotation((double)(ClientUtils.getRenderTime() - (double)this.spinoffset), (int)this.currentfreq);
    }

    @Override
    public float getPearlLight() {
        float light = this.k.p(this.l, this.m, this.n);
        light = (this.Deadmap & 1) == 1 || this.Deadmap == 0 && (this.Disabled || !this.Powered || this.currentfreq == 0) ? (light + 1.0f) * 0.25f : (light + 1.0f) * 0.5f;
        return light;
    }

    @Override
    public void setFreq(int newfreq) {
        if (!this.k.I) {
            RedstoneEther.server().remReceiver(this.k, this.l, this.m, this.n, this.currentfreq);
            RedstoneEther.server().addReceiver(this.k, this.l, this.m, this.n, newfreq);
            if (this.Disabled) {
                RedstoneEther.server().jamNode(this.k, this.l, this.m, this.n, newfreq);
            }
            if (newfreq == 0) {
                this.setActive(false);
            }
        }
        super.setFreq(newfreq);
    }

    @Override
    public void addToEther() {
        RedstoneEther.server().addReceiver(this.k, this.l, this.m, this.n, this.currentfreq);
    }

    @Override
    public void removeFromEther() {
        RedstoneEther.server().remReceiver(this.k, this.l, this.m, this.n, this.currentfreq);
    }

    public String getGuiName() {
        return "Wireless Receiver";
    }

    public String getType() {
        return "wireless-receiver";
    }

    @Override
    protected void readFromPacket(Packet211TileDesc packet211tiledesc) throws IOException {
        super.readFromPacket(packet211tiledesc);
        this.changeSpinState(this.Disabled);
    }
}

