/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.renderer.CacheContext;
import de.matthiasmann.twl.renderer.lwjgl.BitmapFont;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLRenderer;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import de.matthiasmann.twl.renderer.lwjgl.TexturePostProcessing;
import de.matthiasmann.twl.utils.PNGDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GLContext;

public class LWJGLCacheContext
implements CacheContext {
    final LWJGLRenderer renderer;
    final HashMap<String, LWJGLTexture> textures;
    final HashMap<String, BitmapFont> fontCache;
    final ArrayList<LWJGLTexture> allTextures;
    boolean valid;

    protected LWJGLCacheContext(LWJGLRenderer renderer) {
        this.renderer = renderer;
        this.textures = new HashMap();
        this.fontCache = new HashMap();
        this.allTextures = new ArrayList();
        this.valid = true;
    }

    LWJGLTexture loadTexture(URL url, LWJGLTexture.Format fmt, LWJGLTexture.Filter filter) throws IOException {
        String urlString = url.toString();
        LWJGLTexture texture = this.textures.get(urlString);
        if (texture == null) {
            texture = this.createTexture(url, fmt, filter, null);
            this.textures.put(urlString, texture);
        }
        return texture;
    }

    LWJGLTexture createTexture(URL textureUrl, LWJGLTexture.Format fmt, LWJGLTexture.Filter filter, TexturePostProcessing tpp) throws IOException {
        if (!this.valid) {
            throw new IllegalStateException("CacheContext already destroyed");
        }
        InputStream is = textureUrl.openStream();
        try {
            PNGDecoder dec = new PNGDecoder(is);
            fmt = LWJGLCacheContext.decideTextureFormat(dec, fmt);
            int width = dec.getWidth();
            int height = dec.getHeight();
            int maxTextureSize = this.renderer.maxTextureSize;
            if (width > maxTextureSize || height > maxTextureSize) {
                throw new IOException("Texture size too large. Maximum supported texture by this system is " + maxTextureSize);
            }
            if (GLContext.getCapabilities().GL_EXT_abgr) {
                if (fmt == LWJGLTexture.Format.RGBA) {
                    fmt = LWJGLTexture.Format.ABGR;
                }
            } else if (fmt == LWJGLTexture.Format.ABGR) {
                fmt = LWJGLTexture.Format.RGBA;
            }
            int stride = width * fmt.getPixelSize();
            ByteBuffer buf = BufferUtils.createByteBuffer((int)(stride * height));
            dec.decode(buf, stride, fmt.getPngFormat());
            buf.flip();
            if (tpp != null) {
                tpp.process(buf, stride, width, height, fmt);
            }
            LWJGLTexture texture = new LWJGLTexture(this.renderer, width, height, buf, fmt, filter);
            this.allTextures.add(texture);
            LWJGLTexture lWJGLTexture = texture;
            return lWJGLTexture;
        }
        catch (IOException ex) {
            throw (IOException)new IOException("Unable to load PNG file: " + textureUrl).initCause(ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {}
        }
    }

    BitmapFont loadBitmapFont(URL url) throws IOException {
        String urlString = url.toString();
        BitmapFont bmFont = this.fontCache.get(urlString);
        if (bmFont == null) {
            bmFont = BitmapFont.loadFont(this.renderer, url);
            this.fontCache.put(urlString, bmFont);
        }
        return bmFont;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        try {
            for (LWJGLTexture t : this.allTextures) {
                t.destroy();
            }
            for (BitmapFont f : this.fontCache.values()) {
                f.destroy();
            }
        }
        finally {
            this.textures.clear();
            this.fontCache.clear();
            this.allTextures.clear();
            this.valid = false;
        }
    }

    private static LWJGLTexture.Format decideTextureFormat(PNGDecoder decoder, LWJGLTexture.Format fmt) {
        PNGDecoder.Format pngFormat;
        if (fmt == LWJGLTexture.Format.COLOR) {
            fmt = LWJGLCacheContext.autoColorFormat(decoder);
        }
        if (fmt.pngFormat == (pngFormat = decoder.decideTextureFormat(fmt.getPngFormat()))) {
            return fmt;
        }
        switch (pngFormat) {
            case ALPHA: {
                return LWJGLTexture.Format.ALPHA;
            }
            case LUMINANCE: {
                return LWJGLTexture.Format.LUMINANCE;
            }
            case LUMINANCE_ALPHA: {
                return LWJGLTexture.Format.LUMINANCE_ALPHA;
            }
            case RGB: {
                return LWJGLTexture.Format.RGB;
            }
            case RGBA: {
                return LWJGLTexture.Format.RGBA;
            }
            case BGRA: {
                return LWJGLTexture.Format.BGRA;
            }
            case ABGR: {
                return LWJGLTexture.Format.ABGR;
            }
        }
        throw new UnsupportedOperationException("PNGFormat not handled: " + (Object)((Object)pngFormat));
    }

    private static LWJGLTexture.Format autoColorFormat(PNGDecoder decoder) {
        if (decoder.hasAlpha()) {
            if (decoder.isRGB()) {
                return LWJGLTexture.Format.ABGR;
            }
            return LWJGLTexture.Format.LUMINANCE_ALPHA;
        }
        if (decoder.isRGB()) {
            return LWJGLTexture.Format.ABGR;
        }
        return LWJGLTexture.Format.LUMINANCE;
    }
}

