/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.renderer.lwjgl;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.Texture;
import de.matthiasmann.twl.renderer.lwjgl.LWJGLTexture;
import org.lwjgl.opengl.GL11;

public class TextureAreaRotated
implements Image {
    protected static final int REPEAT_CACHE_SIZE = 10;
    private final LWJGLTexture texture;
    private final Color tintColor;
    private final float txTL;
    private final float tyTL;
    private final float txTR;
    private final float tyTR;
    private final float txBL;
    private final float tyBL;
    private final float txBR;
    private final float tyBR;
    private final char width;
    private final char height;
    private final boolean tiled;
    protected int repeatCacheID = -1;

    public TextureAreaRotated(LWJGLTexture texture, int x, int y, int width, int height, Color tintColor, boolean tiled, Texture.Rotation rotation) {
        if (rotation == Texture.Rotation.CLOCKWISE_90 || rotation == Texture.Rotation.CLOCKWISE_270) {
            this.width = (char)Math.abs(height);
            this.height = (char)Math.abs(width);
        } else {
            this.width = (char)Math.abs(width);
            this.height = (char)Math.abs(height);
        }
        float fx = x;
        float fy = y;
        if (width == 1) {
            fx += 0.5f;
            width = 0;
        } else if (width < -1) {
            fx -= (float)(width + 1);
        }
        if (height == 1) {
            fy += 0.5f;
            height = 0;
        } else if (height < -1) {
            fy -= (float)(height + 1);
        }
        float texWidth = texture.getTexWidth();
        float texHeight = texture.getTexHeight();
        float tx0 = fx / texWidth;
        float ty0 = fy / texHeight;
        float tx1 = tx0 + (float)width / texWidth;
        float ty1 = ty0 + (float)height / texHeight;
        switch (rotation) {
            default: {
                this.txTL = this.txBL = tx0;
                this.txTR = this.txBR = tx1;
                this.tyTL = this.tyTR = ty0;
                this.tyBL = this.tyBR = ty1;
                break;
            }
            case CLOCKWISE_90: {
                this.txTL = tx0;
                this.tyTL = ty1;
                this.txTR = tx0;
                this.tyTR = ty0;
                this.txBL = tx1;
                this.tyBL = ty1;
                this.txBR = tx1;
                this.tyBR = ty0;
                break;
            }
            case CLOCKWISE_180: {
                this.txTL = tx1;
                this.tyTL = ty1;
                this.txTR = tx0;
                this.tyTR = ty1;
                this.txBL = tx1;
                this.tyBL = ty0;
                this.txBR = tx0;
                this.tyBR = ty0;
                break;
            }
            case CLOCKWISE_270: {
                this.txTL = tx1;
                this.tyTL = ty0;
                this.txTR = tx1;
                this.tyTR = ty1;
                this.txBL = tx0;
                this.tyBL = ty0;
                this.txBR = tx0;
                this.tyBR = ty1;
            }
        }
        this.texture = texture;
        this.tintColor = tintColor == null ? Color.WHITE : tintColor;
        this.tiled = tiled;
    }

    TextureAreaRotated(TextureAreaRotated src, Color tintColor) {
        this.txTL = src.txTL;
        this.tyTL = src.tyTL;
        this.txTR = src.txTR;
        this.tyTR = src.tyTR;
        this.txBL = src.txBL;
        this.tyBL = src.tyBL;
        this.txBR = src.txBR;
        this.tyBR = src.tyBR;
        this.width = src.width;
        this.height = src.height;
        this.texture = src.texture;
        this.tiled = src.tiled;
        this.tintColor = tintColor;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void draw(AnimationState as, int x, int y) {
        this.draw(as, x, y, this.width, this.height);
    }

    @Override
    public void draw(AnimationState as, int x, int y, int w, int h) {
        if (this.texture.bind(this.tintColor)) {
            if (this.tiled) {
                this.drawTiled(x, y, w, h);
            } else {
                GL11.glBegin((int)7);
                this.drawQuad(x, y, w, h);
                GL11.glEnd();
            }
        }
    }

    private void drawRepeat(int x, int y, int repeatCountX, int repeatCountY) {
        GL11.glBegin((int)7);
        char w = this.width;
        char h = this.height;
        while (repeatCountY-- > 0) {
            int curX = x;
            int cntX = repeatCountX;
            while (cntX-- > 0) {
                this.drawQuad(curX, y, w, h);
                curX += w;
            }
            y += h;
        }
        GL11.glEnd();
    }

    private void drawTiled(int x, int y, int w, int h) {
        int repeatCountX = w / this.width;
        int repeatCountY = h / this.height;
        if (repeatCountX < 10 || repeatCountY < 10) {
            this.drawRepeat(x, y, repeatCountX, repeatCountY);
        } else {
            this.drawRepeatCached(x, y, repeatCountX, repeatCountY);
        }
        int drawnX = repeatCountX * this.width;
        int drawnY = repeatCountY * this.height;
        int restWidth = w - drawnX;
        int restHeight = h - drawnY;
        if (restWidth > 0 || restHeight > 0) {
            GL11.glBegin((int)7);
            if (restWidth > 0 && repeatCountY > 0) {
                this.drawClipped(x + drawnX, y, restWidth, this.height, 1, repeatCountY);
            }
            if (restHeight > 0) {
                if (repeatCountX > 0) {
                    this.drawClipped(x, y + drawnY, this.width, restHeight, repeatCountX, 1);
                }
                if (restWidth > 0) {
                    this.drawClipped(x + drawnX, y + drawnY, restWidth, restHeight, 1, 1);
                }
            }
            GL11.glEnd();
        }
    }

    protected void drawRepeatCached(int x, int y, int repeatCountX, int repeatCountY) {
        int cacheBlocksX;
        int repeatsByCacheX;
        if (this.repeatCacheID < 0) {
            this.createRepeatCache();
        }
        if (repeatCountX > (repeatsByCacheX = (cacheBlocksX = repeatCountX / 10) * 10)) {
            this.drawRepeat(x + this.width * repeatsByCacheX, y, repeatCountX - repeatsByCacheX, repeatCountY);
        }
        do {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glCallList((int)this.repeatCacheID);
            for (int i = 1; i < cacheBlocksX; ++i) {
                GL11.glTranslatef((float)(this.width * 10), (float)0.0f, (float)0.0f);
                GL11.glCallList((int)this.repeatCacheID);
            }
            GL11.glPopMatrix();
            y += this.height * 10;
        } while ((repeatCountY -= 10) >= 10);
        if (repeatCountY > 0) {
            this.drawRepeat(x, y, repeatsByCacheX, repeatCountY);
        }
    }

    private void drawClipped(int x, int y, int width, int height, int repeatCountX, int repeatCountY) {
        float f;
        float ctxTL = this.txTL;
        float ctyTL = this.tyTL;
        float ctxTR = this.txTR;
        float ctyTR = this.tyTR;
        float ctxBL = this.txBL;
        float ctyBL = this.tyBL;
        float ctxBR = this.txBR;
        float ctyBR = this.tyBR;
        if (this.width > '\u0001') {
            f = (float)width / (float)this.width;
            ctxTR = ctxTL + (ctxTR - ctxTL) * f;
            ctyTR = ctyTL + (ctyTR - ctyTL) * f;
            ctxBR = ctxBL + (ctxBR - ctxBL) * f;
            ctyBR = ctyBL + (ctyBR - ctyBL) * f;
        }
        if (this.height > '\u0001') {
            f = (float)height / (float)this.height;
            ctxBL = ctxTL + (ctxBL - ctxTL) * f;
            ctyBL = ctyTL + (ctyBL - ctyTL) * f;
            ctxBR = ctxTR + (ctxBR - ctxTR) * f;
            ctyBR = ctyTR + (ctyBR - ctyTR) * f;
        }
        while (repeatCountY-- > 0) {
            int y1 = y + height;
            int x0 = x;
            int cx = repeatCountX;
            while (cx-- > 0) {
                int x1 = x0 + width;
                GL11.glTexCoord2f((float)ctxTL, (float)ctyTL);
                GL11.glVertex2i((int)x0, (int)y);
                GL11.glTexCoord2f((float)ctxBL, (float)ctyBL);
                GL11.glVertex2i((int)x0, (int)y1);
                GL11.glTexCoord2f((float)ctxBR, (float)ctyBR);
                GL11.glVertex2i((int)x1, (int)y1);
                GL11.glTexCoord2f((float)ctxTR, (float)ctyTR);
                GL11.glVertex2i((int)x1, (int)y);
                x0 = x1;
            }
            y = y1;
        }
    }

    private void drawQuad(int x, int y, int w, int h) {
        GL11.glTexCoord2f((float)this.txTL, (float)this.tyTL);
        GL11.glVertex2i((int)x, (int)y);
        GL11.glTexCoord2f((float)this.txBL, (float)this.tyBL);
        GL11.glVertex2i((int)x, (int)(y + h));
        GL11.glTexCoord2f((float)this.txBR, (float)this.tyBR);
        GL11.glVertex2i((int)(x + w), (int)(y + h));
        GL11.glTexCoord2f((float)this.txTR, (float)this.tyTR);
        GL11.glVertex2i((int)(x + w), (int)y);
    }

    private void createRepeatCache() {
        this.repeatCacheID = GL11.glGenLists((int)1);
        this.texture.renderer.rotatedTextureAreas.add(this);
        GL11.glNewList((int)this.repeatCacheID, (int)4864);
        this.drawRepeat(0, 0, 10, 10);
        GL11.glEndList();
    }

    void destroyRepeatCache() {
        GL11.glDeleteLists((int)this.repeatCacheID, (int)1);
        this.repeatCacheID = -1;
    }

    @Override
    public Image createTintedVersion(Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        Color newTintColor = this.tintColor.multiply(color);
        if (newTintColor.equals(this.tintColor)) {
            return this;
        }
        return new TextureAreaRotated(this, newTintColor);
    }
}

