/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.core;

import codechicken.core.inventory.GuiScrollSlot;
import codechicken.core.inventory.IGuiIndirectButtons;
import codechicken.wirelessredstone.core.RedstoneEther;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class GuiNameSlot
extends GuiScrollSlot {
    private ArrayList names;
    private String match = "";
    private int selectedslot = -1;
    final atq fontRenderer;

    public GuiNameSlot(int x, int y, atq fontrenderer, IGuiIndirectButtons parent) {
        super(parent);
        this.setSize(x, y, 150, 71);
        this.fontRenderer = fontrenderer;
        this.names = new ArrayList();
    }

    public int getSlotHeight() {
        return 10;
    }

    protected int getNumSlots() {
        return this.names.size();
    }

    public void drawOverlay() {
        super.drawOverlay();
        GuiNameSlot.a((int)this.x, (int)(this.y - 7), (int)(this.x + this.width), (int)(this.y - 1), (int)-3750202);
        GuiNameSlot.a((int)this.x, (int)(this.y + this.height + 1), (int)(this.x + this.width), (int)(this.y + this.height + 6), (int)-3750202);
    }

    protected void drawSlot(int slot, int x, int y, boolean selected) {
        String name = (String)this.names.get(slot);
        int colour = selected ? 0xF0F0F0 : (!GuiNameSlot.doesNameMatch(name, this.match) ? 0x707070 : 0xA0A0A0);
        this.fontRenderer.b(name, x, y, colour);
    }

    protected void slotClicked(int slot, boolean doubleclick) {
        if (doubleclick) {
            this.parentscreen.buttonPressed(this.activatebutton);
        } else {
            this.selectedslot = slot;
        }
    }

    protected boolean isSlotSelected(int slot) {
        return slot == this.selectedslot;
    }

    public void selectNext() {
        if (this.selectedslot == -1) {
            return;
        }
        ++this.selectedslot;
        if (this.selectedslot == this.getNumSlots()) {
            --this.selectedslot;
        }
        this.showSlot(this.selectedslot);
    }

    public void selectPrev() {
        if (this.selectedslot == -1) {
            return;
        }
        --this.selectedslot;
        if (this.selectedslot == -1) {
            ++this.selectedslot;
        }
        this.showSlot(this.selectedslot);
    }

    protected void unfocus() {
        this.selectedslot = -1;
    }

    private void sortNames() {
        Collections.sort(this.names, new NameSlotComparator());
    }

    public void updateNameList(qx player, String match) {
        this.names = RedstoneEther.get(true).getAllowedNames(player);
        this.match = match;
        this.sortNames();
    }

    public void removeName(String name) {
        this.names.remove(name);
        this.sortNames();
    }

    public void addName(String name) {
        this.names.add(name);
        this.sortNames();
    }

    public void clearNameList() {
        this.names.clear();
    }

    public static boolean doesNameMatch(String name, String match) {
        return name.length() >= match.length() && name.substring(0, match.length()).equalsIgnoreCase(match);
    }

    public String getSelectedName() {
        if (this.selectedslot == -1) {
            return "";
        }
        return (String)this.names.get(this.selectedslot);
    }

    public class NameSlotComparator
    implements Comparator {
        public int compare(String s1, String s2) {
            boolean match2;
            boolean match1 = GuiNameSlot.doesNameMatch(s1, GuiNameSlot.this.match);
            if (match1 == (match2 = GuiNameSlot.doesNameMatch(s2, GuiNameSlot.this.match))) {
                return s1.compareToIgnoreCase(s2);
            }
            return match1 ? -1 : 1;
        }
    }
}

