/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei;

import codechicken.nei.MultiItemRange;
import codechicken.nei.api.API;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import forestry.api.apiculture.IArmorApiarist;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.BlockInterface;
import forestry.api.core.ItemInterface;
import forestry.api.recipes.IGenericCrate;
import forestry.storage.items.ItemBackpack;
import mistaqur.nei.NEIPlugins;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.IPlugin;
import mistaqur.nei.forestry.BiogasFuelHandler;
import mistaqur.nei.forestry.CarpenterRecipeHandler;
import mistaqur.nei.forestry.CentrifugeRecipeHandler;
import mistaqur.nei.forestry.FabricatorRecipeHandler;
import mistaqur.nei.forestry.FermenterRecipeHandler;
import mistaqur.nei.forestry.ForestryFuelHelper;
import mistaqur.nei.forestry.MoistenerRecipeHandler;
import mistaqur.nei.forestry.PeatFuelHandler;
import mistaqur.nei.forestry.ShapedCustomRecipeHandler;
import mistaqur.nei.forestry.SqueezerRecipeHandler;
import mistaqur.nei.forestry.StillRecipeHandler;

public class NEIPlugins_Forestry
implements IPlugin {
    public static final String PLUGIN_NAME = "Forestry";
    public static final String PLUGIN_VERSION = "1.4.3.0";
    public static final String REQUIRED_MOD = "Forestry@(2.0,)";

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return NEIPlugins.getMod().hasMod(REQUIRED_MOD);
    }

    @Override
    public void init() {
        this.addHandlers();
        this.configureItemPanel();
    }

    private void addHandlers() {
        API.registerRecipeHandler((ICraftingHandler)new FabricatorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new FabricatorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CarpenterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CarpenterRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new MoistenerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new MoistenerRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new CentrifugeRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new CentrifugeRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new SqueezerRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new SqueezerRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new StillRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new StillRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new FermenterRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new FermenterRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new ShapedCustomRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new ShapedCustomRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new BiogasFuelHandler());
        API.registerUsageHandler((IUsageHandler)new BiogasFuelHandler());
        API.registerRecipeHandler((ICraftingHandler)new PeatFuelHandler());
        API.registerUsageHandler((IUsageHandler)new PeatFuelHandler());
        FuelTooltipHandler.addFuelHelper(new ForestryFuelHelper());
    }

    private void configureItemPanel() {
        try {
            this.hideExtra();
            this.addSubsets();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void hideExtraBlock(String name, int maxDamage) {
        ur res = BlockInterface.getBlock((String)name);
        if (res != null) {
            API.setMaxDamageException((int)res.c, (int)0);
        }
    }

    private void hideExtraItem(String name, int maxDamage) {
        ur res = ItemInterface.getItem((String)name);
        if (res != null) {
            API.setMaxDamageException((int)res.c, (int)0);
        }
    }

    public void hideExtra() {
        API.hideItem((int)ItemInterface.getItem((String)"beeQueenGE").c);
        API.hideItem((int)BlockInterface.getBlock((String)"saplingGE").c);
    }

    public void addSetRangeFromItem(String setname, ur stack) {
        MultiItemRange t = new MultiItemRange();
        if (stack != null) {
            t.add(stack.c);
            API.addSetRange((String)setname, (MultiItemRange)t);
        }
    }

    public void addItemToRange(MultiItemRange range, String name) {
        ur res = ItemInterface.getItem((String)name);
        if (res != null) {
            range.add(res.c);
        }
    }

    public void addItemWithDamageToRange(MultiItemRange range, String name, int damageStart, int damageEnd) {
        ur res = ItemInterface.getItem((String)name);
        if (res != null) {
            range.add(res.c, damageStart, damageEnd);
        }
    }

    public void addBlockToRange(MultiItemRange range, String name) {
        ur res = BlockInterface.getBlock((String)name);
        if (res != null) {
            range.add(res.c);
        }
    }

    public void addSubsets() {
        int i;
        MultiItemRange crated = new MultiItemRange();
        MultiItemRange apiaryFrames = new MultiItemRange();
        MultiItemRange armorApiarist = new MultiItemRange();
        MultiItemRange circuits = new MultiItemRange();
        MultiItemRange can = new MultiItemRange();
        MultiItemRange waxCapsule = new MultiItemRange();
        MultiItemRange refractoryCapsule = new MultiItemRange();
        MultiItemRange beeitems = new MultiItemRange();
        MultiItemRange tools = new MultiItemRange();
        MultiItemRange backpacks = new MultiItemRange();
        MultiItemRange wovenBackpacks = new MultiItemRange();
        MultiItemRange slabs = new MultiItemRange();
        MultiItemRange logs = new MultiItemRange();
        MultiItemRange planks = new MultiItemRange();
        MultiItemRange fences = new MultiItemRange();
        MultiItemRange alvearyParts = new MultiItemRange();
        MultiItemRange otherBlocks = new MultiItemRange();
        MultiItemRange liquids = new MultiItemRange();
        MultiItemRange parts = new MultiItemRange();
        MultiItemRange liquidContainers = new MultiItemRange();
        MultiItemRange foods = new MultiItemRange();
        MultiItemRange otherItems = new MultiItemRange();
        MultiItemRange carpenterItems = new MultiItemRange();
        for (up i2 : up.e) {
            if (i2 instanceof IGenericCrate) {
                crated.add(i2.cj);
            }
            if (i2 instanceof IHiveFrame) {
                apiaryFrames.add(i2.cj);
            }
            if (i2 instanceof IArmorApiarist) {
                armorApiarist.add(i2.cj);
            }
            if (!(i2 instanceof ItemBackpack)) continue;
            backpacks.add(i2.cj);
        }
        can.add(ItemInterface.getItem((String)"canWater"));
        can.add(ItemInterface.getItem((String)"canBiomass"));
        can.add(ItemInterface.getItem((String)"canBiofuel"));
        can.add(ItemInterface.getItem((String)"canOil"));
        can.add(ItemInterface.getItem((String)"canFuel"));
        can.add(ItemInterface.getItem((String)"canLava"));
        can.add(ItemInterface.getItem((String)"canSeedOil"));
        can.add(ItemInterface.getItem((String)"canHoney"));
        can.add(ItemInterface.getItem((String)"canJuice"));
        can.add(ItemInterface.getItem((String)"canIce"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryWater"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryBiomass"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryBiofuel"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryOil"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryFuel"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryLava"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractorySeedOil"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryHoney"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryJuice"));
        refractoryCapsule.add(ItemInterface.getItem((String)"refractoryIce"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleWater"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleBiomass"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleBiofuel"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleOil"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleFuel"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleSeedOil"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleHoney"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleJuice"));
        waxCapsule.add(ItemInterface.getItem((String)"waxCapsuleIce"));
        this.addItemToRange(tools, "wrench");
        this.addItemToRange(tools, "pipette");
        this.addItemToRange(tools, "solderingIron");
        this.addItemToRange(tools, "biomeFinder");
        this.addItemToRange(tools, "imprinter");
        this.addItemToRange(tools, "beealyzer");
        this.addItemToRange(tools, "infuser");
        this.addItemToRange(tools, "scoop");
        this.addItemToRange(tools, "bronzePickaxe");
        this.addItemToRange(tools, "bronzeShovel");
        this.addItemToRange(beeitems, "waxCast");
        this.addItemToRange(beeitems, "refractoryWax");
        this.addItemToRange(beeitems, "phosphor");
        this.addItemToRange(beeitems, "royalJelly");
        this.addItemToRange(beeitems, "honeydew");
        this.addItemToRange(beeitems, "propolis");
        this.addItemToRange(beeitems, "pollen");
        this.addItemToRange(beeitems, "beeswax");
        this.addItemToRange(beeitems, "honeyDrop");
        this.addItemWithDamageToRange(beeitems, "craftingMaterial", 5, 5);
        this.addItemWithDamageToRange(beeitems, "craftingMaterial", 2, 2);
        this.addItemToRange(apiaryFrames, "frameUntreated");
        this.addItemToRange(apiaryFrames, "frameImpregnated");
        this.addItemToRange(apiaryFrames, "frameProven");
        this.addItemWithDamageToRange(otherItems, "craftingMaterial", 0, 1);
        this.addItemWithDamageToRange(otherItems, "craftingMaterial", 3, 4);
        this.addItemToRange(otherItems, "iodineCharge");
        this.addItemToRange(otherItems, "fertilizerBio");
        this.addItemToRange(otherItems, "fertilizerCompound");
        this.addItemToRange(otherItems, "apatite");
        this.addItemToRange(otherItems, "ingotCopper");
        this.addItemToRange(otherItems, "ingotTin");
        this.addItemToRange(otherItems, "ingotBronze");
        this.addItemToRange(otherItems, "letters");
        this.addItemToRange(otherItems, "vialCatalyst");
        this.addItemToRange(otherItems, "mouldyWheat");
        this.addItemToRange(otherItems, "decayingWheat");
        this.addItemToRange(otherItems, "mulch");
        this.addItemToRange(otherItems, "peat");
        this.addItemToRange(otherItems, "bituminousPeat");
        this.addItemToRange(otherItems, "ash");
        this.addItemToRange(carpenterItems, "stickImpregnated");
        this.addItemToRange(carpenterItems, "woodPulp");
        this.addItemToRange(carpenterItems, "carton");
        this.addItemToRange(carpenterItems, "crate");
        this.addItemToRange(carpenterItems, "kitPickaxe");
        this.addItemToRange(carpenterItems, "kitShovel");
        this.addItemToRange(carpenterItems, "brokenBronzeShovel");
        this.addItemToRange(carpenterItems, "brokenBronzePickaxe");
        this.addItemToRange(liquids, "bucketBiomass");
        this.addItemToRange(liquids, "bucketBiofuel");
        this.addItemToRange(liquids, "liquidBiomass");
        this.addItemToRange(liquids, "liquidBiofuel");
        this.addItemToRange(liquids, "liquidSeedOil");
        this.addItemToRange(liquids, "liquidJuice");
        this.addItemToRange(liquids, "liquidHoney");
        this.addItemToRange(liquids, "liquidMead");
        this.addItemToRange(liquids, "liquidGlass");
        this.addItemToRange(liquids, "liquidIce");
        this.addItemToRange(liquids, "liquidMilk");
        for (i = 1; i <= 4; ++i) {
            this.addBlockToRange(slabs, "slabs" + i);
        }
        for (i = 1; i <= 8; ++i) {
            this.addBlockToRange(logs, "log" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addBlockToRange(planks, "planks" + i);
        }
        for (i = 1; i <= 2; ++i) {
            this.addBlockToRange(fences, "fences" + i);
        }
        this.addBlockToRange(alvearyParts, "alveary");
        this.addBlockToRange(alvearyParts, "swarmer");
        this.addBlockToRange(alvearyParts, "heater");
        this.addBlockToRange(alvearyParts, "fan");
        this.addBlockToRange(otherBlocks, "candle");
        this.addBlockToRange(otherBlocks, "stump");
        this.addItemToRange(parts, "gearBronze");
        this.addItemToRange(parts, "gearCopper");
        this.addItemToRange(parts, "gearTin");
        this.addItemToRange(parts, "sturdyCasing");
        this.addItemToRange(parts, "hardenedCasing");
        this.addItemToRange(parts, "impregnatedCasing");
        this.addItemWithDamageToRange(parts, "craftingMaterial", 6, 6);
        this.addItemToRange(foods, "ambrosia");
        this.addItemToRange(foods, "honeyedSlice");
        this.addItemToRange(foods, "honeyPot");
        this.addItemToRange(foods, "beverage");
        this.addItemToRange(liquidContainers, "canEmpty");
        this.addItemToRange(liquidContainers, "waxCapsule");
        this.addItemToRange(liquidContainers, "refractoryEmpty");
        API.addSetRange((String)"Forestry.Machines.Alveary", (MultiItemRange)alvearyParts);
        this.addSetRangeFromItem("Forestry.Machines.Farms", BlockInterface.getBlock((String)"farm"));
        this.addSetRangeFromItem("Forestry.Machines.Planters", BlockInterface.getBlock((String)"planter"));
        this.addSetRangeFromItem("Forestry.Machines.Harversers", BlockInterface.getBlock((String)"harvester"));
        this.addSetRangeFromItem("Forestry.Machines.Engines", BlockInterface.getBlock((String)"engine"));
        this.addSetRangeFromItem("Forestry.Machines.Mills", BlockInterface.getBlock((String)"mill"));
        this.addSetRangeFromItem("Forestry.Machines.Other", BlockInterface.getBlock((String)"machine"));
        API.addSetRange((String)"Forestry.Blocks.Logs", (MultiItemRange)logs);
        API.addSetRange((String)"Forestry.Blocks.Planks", (MultiItemRange)planks);
        API.addSetRange((String)"Forestry.Blocks.Fences", (MultiItemRange)fences);
        this.addSetRangeFromItem("Forestry.Blocks.Stairs", BlockInterface.getBlock((String)"stairs"));
        this.addSetRangeFromItem("Forestry.Blocks.Glass", BlockInterface.getBlock((String)"glass"));
        API.addSetRange((String)"Forestry.Blocks.Slabs", (MultiItemRange)slabs);
        API.addSetRange((String)"Forestry.Blocks.Other", (MultiItemRange)otherBlocks);
        this.addSetRangeFromItem("Forestry.Bees.Drones", ItemInterface.getItem((String)"beeDroneGE"));
        this.addSetRangeFromItem("Forestry.Bees.Princesses", ItemInterface.getItem((String)"beePrincessGE"));
        this.addSetRangeFromItem("Forestry.Bees.Combs", ItemInterface.getItem((String)"beeComb"));
        API.addSetRange((String)"Forestry.Bees.Items", (MultiItemRange)beeitems);
        this.addSetRangeFromItem("Forestry.Trees.Saplings", ItemInterface.getItem((String)"sapling"));
        this.addSetRangeFromItem("Forestry.Trees.Fruits", ItemInterface.getItem((String)"fruits"));
        this.addSetRangeFromItem("Forestry.Items.Tubes", ItemInterface.getItem((String)"tubes"));
        this.addSetRangeFromItem("Forestry.Items.Circuit Boards", ItemInterface.getItem((String)"circuitboards"));
        API.addSetRange((String)"Forestry.Items.Apiary Frames", (MultiItemRange)apiaryFrames);
        API.addSetRange((String)"Forestry.Items.Parts", (MultiItemRange)parts);
        this.addSetRangeFromItem("Forestry.Items.Stamps", ItemInterface.getItem((String)"stamps"));
        this.addSetRangeFromItem("Forestry.World.Ores", BlockInterface.getBlock((String)"resources"));
        this.addSetRangeFromItem("Forestry.World.Soils", BlockInterface.getBlock((String)"soil"));
        this.addSetRangeFromItem("Forestry.World.Hives", BlockInterface.getBlock((String)"beehives"));
        API.addSetRange((String)"Forestry.Items.Tools", (MultiItemRange)tools);
        API.addSetRange((String)"Forestry.Items.Carpenter", (MultiItemRange)carpenterItems);
        API.addSetRange((String)"Forestry.Items.Other", (MultiItemRange)otherItems);
        API.addSetRange((String)"Forestry.Armor.Apiarist", (MultiItemRange)armorApiarist);
        API.addSetRange((String)"Forestry.Backpacks", (MultiItemRange)backpacks);
        API.addSetRange((String)"Forestry.Crated", (MultiItemRange)crated);
        API.addSetRange((String)"Forestry.Foods", (MultiItemRange)foods);
        API.addSetRange((String)"Forestry.Liquids.Containers", (MultiItemRange)liquidContainers);
        API.addSetRange((String)"Forestry.Liquids.Cans", (MultiItemRange)can);
        API.addSetRange((String)"Forestry.Liquids.Wax Capsules", (MultiItemRange)waxCapsule);
        API.addSetRange((String)"Forestry.Liquids.Refractory", (MultiItemRange)refractoryCapsule);
        API.addSetRange((String)"Forestry.Liquids", (MultiItemRange)liquids);
    }
}

