/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.common;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.forge.IContainerTooltipHandler;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mistaqur.nei.common.IFuelHelper;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class FuelTooltipHandler
implements IContainerTooltipHandler {
    public static DecimalFormat heatFormat = new DecimalFormat("0.#");
    private static List helpers = new ArrayList();
    protected static boolean showContextTooltip;
    protected static boolean showLiquidContainerFuelTooltip;
    protected static boolean showItemStackFuelTooltip;

    public List handleTooltipFirst(avf gui, int mousex, int mousey, List currenttip) {
        return currenttip;
    }

    public static String compactValueF(float value) {
        if (value > 99.0f) {
            return heatFormat.format((float)Math.round(value / 100.0f) / 10.0f) + "k";
        }
        return Integer.toString(Math.round(value));
    }

    public static String compactValue(int value) {
        if (value > 99 && value % 100 == 0) {
            return heatFormat.format((float)value / 1000.0f) + "k";
        }
        return Integer.toString(value);
    }

    public static String convertHeatValue(int value, int second) {
        return FuelTooltipHandler.compactValue(value) + " heat";
    }

    public static void addFuelHelper(IFuelHelper helper) {
        helpers.add(helper);
    }

    public static List getLiquidStackFuelTooltip(LiquidStack liquid) {
        if (liquid == null) {
            return null;
        }
        List currenttip = new ArrayList();
        for (IFuelHelper helper : helpers) {
            currenttip = helper.getLiquidStackFuelTooltip(liquid, currenttip);
        }
        return currenttip;
    }

    public static List getItemStackFuelTooltip(ur stack) {
        if (stack == null) {
            return null;
        }
        List currenttip = new ArrayList();
        for (IFuelHelper helper : helpers) {
            currenttip = helper.getItemStackFuelTooltip(stack, currenttip);
        }
        return currenttip;
    }

    public static void updateSettings() {
        showContextTooltip = NEIClientConfig.getBooleanSetting((String)"mistaqur.showContextTooltip");
        showLiquidContainerFuelTooltip = NEIClientConfig.getBooleanSetting((String)"mistaqur.showLiquidContainerFuelTooltip");
        showItemStackFuelTooltip = NEIClientConfig.getBooleanSetting((String)"mistaqur.showItemStackFuelTooltip");
    }

    public List handleItemTooltip(avf gui, ur stack, List currenttip) {
        List fuelItemTooltip;
        List fuelLiquidTooltip;
        if (stack == null) {
            return currenttip;
        }
        boolean skip = false;
        boolean haveTooltip = false;
        if (showContextTooltip) {
            for (IFuelHelper helper : helpers) {
                if (!helper.haveContextTooltip(gui)) continue;
                currenttip = helper.getContextTooltip(gui, stack, currenttip);
                skip = true;
                break;
            }
        }
        if (!skip) {
            for (IFuelHelper helper : helpers) {
                currenttip = helper.getBeforeTooltip(gui, stack, currenttip);
            }
        }
        if (!skip && showLiquidContainerFuelTooltip && (fuelLiquidTooltip = FuelTooltipHandler.getLiquidStackFuelTooltip(LiquidContainerRegistry.getLiquidForFilledItem((ur)stack))) != null && fuelLiquidTooltip.size() > 0) {
            if (!haveTooltip) {
                haveTooltip = true;
                currenttip.add("\u00a77Can produce:");
            }
            currenttip.addAll(fuelLiquidTooltip);
        }
        if (!skip && showItemStackFuelTooltip && (fuelItemTooltip = FuelTooltipHandler.getItemStackFuelTooltip(stack)) != null && fuelItemTooltip.size() > 0) {
            if (!haveTooltip) {
                haveTooltip = true;
                currenttip.add("\u00a77Can produce:");
            }
            currenttip.addAll(fuelItemTooltip);
        }
        return currenttip;
    }
}

