/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.forestry;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.utils.StringUtil;
import java.util.List;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.IFuelHelper;
import net.minecraftforge.liquids.LiquidStack;

public class ForestryFuelHelper
implements IFuelHelper {
    @Override
    public List getContextTooltip(avf gui, ur stack, List currenttip) {
        return currenttip;
    }

    @Override
    public List getBeforeTooltip(avf gui, ur stack, List currenttip) {
        return currenttip;
    }

    @Override
    public boolean haveContextTooltip(avf gui) {
        return false;
    }

    @Override
    public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
        EngineBronzeFuel bronzeFuel;
        GeneratorFuel generatorFuel = (GeneratorFuel)GeneratorFuel.fuels.get(liquid.itemID);
        if (generatorFuel != null) {
            currenttip.add("\u00a77" + FuelTooltipHandler.compactValueF(liquid.amount * generatorFuel.eu / generatorFuel.fuelConsumed.amount) + " EU at " + generatorFuel.eu / generatorFuel.rate + " EU/t (" + StringUtil.localize((String)"tile.machine.4") + ")");
        }
        if ((bronzeFuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.get(liquid)) != null) {
            currenttip.add("\u00a77" + bronzeFuel.powerPerCycle + " MJ/t for " + bronzeFuel.burnDuration + " ticks (" + StringUtil.localize((String)"tile.engine.0") + ")");
        }
        return currenttip;
    }

    @Override
    public List getItemStackFuelTooltip(ur stack, List currenttip) {
        EngineCopperFuel copperFuel = (EngineCopperFuel)FuelManager.copperEngineFuel.get(stack);
        if (copperFuel != null) {
            currenttip.add("\u00a77" + copperFuel.powerPerCycle + " MJ/t for " + copperFuel.burnDuration + " ticks (" + StringUtil.localize((String)"tile.engine.1") + ")");
        }
        return currenttip;
    }
}

