/*
 * Decompiled with CFR 0.152.
 */
package mistaqur.nei.railcraft;

import java.util.List;
import mistaqur.nei.common.FuelTooltipHandler;
import mistaqur.nei.common.IFuelHelper;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.fuel.FuelManager;
import railcraft.common.util.misc.MiscTools;

public class RCFuelHelper
implements IFuelHelper {
    public static Class guiCartBore;
    public static Class guiBoilerSolid;
    public static Class guiEngineSteamHobby;

    @Override
    public List getContextTooltip(avf gui, ur stack, List currenttip) {
        int value = this.getHeatValue(stack);
        if (value > 0) {
            currenttip.add("Can produce: " + FuelTooltipHandler.convertHeatValue(value, 1) + " ");
        }
        return currenttip;
    }

    @Override
    public List getBeforeTooltip(avf gui, ur stack, List currenttip) {
        return currenttip;
    }

    @Override
    public boolean haveContextTooltip(avf gui) {
        return guiCartBore != null && guiBoilerSolid != null && guiEngineSteamHobby != null && (guiCartBore.isInstance(gui) || guiBoilerSolid.isInstance(gui) || guiEngineSteamHobby.isInstance(gui));
    }

    public String getInfoIfZeroHeat() {
        return "Can't be burned in Railcraft";
    }

    public String getInfoForMod() {
        return "(Railcraft)";
    }

    public int getHeatValue(ur stack) {
        try {
            return MiscTools.getItemBurnTime((ur)stack);
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    @Override
    public List getLiquidStackFuelTooltip(LiquidStack liquid, List currenttip) {
        int boilerFuelValue = FuelManager.getBoilerFuelValue((LiquidStack)liquid);
        if (boilerFuelValue > 0) {
            currenttip.add("\u00a77" + FuelTooltipHandler.convertHeatValue(boilerFuelValue, 1) + " (Liquid Fueled Firebox)");
        }
        return currenttip;
    }

    @Override
    public List getItemStackFuelTooltip(ur stack, List currenttip) {
        int boilerFuelValue = MiscTools.getItemBurnTime((ur)stack);
        if (boilerFuelValue > 0) {
            currenttip.add("\u00a77" + FuelTooltipHandler.convertHeatValue(boilerFuelValue, 1) + " (Solid Fueled Firebox)");
        }
        return currenttip;
    }
}

