/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftSilicon;
import buildcraft.BuildCraftTransport;
import buildcraft.additionalpipes.ChunkLoadViewDataProxy;
import buildcraft.additionalpipes.MutiPlayerProxy;
import buildcraft.additionalpipes.chunkloader.BlockChunkLoader;
import buildcraft.additionalpipes.chunkloader.ChunkLoadingHandler;
import buildcraft.additionalpipes.chunkloader.TileChunkLoader;
import buildcraft.additionalpipes.gates.GateProvider;
import buildcraft.additionalpipes.gates.TriggerPhasedSignal;
import buildcraft.additionalpipes.gates.TriggerPipeClosed;
import buildcraft.additionalpipes.gui.GuiHandler;
import buildcraft.additionalpipes.network.NetworkHandler;
import buildcraft.additionalpipes.pipes.PipeItemsAdvancedInsertion;
import buildcraft.additionalpipes.pipes.PipeItemsAdvancedWood;
import buildcraft.additionalpipes.pipes.PipeItemsClosed;
import buildcraft.additionalpipes.pipes.PipeItemsDistributor;
import buildcraft.additionalpipes.pipes.PipeItemsRedstone;
import buildcraft.additionalpipes.pipes.PipeItemsTeleport;
import buildcraft.additionalpipes.pipes.PipeLiquidsRedstone;
import buildcraft.additionalpipes.pipes.PipeLiquidsTeleport;
import buildcraft.additionalpipes.pipes.PipeLiquidsWaterPump;
import buildcraft.additionalpipes.pipes.PipePowerTeleport;
import buildcraft.additionalpipes.pipes.PipeSwitchItems;
import buildcraft.additionalpipes.pipes.PipeSwitchLiquids;
import buildcraft.additionalpipes.pipes.PipeSwitchPower;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerProvider;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.transport.IPipe;
import buildcraft.core.utils.Localization;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.Pipe;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.Property;

@Mod(modid="APUnofficial", name="Additional Pipes Unofficial", dependencies="after:BuildCraft|Transport;after:BuildCraft|Silicon;after:BuildCraft|Transport;after:BuildCraft|Factory", version="2.1.3u42")
@NetworkMod(channels={"APUnofficial", "APUnofficialNBT"}, clientSideRequired=true, serverSideRequired=true, packetHandler=NetworkHandler.class)
public class AdditionalPipes {
    public static final String MODID = "APUnofficial";
    public static final String NAME = "Additional Pipes Unofficial";
    public static final String VERSION = "2.1.3u42";
    public static final String CHANNEL = "APUnofficial";
    public static final String CHANNELNBT = "APUnofficialNBT";
    @Mod.Instance(value="APUnofficial")
    public static AdditionalPipes instance;
    @SidedProxy(clientSide="buildcraft.additionalpipes.MutiPlayerProxyClient", serverSide="buildcraft.additionalpipes.MutiPlayerProxy")
    public static MutiPlayerProxy proxy;
    public File configFile;
    public Logger logger;
    public static final String BASE_PATH = "/buildcraft/additionalpipes";
    public static final String TEXTURE_PATH = "/buildcraft/additionalpipes/sprites";
    public static final String TEXTURE_MASTER = "/buildcraft/additionalpipes/sprites/textures.png";
    public static final String TEXTURE_TRIGGERS = "/buildcraft/additionalpipes/sprites/triggers.png";
    public static final String TEXTURE_GUI_TELEPORT = "/buildcraft/additionalpipes/sprites/blankSmallGui.png";
    public static final String TEXTURE_GUI_ADVANCEDWOOD = "/buildcraft/additionalpipes/sprites/advancedWoodGui.png";
    public static final String TEXTURE_GUI_DISTRIBUTION = "/buildcraft/additionalpipes/sprites/distributionGui.png";
    public ChunkLoadViewDataProxy chunkLoadViewer;
    @CfgBool
    public boolean chunkSight = true;
    public int chunkSightRange = 8;
    @CfgBool
    public boolean chunkSightAutorefresh = true;
    public up pipeLiquidsRedstone;
    @CfgId
    public int pipeLiquidsRedstoneId = 14042;
    public up pipeItemsRedStone;
    @CfgId
    public int pipeItemsRedStoneId = 14043;
    public up pipeItemsAdvancedInsertion;
    @CfgId
    public int pipeItemsAdvancedInsertionId = 14044;
    public up pipeItemsAdvancedWood;
    @CfgId
    public int pipeItemsAdvancedWoodId = 14045;
    public up pipeItemsDistributor;
    @CfgId
    public int pipeItemsDistributorId = 14046;
    public up pipeItemsTeleport;
    @CfgId
    public int pipeItemsTeleportId = 14047;
    public up pipeLiquidsTeleport;
    @CfgId
    public int pipeLiquidsTeleportId = 14048;
    public up pipePowerTeleport;
    @CfgId
    public int pipePowerTeleportId = 14049;
    public up pipeItemsClosed;
    @CfgId
    public int pipeItemsClosedId = 14050;
    public up pipePowerSwitch;
    @CfgId
    public int pipePowerSwitchId = 14051;
    public up pipeItemsSwitch;
    @CfgId
    public int pipeItemsSwitchId = 14052;
    public up pipeLiquidsSwitch;
    @CfgId
    public int pipeLiquidsSwitchId = 14053;
    public up pipeLiquidsWaterPump;
    @CfgId
    public int pipeLiquidsWaterPumpId = 14054;
    public amq blockChunkLoader;
    @CfgId(block=true)
    public int chunkLoaderId = 1890;
    @CfgBool
    public boolean enableTriggers = true;
    public ITrigger triggerPipeClosed;
    public ITrigger triggerPhasedSignalRed;
    public ITrigger triggerPhasedSignalBlue;
    public ITrigger triggerPhasedSignalGreen;
    public ITrigger triggerPhasedSignalYellow;
    public int laserKeyCode = 64;
    @CfgBool
    public boolean allowWRRemove = false;
    public double powerLossCfg = 0.95;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = Logger.getLogger("APUnofficial");
        this.logger.setParent(FMLLog.getLogger());
        this.logger.setLevel(Level.WARNING);
        this.configFile = event.getSuggestedConfigurationFile();
        this.loadConfigs(false);
        Properties en_US = null;
        Localization.addLocalization((String)"/buildcraft/additionalpipes/lang/", (String)"en_US");
        try {
            en_US = new Properties();
            en_US.load(AdditionalPipes.class.getResourceAsStream("/buildcraft/additionalpipes/lang/en_US.properties"));
            LanguageRegistry.instance().addStringLocalization(en_US);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load default localization.", e);
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkLoadingHandler());
        this.chunkLoadViewer = new ChunkLoadViewDataProxy(this.chunkSightRange);
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)this.chunkLoadViewer, (Side)Side.CLIENT);
        proxy.registerKeyHandler();
        proxy.registerRendering();
        this.loadConfigs(true);
        this.loadPipes();
        if (this.enableTriggers) {
            this.triggerPipeClosed = new TriggerPipeClosed(212);
            this.triggerPhasedSignalRed = new TriggerPhasedSignal(213, IPipe.WireColor.Red);
            this.triggerPhasedSignalBlue = new TriggerPhasedSignal(214, IPipe.WireColor.Blue);
            this.triggerPhasedSignalGreen = new TriggerPhasedSignal(215, IPipe.WireColor.Green);
            this.triggerPhasedSignalYellow = new TriggerPhasedSignal(216, IPipe.WireColor.Yellow);
            ActionManager.registerTriggerProvider((ITriggerProvider)new GateProvider());
        }
        if (this.allowWRRemove) {
            GameRegistry.addRecipe((ur)new ur(this.pipeItemsTeleport), (Object[])new Object[]{"A", Character.valueOf('A'), this.pipePowerTeleport});
            GameRegistry.addRecipe((ur)new ur(this.pipeItemsTeleport), (Object[])new Object[]{"A", Character.valueOf('A'), this.pipeLiquidsTeleport});
            GameRegistry.addRecipe((ur)new ur(this.pipeItemsRedStone), (Object[])new Object[]{"A", Character.valueOf('A'), this.pipeLiquidsRedstone});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsCobblestone), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeLiquidsCobblestone});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsGold), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeLiquidsGold});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsIron), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeLiquidsIron});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsStone), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeLiquidsStone});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsWood), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipeLiquidsWood});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsGold), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipePowerGold});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsStone), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipePowerStone});
            GameRegistry.addRecipe((ur)new ur(BuildCraftTransport.pipeItemsWood), (Object[])new Object[]{"A", Character.valueOf('A'), BuildCraftTransport.pipePowerWood});
        }
        if (this.chunkLoaderId != 0) {
            this.blockChunkLoader = new BlockChunkLoader(this.chunkLoaderId > 0 ? this.chunkLoaderId : -this.chunkLoaderId, 32);
            this.blockChunkLoader.b("TeleportTether");
            GameRegistry.registerBlock((amq)this.blockChunkLoader, vq.class, (String)"chunkLoader");
            GameRegistry.registerTileEntity(TileChunkLoader.class, (String)"TeleportTether");
            if (this.chunkLoaderId > 0) {
                GameRegistry.addRecipe((ur)new ur(this.blockChunkLoader), (Object[])new Object[]{"iii", "iLi", "iii", Character.valueOf('i'), up.o, Character.valueOf('L'), new ur(up.aW, 1, 4)});
            }
        }
    }

    @Mod.ServerStarting
    public void onServerStart(FMLServerStartingEvent event) {
        TeleportManager.instance.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigs(boolean postInit) {
        if (!this.configFile.exists() && !postInit || this.configFile.exists() && postInit) {
            return;
        }
        Configuration config = new Configuration(this.configFile);
        try {
            Field[] fields;
            config.load();
            config.addCustomCategoryComment("block", "Set id to 0 to disable loading the block, add - in front of id to disable recipe only.");
            config.addCustomCategoryComment("item", "Set id to 0 to disable loading the item, add - in front of id to disable recipe only.");
            config.addCustomCategoryComment("general", "Disabling items/blocks only disables recipes.");
            for (Field field : fields = AdditionalPipes.class.getFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                CfgId annotation = field.getAnnotation(CfgId.class);
                if (annotation != null) {
                    int id = field.getInt(this);
                    if (annotation.block()) {
                        if (((ConfigCategory)config.categories.get("block")).containsKey(field.getName())) {
                            id = config.get("block", field.getName(), id).getInt(id);
                            if (id > 0) {
                                id = config.getBlock(field.getName(), id).getInt(id);
                            }
                        } else {
                            id = config.getBlock(field.getName(), id).getInt(id);
                        }
                    } else if (((ConfigCategory)config.categories.get("item")).containsKey(field.getName())) {
                        id = config.get("item", field.getName(), id).getInt(id);
                        if (id > 0) {
                            id = config.getItem(field.getName(), id).getInt(id);
                        }
                    } else {
                        id = config.getItem(field.getName(), id).getInt(id);
                    }
                    field.setInt(this, id);
                    continue;
                }
                if (!field.isAnnotationPresent(CfgBool.class)) continue;
                boolean bool = field.getBoolean(this);
                bool = config.get("general", field.getName(), bool).getBoolean(bool);
                field.setBoolean(this, bool);
            }
            Property powerLoss = config.get("general", "powerLoss", (int)(this.powerLossCfg * 100.0));
            powerLoss.comment = "Percentage of power a power teleport pipe transmits. Between 0 and 100.";
            this.powerLossCfg = (double)powerLoss.getInt() / 100.0;
            if (this.powerLossCfg > 1.0) {
                this.powerLossCfg = 0.99;
            } else if (this.powerLossCfg < 0.0) {
                this.powerLossCfg = 0.0;
            }
            Property chunkLoadSightRange = config.get("general", "chunkSightRange", this.chunkSightRange);
            chunkLoadSightRange.comment = "Range of chunk load boundaries.";
            Property laserKey = config.get("general", "laserKeyChar", this.laserKeyCode);
            laserKey.comment = "Default key to toggle chunk load boundaries.";
            this.laserKeyCode = laserKey.getInt();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error loading Additional Pipes configs.", e);
        }
        finally {
            config.save();
        }
    }

    private void loadPipes() {
        if (this.pipeItemsTeleportId != 0) {
            this.pipeItemsTeleport = this.createPipeSpecial(this.pipeItemsTeleportId > 0 ? this.pipeItemsTeleportId : -this.pipeItemsTeleportId, PipeItemsTeleport.class);
            if (this.pipeItemsTeleportId > 0) {
                GameRegistry.addRecipe((ur)new ur(this.pipeItemsTeleport, 4), (Object[])new Object[]{"dgd", Character.valueOf('d'), BuildCraftCore.diamondGearItem, Character.valueOf('g'), amq.P});
                AssemblyRecipe.assemblyRecipes.add(new AssemblyRecipe(new ur[]{new ur(BuildCraftSilicon.redstoneChipset, 1, 4), new ur(BuildCraftTransport.pipeItemsDiamond, 2), new ur(BuildCraftSilicon.redstoneChipset, 1, 3)}, 10000, new ur(this.pipeItemsTeleport, 2)));
            }
        }
        if (this.pipeLiquidsTeleportId != 0) {
            this.pipeLiquidsTeleport = this.createPipeSpecial(this.pipeLiquidsTeleportId > 0 ? this.pipeLiquidsTeleportId : -this.pipeLiquidsTeleportId, PipeLiquidsTeleport.class);
            if (this.pipeItemsTeleport != null && this.pipeLiquidsTeleportId > 0) {
                GameRegistry.addRecipe((ur)new ur(this.pipeLiquidsTeleport), (Object[])new Object[]{"w", "P", Character.valueOf('w'), BuildCraftTransport.pipeWaterproof, Character.valueOf('P'), this.pipeItemsTeleport});
            }
        }
        if (this.pipePowerTeleportId != 0) {
            this.pipePowerTeleport = this.createPipeSpecial(this.pipePowerTeleportId > 0 ? this.pipePowerTeleportId : -this.pipePowerTeleportId, PipePowerTeleport.class);
            if (this.pipeItemsTeleport != null && this.pipePowerTeleportId > 0) {
                GameRegistry.addRecipe((ur)new ur(this.pipePowerTeleport), (Object[])new Object[]{"r", "P", Character.valueOf('r'), up.aC, Character.valueOf('P'), this.pipeItemsTeleport});
            }
        }
        this.pipeItemsDistributor = this.doCreatePipeAndRecipe(this.pipeItemsDistributorId, PipeItemsDistributor.class, new Object[]{" r ", "IgI", Character.valueOf('r'), up.aC, Character.valueOf('I'), up.o, Character.valueOf('g'), amq.P});
        this.pipeItemsAdvancedWood = this.doCreatePipeAndRecipe(this.pipeItemsAdvancedWoodId, 8, PipeItemsAdvancedWood.class, new Object[]{"WgW", Character.valueOf('W'), BuildCraftCore.woodenGearItem, Character.valueOf('g'), amq.P});
        this.pipeItemsAdvancedInsertion = this.doCreatePipeAndRecipe(this.pipeItemsAdvancedInsertionId, 8, PipeItemsAdvancedInsertion.class, new Object[]{"IgI", Character.valueOf('I'), BuildCraftCore.ironGearItem, Character.valueOf('g'), amq.P});
        this.pipeItemsRedStone = this.doCreatePipeAndRecipe(this.pipeItemsRedStoneId, 8, PipeItemsRedstone.class, new Object[]{"RgR", Character.valueOf('R'), up.aC, Character.valueOf('g'), amq.P});
        this.pipeLiquidsRedstone = this.doCreatePipeAndRecipe(this.pipeLiquidsRedstoneId, PipeLiquidsRedstone.class, new Object[]{"w", "P", Character.valueOf('w'), BuildCraftTransport.pipeWaterproof, Character.valueOf('P'), this.pipeItemsRedStone});
        this.pipeItemsClosed = this.doCreatePipeAndRecipe(this.pipeItemsClosedId, PipeItemsClosed.class, new Object[]{"r", "I", Character.valueOf('I'), BuildCraftTransport.pipeItemsVoid, Character.valueOf('i'), BuildCraftCore.ironGearItem});
        this.pipeItemsSwitch = this.doCreatePipeAndRecipe(this.pipeItemsSwitchId, 8, PipeSwitchItems.class, new Object[]{"GgG", Character.valueOf('g'), amq.P, Character.valueOf('G'), BuildCraftCore.goldGearItem});
        this.pipePowerSwitch = this.doCreatePipeAndRecipe(this.pipePowerSwitchId, PipeSwitchPower.class, new Object[]{"r", "I", Character.valueOf('I'), this.pipeItemsSwitch, Character.valueOf('r'), up.aC});
        this.pipeLiquidsSwitch = this.doCreatePipeAndRecipe(this.pipeLiquidsSwitchId, PipeSwitchLiquids.class, new Object[]{"w", "I", Character.valueOf('I'), this.pipeItemsSwitch, Character.valueOf('w'), BuildCraftTransport.pipeWaterproof});
        this.pipeLiquidsWaterPump = this.doCreatePipeAndRecipe(this.pipeLiquidsWaterPumpId, PipeLiquidsWaterPump.class, new Object[]{" L ", "rPr", " W ", Character.valueOf('r'), up.aC, Character.valueOf('P'), BuildCraftCore.ironGearItem, Character.valueOf('L'), BuildCraftTransport.pipeLiquidsGold, Character.valueOf('w'), BuildCraftTransport.pipeWaterproof, Character.valueOf('W'), BuildCraftTransport.pipeLiquidsWood});
    }

    private up doCreatePipeAndRecipe(int id, Class clas, Object[] recipe) {
        return this.doCreatePipeAndRecipe(id, 1, clas, recipe);
    }

    private up doCreatePipeAndRecipe(int id, int output, Class clas, Object[] recipe) {
        if (id == 0) {
            return null;
        }
        up pipe = AdditionalPipes.createPipe(id > 0 ? id : -id, clas);
        for (Object obj : recipe) {
            if (obj != null) continue;
            return pipe;
        }
        GameRegistry.addRecipe((ur)new ur(pipe, output), (Object[])recipe);
        return pipe;
    }

    private static up createPipe(int id, Class clas) {
        ItemPipe res = BlockGenericPipe.registerPipe((int)id, (Class)clas);
        res.b(clas.getSimpleName());
        proxy.registerPipeRendering((up)res);
        return res;
    }

    private up createPipeSpecial(int id, Class clas) {
        ItemPipeAP item = new ItemPipeAP(id);
        item.b(clas.getSimpleName());
        proxy.registerPipeRendering((up)item);
        BlockGenericPipe.pipes.put(item.cj, clas);
        try {
            Pipe dummyPipe = (Pipe)clas.getConstructor(Integer.TYPE).newInstance(id);
            if (dummyPipe != null) {
                item.setTextureFile(dummyPipe.getTextureFile());
                item.setTextureIndex(dummyPipe.getTextureIndexForItem());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during special pipe creation.", e);
            item = (ItemPipe)AdditionalPipes.createPipe(id, clas);
        }
        return item;
    }

    public static boolean isPipe(up item) {
        return item != null && BlockGenericPipe.pipes.containsKey(item.cj);
    }

    private static class ItemPipeAP
    extends ItemPipe {
        protected ItemPipeAP(int i) {
            super(i);
        }

        @SideOnly(value=Side.CLIENT)
        public vb f(ur stack) {
            return vb.c;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CfgBool {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface CfgId {
        public boolean block() default false;
    }
}

