/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.gates;

import buildcraft.additionalpipes.pipes.PipeTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.gates.Trigger;
import buildcraft.api.transport.IPipe;
import buildcraft.transport.ITriggerPipe;
import buildcraft.transport.Pipe;

public class TriggerPhasedSignal
extends Trigger
implements ITriggerPipe {
    private IPipe.WireColor colour;

    public TriggerPhasedSignal(int id, IPipe.WireColor colour) {
        super(id);
        this.colour = colour;
    }

    public String getTextureFile() {
        return "/buildcraft/additionalpipes/sprites/triggers.png";
    }

    public String getDescription() {
        switch (this.colour) {
            case Red: {
                return "Red Phased Signal";
            }
            case Blue: {
                return "Blue Phased Signal";
            }
            case Green: {
                return "Green Phased Signal";
            }
        }
        return "Yellow Phased Signal";
    }

    public int getIndexInTexture() {
        switch (this.colour) {
            case Red: {
                return 2;
            }
            case Blue: {
                return 4;
            }
            case Green: {
                return 6;
            }
        }
        return 8;
    }

    public boolean isTriggerActive(Pipe pipe, ITriggerParameter parameter) {
        PipeTeleport teleportPipe = (PipeTeleport)pipe;
        return ((Integer[])TeleportManager.instance.phasedSignals.get(teleportPipe.logic.getFrequency()))[this.colour.ordinal()] > 0;
    }
}

