/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.additionalpipes.pipes.logic.PipeLogicAdvancedWood;
import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipedItem;
import buildcraft.api.transport.PipeManager;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsAdvancedWood
extends APPipe
implements IPowerReceptor {
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public PipeItemsAdvancedWood(int itemID) {
        super((PipeTransport)new PipeTransportItems(), new PipeLogicAdvancedWood(), itemID);
        this.powerProvider.configure(50, 1, 64, 1, 64);
        this.powerProvider.configurePowerPerdition(64, 1);
    }

    public void setPowerProvider(IPowerProvider provider) {
        provider = this.powerProvider;
    }

    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    public void doWork() {
        if (this.powerProvider.getEnergyStored() <= 0.0f) {
            return;
        }
        yc w2 = this.worldObj;
        int meta = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (meta > 5) {
            return;
        }
        Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, ForgeDirection.VALID_DIRECTIONS[meta]);
        pos.moveForwards(1.0);
        int blockId = w2.a((int)pos.x, (int)pos.y, (int)pos.z);
        any tile = w2.q((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile instanceof la) {
            if (!PipeManager.canExtractItems((IPipe)this, (yc)w2, (int)((int)pos.x), (int)((int)pos.y), (int)((int)pos.z))) {
                return;
            }
            la inventory = (la)tile;
            ur extracted = this.checkExtract(inventory, true, pos.orientation.getOpposite());
            if (extracted == null || extracted.a == 0) {
                this.powerProvider.useEnergy(1.0f, 1.0f, false);
                return;
            }
            Position entityPos = new Position(pos.x + 0.5, pos.y + (double)Utils.getPipeFloorOf((ur)extracted), pos.z + 0.5, pos.orientation.getOpposite());
            entityPos.moveForwards(0.5);
            EntityPassiveItem entity = new EntityPassiveItem(w2, entityPos.x, entityPos.y, entityPos.z, extracted);
            ((PipeTransportItems)this.transport).entityEntering((IPipedItem)entity, entityPos.orientation);
        }
    }

    public ur checkExtract(la inventory, boolean doRemove, ForgeDirection from) {
        la inv = Utils.getInventory((la)inventory);
        ur result = this.checkExtractGeneric(inv, doRemove, from, 0, inv.k_() - 1);
        return result;
    }

    public ur checkExtractGeneric(la inventory, boolean doRemove, ForgeDirection from, int start, int stop) {
        for (int k = start; k <= stop; ++k) {
            ur slot;
            if (inventory.a(k) == null || inventory.a((int)k).a <= 0 || (slot = inventory.a(k)) == null || slot.a <= 0 || !this.canExtract(slot)) continue;
            if (doRemove) {
                return inventory.a(k, (int)this.powerProvider.useEnergy(1.0f, (float)slot.a, true));
            }
            return slot;
        }
        return null;
    }

    public boolean canExtract(ur item) {
        PipeLogicAdvancedWood logic = (PipeLogicAdvancedWood)this.logic;
        for (int i = 0; i < logic.k_(); ++i) {
            ur stack = logic.a(i);
            if (stack == null || stack.c != item.c) continue;
            if (up.e[item.c].n()) {
                return !logic.exclude;
            }
            if (stack.j() != item.j()) continue;
            return !logic.exclude;
        }
        return logic.exclude;
    }

    public int powerRequest() {
        return this.getPowerProvider().getMaxEnergyReceived();
    }

    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
    }

    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return 6;
        }
        int metadata = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (metadata == direction.ordinal()) {
            return 7;
        }
        return 6;
    }
}

