/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.additionalpipes.pipes.APPipe;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.network.TileNetworkData;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicStone;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsRedstone
extends APPipe
implements IPipeTransportItemsHook {
    @TileNetworkData
    public boolean isPowering = false;

    public PipeItemsRedstone(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicStone(), itemID);
    }

    public void readjustSpeed(IPipedItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed / 2.0f);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    public void updateEntity() {
        super.updateEntity();
        if (((PipeTransportItems)this.transport).travelingEntities.size() == 0 && this.isPowering) {
            this.isPowering = false;
            this.UpdateTiles(this.container.l, this.container.m, this.container.n);
        } else if (((PipeTransportItems)this.transport).travelingEntities.size() > 0 && !this.isPowering) {
            this.isPowering = true;
            this.UpdateTiles(this.container.l, this.container.m, this.container.n);
        }
    }

    private void UpdateTiles(int i, int j, int k) {
        this.worldObj.h(i, j, k, BuildCraftTransport.genericPipeBlock.cm);
    }

    public boolean isPoweringTo(int l) {
        if (((PipeTransportItems)this.transport).travelingEntities.size() == 0) {
            this.isPowering = false;
            return false;
        }
        this.isPowering = true;
        int i1 = this.worldObj.h(this.xCoord, this.yCoord, this.zCoord);
        if (i1 == 5 && l == 1) {
            return false;
        }
        if (i1 == 3 && l == 3) {
            return false;
        }
        if (i1 == 4 && l == 2) {
            return false;
        }
        if (i1 == 1 && l == 5) {
            return false;
        }
        return i1 != 2 || l != 4;
    }

    public boolean isIndirectlyPoweringTo(int l) {
        return this.isPoweringTo(l);
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    @Override
    public int getTextureIndex(ForgeDirection direction) {
        return this.isPowering ? 5 : 4;
    }
}

