package IC2BackpackHUD;

import ic2.api.IElectricItem;
import java.util.EnumSet;
import org.lwjgl.opengl.GL11;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;

public class ClientTickHandler implements ITickHandler
{
	private Minecraft minecraft = Minecraft.getMinecraft();
	int scaledWidth, scaledHeight;
	long[] elapsedDrawTime = new long[4];
	byte[][] drawStatusTexOffset = new byte[4][2];
	int[] currentCharge = new int[4], lastCharge = new int[4];
	boolean[] isDrawingStatus = new boolean[4], isCharging = new boolean[4], isLowPower = new boolean[4];
	final byte pixelNudge = 1;
	final byte bgXCoord = 16, bgYCoord = 0; // Background texture coordinates
	final byte bgHeight = 21, bgWidth = 18; // Background texture dimensions
	final byte lowPowerXCoord = 0, lowPowerYCoord = 3; // Low Power texture coordinates
	final byte chargingXCoord = 0, chargingYCoord = 19; // Charging texture coordinates

	@Override
	public void tickStart(EnumSet<TickType> type, Object... tickData) {}

	@Override
	public void tickEnd(EnumSet<TickType> type, Object... tickData)
	{
		if (type.equals(EnumSet.of(TickType.RENDER)))
		{			
			GuiScreen guiscreen = Minecraft.getMinecraft().currentScreen;
			if (guiscreen == null) {
				onTickInGame();
			}
		}
	}

	public void onTickInGame()
	{
		ScaledResolution scaledResolution = new ScaledResolution(minecraft.gameSettings, minecraft.displayWidth, minecraft.displayHeight);
		scaledWidth = scaledResolution.getScaledWidth();
		scaledHeight = scaledResolution.getScaledHeight();

		/**
		 * Armor Inventory Key
		 *
		 * 	Helmet 		= armorInventory[3]
		 * 	Chestplate 	= armorInventory[2]
		 * 	Leggings 	= armorInventory[1]
		 * 	Boots 		= armorInventory[0]
		 */

		ItemStack[] armorInventory = minecraft.thePlayer.inventory.armorInventory;
		boolean[] isValidArmor = new boolean[4];
		boolean hasValidArmor = false;
		byte armorPiecesWorn = 0;

		// Detect valid armor pieces worn
		for (byte count = 0; count < 4; count++) {
			if (armorInventory[count] != null) {
				if (armorInventory[count].getItem() instanceof IElectricItem || (armorInventory[count].getItem().isDamageable() && IC2BackpackHUD.showNonElectricItems)) {
					armorPiecesWorn++;
					isValidArmor[count] = true;
					hasValidArmor = true;
				}
			}
		}

		// Continue if valid armor item(s) equipped
		if (hasValidArmor) {

			GL11.glPushMatrix();
			GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
			GL11.glEnable(GL11.GL_BLEND);
			GL11.glBlendFunc(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

			// Assign draw coordinates to armor pieces
			int[] xCoord = new int[4];
			int[] yCoord = new int[4];
			for (byte count = 3, tempPiecesWorn = armorPiecesWorn; count >= 0; count--) {
				if (isValidArmor[count]) {
					switch(IC2BackpackHUD.hudPosition) {
					// Vertical, Top-Left Corner
					case 0: {
						xCoord[count] = pixelNudge * 3;
						yCoord[count] = pixelNudge + (((armorPiecesWorn + 1) - tempPiecesWorn--) * bgHeight);
						break;
					}
					// Vertical, Bottom-Left Corner
					case 1: {
						xCoord[count] = pixelNudge * 3;
						yCoord[count] = scaledHeight - (pixelNudge * 3) - ((tempPiecesWorn-- - 1) * bgHeight);
						break;
					}
					// Horizontal, Left of Hotbar
					case 2: {
						xCoord[count] = (scaledWidth / 2 - 92) - tempPiecesWorn-- * bgWidth;
						yCoord[count] = scaledHeight - pixelNudge * 2;
						break;
					}
					// Horizontal, Right of Hotbar
					case 3: {
						xCoord[count] = (scaledWidth / 2 + 94) + (armorPiecesWorn - tempPiecesWorn--) * bgWidth;
						yCoord[count] = scaledHeight - pixelNudge * 2;
						break;
					}
					// Vertical, Bottom-Right Corner
					case 4: {
						xCoord[count] = scaledWidth - pixelNudge - bgWidth;
						yCoord[count] = scaledHeight - (pixelNudge * 3) - ((tempPiecesWorn-- - 1) * bgHeight);
						break;
					}
					// Vertical, Top-Right Corner
					case 5: {
						xCoord[count] = scaledWidth - pixelNudge - bgWidth;
						yCoord[count] = pixelNudge + (((armorPiecesWorn + 1) - tempPiecesWorn--) * bgHeight);
						break;
					}
					}
				}
			}

			// Draw armor pieces
			if (isValidArmor[3] && IC2BackpackHUD.showHelmetItems) drawArmor(3, xCoord[3], yCoord[3]);
			if (isValidArmor[2] && IC2BackpackHUD.showChestplateItems) drawArmor(2, xCoord[2], yCoord[2]);
			if (isValidArmor[1] && IC2BackpackHUD.showLeggingItems) drawArmor(1, xCoord[1], yCoord[1]);
			if (isValidArmor[0] && IC2BackpackHUD.showBootItems) drawArmor(0, xCoord[0], yCoord[0]);

			GL11.glDisable(GL11.GL_BLEND);
			GL11.glPopMatrix();
		}
	}

	@Override
	public EnumSet<TickType> ticks()
	{
		return EnumSet.of(TickType.RENDER, TickType.CLIENT);
	}

	@Override
	public String getLabel() { return null; }

	/**
	 * Draw element to screen
	 */
	public void drawTexturedModalRect(int xCoordLow, int yCoordLow, int xTexCoord, int yTexCoord, int textureWidth, int textureHeight)
	{
		float pixelOffset = 0.00390625F;
		Tessellator tessellator = Tessellator.instance;
		tessellator.startDrawingQuads();
		tessellator.addVertexWithUV((double)(xCoordLow + 0), (double)(yCoordLow + textureHeight), 0, (double)((float)(xTexCoord + 0) * pixelOffset), (double)((float)(yTexCoord + textureHeight) * pixelOffset));
		tessellator.addVertexWithUV((double)(xCoordLow + textureWidth), (double)(yCoordLow + textureHeight), 0, (double)((float)(xTexCoord + textureWidth) * pixelOffset), (double)((float)(yTexCoord + textureHeight) * pixelOffset));
		tessellator.addVertexWithUV((double)(xCoordLow + textureWidth), (double)(yCoordLow + 0), 0, (double)((float)(xTexCoord + textureWidth) * pixelOffset), (double)((float)(yTexCoord + 0) * pixelOffset));
		tessellator.addVertexWithUV((double)(xCoordLow + 0), (double)(yCoordLow + 0), 0, (double)((float)(xTexCoord + 0) * pixelOffset), (double)((float)(yTexCoord + 0) * pixelOffset));
		tessellator.draw();
	}
	
	/**
	 * Return item damage as an integer value between 0 and 14
	 */
	int getChargeLevel(ItemStack armor)
	{	
        if (armor.isItemDamaged()) {
        	/*
        	 * Vanilla item damage level is computed using a 13-value range.  This introduces rounding
        	 * errors for low max damage items when scaling to a 15-value range.  This returns the
        	 * correct zero-value item charge according to default item damage level checks.
        	 */
        	if (Math.round(13.0D - (double)armor.getItemDamageForDisplay() * 13.0D / (double)armor.getMaxDamage()) == 0) {
        		return 0;
        	} else {
        		return (int) Math.round(15.0D - (double)armor.getItemDamageForDisplay() * 15.0D / (double)armor.getMaxDamage());
        	}
        } else {
        	return 14;
        }
	}

	/**
	 * Draw armor item starting at given coordinate
	 */
	void drawArmor(int armorNum, int xCoord, int yCoord)
	{
		ItemStack armorSlot = minecraft.thePlayer.inventory.armorInventory[armorNum];

		// Get item charge or health
		int chargeLevel = getChargeLevel(armorSlot);
		
		// Set charge level color properties used for background and item health bar
		float red = 1.0F - (float)(chargeLevel / 14.0F);
		float green = (float)(chargeLevel / 14.0F);

		// Draw armor background
		if (IC2BackpackHUD.showBackground) {
			GL11.glBindTexture(GL11.GL_TEXTURE_2D, minecraft.renderEngine.getTexture("/IC2BackpackHUD/gui/items.png"));
			GL11.glColor4f(isCharging[armorNum] ? 1.0F : red, isCharging[armorNum] ? 1.0F : green, 0.0F, 1.0F);
			drawTexturedModalRect(xCoord - 1, yCoord - 20, bgXCoord, bgYCoord, bgWidth, bgHeight);
		}

		// Check for and set armor color, if applicable
		int armorColor = armorSlot.getItem().getColorFromItemStack(armorSlot, 0);
		if (armorColor > 0) {
			float tempRed = (float)(armorColor >> 16 & 255) / 255.0F;
			float tempGreen = (float)(armorColor >> 8 & 255) / 255.0F;
			float tempBlue = (float)(armorColor & 255) / 255.0F;
			GL11.glColor4f(1.0F * tempRed, 1.0F * tempGreen, 1.0F * tempBlue, 1.0F);
		}

		// Draw armor item
		int yTexCoord = 0, xTexBase;
		int iconIndex = armorSlot.getIconIndex();
		for (xTexBase = iconIndex; xTexBase > 15; ++yTexCoord)
			xTexBase -= 16;
		int xTexCoord = xTexBase * 16;
		yTexCoord *= 16;
		GL11.glBindTexture(GL11.GL_TEXTURE_2D, minecraft.renderEngine.getTexture(armorSlot.getItem().getTextureFile()));
		drawTexturedModalRect(xCoord, yCoord - 19, xTexCoord, yTexCoord, 16, 16);

		// Reset color (leather may have been colored, etc)
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

		GL11.glBindTexture(GL11.GL_TEXTURE_2D, minecraft.renderEngine.getTexture("/IC2BackpackHUD/gui/items.png"));

		// Identify armor charge status every half second
		int elapsedTime = (int) (System.nanoTime() - elapsedDrawTime[armorNum]);
		if (elapsedTime > 500000000) {

			isDrawingStatus[armorNum] = false;
			isCharging[armorNum] = false;
			isLowPower[armorNum] = false;

			if (IC2BackpackHUD.showChargingFlasher) {
				if (armorSlot.getItem() instanceof IElectricItem) {

					if (armorSlot.stackTagCompound != null && armorSlot.stackTagCompound.hasKey("charge")) {
						currentCharge[armorNum] = armorSlot.stackTagCompound.getInteger("charge");
					}

					if (currentCharge[armorNum] > lastCharge[armorNum]) {
						drawStatusTexOffset[armorNum][0] = chargingXCoord;
						drawStatusTexOffset[armorNum][1] = chargingYCoord;
						isDrawingStatus[armorNum] = true;
						isCharging[armorNum] = true;
					}

					lastCharge[armorNum] = currentCharge[armorNum];
				}
			}

			// Low power indicator status
			if (IC2BackpackHUD.showLowPowerFlasher) {
				if (chargeLevel <= 2) {
					if (!isDrawingStatus[armorNum]) {
						drawStatusTexOffset[armorNum][1] = lowPowerYCoord;
						isDrawingStatus[armorNum] = true;
						isLowPower[armorNum] = true;
					}
				}
			}

			elapsedDrawTime[armorNum] = System.nanoTime();
		}
		
		// Draw status icon
		if (isDrawingStatus[armorNum]) {
			if (isLowPower[armorNum] && chargeLevel == 0) {
				drawTexturedModalRect(xCoord, yCoord - 20, drawStatusTexOffset[armorNum][0], drawStatusTexOffset[armorNum][1], 16, 16);
			} else {
				GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F - (Math.abs(elapsedTime - 250000000) / 250000000.0F));
				drawTexturedModalRect(xCoord, yCoord - 20, drawStatusTexOffset[armorNum][0], drawStatusTexOffset[armorNum][1], 16, 16);
			}
		}
		
		// Reset alpha
		GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);

		// Draw charge level background
		drawTexturedModalRect(xCoord + 1, yCoord - 4, 0, 0, 14, 2);
		
		// Draw charge level
		GL11.glColor4f(isCharging[armorNum] ? 1.0F : red, isCharging[armorNum] ? 1.0F : green, 0.0F, 1.0F);
		drawTexturedModalRect(xCoord + 1, yCoord - 4, 0, 2, chargeLevel, 1);
	}
}