package IC2BackpackHUD;

import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.Mod.Init;
import cpw.mods.fml.common.Mod.Instance;
import cpw.mods.fml.common.Mod.PreInit;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;

@Mod(modid = "IC2BackpackHUD", name = "IC2 Backpack HUD", version = "2.6")
public class IC2BackpackHUD
{
	
	@Instance("IC2BackpackHUD")
	public static IC2BackpackHUD instance;

	static boolean showNonElectricItems;
	static boolean showHelmetItems;
	static boolean showChestplateItems;
	static boolean showLeggingItems;
	static boolean showBootItems;
	static boolean showLowPowerFlasher;
	static boolean showChargingFlasher;
	static boolean showBackground;
	static int hudPosition;
	
	@PreInit
	public void preInit(FMLPreInitializationEvent event)
	{
		Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        
        showNonElectricItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Non-Electric Armor", true).getBoolean(showNonElectricItems);
        showHelmetItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Helmets", true).getBoolean(showHelmetItems);
        showChestplateItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Chestplates", true).getBoolean(showChestplateItems);
        showLeggingItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Leggings", true).getBoolean(showLeggingItems);
        showBootItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Boots", true).getBoolean(showBootItems);
        showLowPowerFlasher = config.get(Configuration.CATEGORY_GENERAL, "Show Low Power Flasher", true).getBoolean(showLowPowerFlasher);
        showChargingFlasher = config.get(Configuration.CATEGORY_GENERAL, "Show Charging Flasher", true).getBoolean(showChargingFlasher);
        showBackground = config.get(Configuration.CATEGORY_GENERAL, "Show HUD Background", true).getBoolean(showBackground);
        
        Property hudPositionProp = config.get("HUD Position", "hudPosition", 2);
        hudPositionProp.comment = "0 = Vertical, Top-Left Corner\n1 = Vertical, Bottom-Left Corner\n2 = Horizontal, Left of Hotbar\n3 = Horizontal, Right of Hotbar\n4 = Vertical, Bottom-Right Corner\n5 = Vertical, Top-Right Corner";
        hudPosition = hudPositionProp.getInt(hudPosition);
        
        config.save();
	}

	@Init
	public void load(FMLInitializationEvent event)
	{
		if (Loader.isModLoaded("IC2")) {
			try {
				TickRegistry.registerTickHandler(new ClientTickHandler(), Side.CLIENT);
				MinecraftForgeClient.preloadTexture("/IC2BackpackHUD/gui/items.png");
			} catch (Exception e) {  }
		}
	}
	 
}