/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.shader;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.gl.versioned.GlCompat;
import com.jozufozu.flywheel.backend.loading.Shader;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class GlShader
extends GlObject {
    public final ResourceLocation name;
    public final ShaderType type;

    public GlShader(Shader shader) {
        this.type = shader.type;
        this.name = shader.name;
        int handle = GL20.glCreateShader((int)shader.type.glEnum);
        GlCompat.safeShaderSource(handle, shader.getSource());
        GL20.glCompileShader((int)handle);
        String log = GL20.glGetShaderInfoLog((int)handle);
        if (!log.isEmpty()) {
            Backend.log.error("Shader compilation log for " + shader.name + ": " + log);
            Backend.log.error(shader.printSource());
        }
        if (GL20.glGetShaderi((int)handle, (int)35713) != 1) {
            throw new RuntimeException("Could not compile " + shader.name + ". See log for details.");
        }
        this.setHandle(handle);
    }

    @Override
    protected void deleteInternal(int handle) {
        GL20.glDeleteShader((int)handle);
    }
}

