/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.vanilla;

import com.jozufozu.flywheel.backend.instancing.IDynamicInstance;
import com.jozufozu.flywheel.backend.instancing.tile.TileEntityInstance;
import com.jozufozu.flywheel.backend.material.MaterialManager;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.OrientedData;
import com.jozufozu.flywheel.core.model.ModelPart;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import net.minecraft.client.renderer.tileentity.BellTileEntityRenderer;
import net.minecraft.tileentity.BellTileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;

public class BellInstance
extends TileEntityInstance<BellTileEntity>
implements IDynamicInstance {
    private final OrientedData bell;
    private float lastRingTime = Float.NaN;

    public BellInstance(MaterialManager<?> materialManager, BellTileEntity tile) {
        super(materialManager, tile);
        this.bell = this.createBellInstance().setPivot(0.5f, 0.75f, 0.5f).setPosition(this.getInstancePosition());
    }

    @Override
    public void beginFrame() {
        float ringTime = (float)((BellTileEntity)this.tile).field_213943_a + AnimationTickHolder.getPartialTicks();
        if (ringTime == this.lastRingTime) {
            return;
        }
        this.lastRingTime = ringTime;
        if (((BellTileEntity)this.tile).field_213944_b) {
            float angle = MathHelper.func_76126_a((float)(ringTime / (float)Math.PI)) / (4.0f + ringTime / 3.0f);
            Vector3f ringAxis = ((BellTileEntity)this.tile).field_213945_c.func_176735_f().func_229386_k_();
            this.bell.setRotation(ringAxis.func_229193_c_(angle));
        } else {
            this.bell.setRotation(Quaternion.field_227060_a_);
        }
    }

    @Override
    public void updateLight() {
        this.relight(this.getWorldPosition(), this.bell);
    }

    @Override
    public void remove() {
        this.bell.delete();
    }

    private OrientedData createBellInstance() {
        return this.materialManager.defaultCutout().material(Materials.ORIENTED).model(((BellTileEntity)this.tile).func_200662_C(), BellInstance::createBellModel).createInstance();
    }

    private static ModelPart createBellModel() {
        return ModelPart.builder(32, 32).sprite(BellTileEntityRenderer.field_217653_c.func_229314_c_()).cuboid().start(5.0f, 6.0f, 5.0f).size(6.0f, 7.0f, 6.0f).endCuboid().cuboid().textureOffset(0, 13).start(4.0f, 4.0f, 4.0f).size(8.0f, 2.0f, 8.0f).endCuboid().build();
    }
}

