/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.networking;

import appeng.block.AEBaseTileBlock;
import appeng.container.ContainerLocator;
import appeng.container.ContainerOpener;
import appeng.container.implementations.WirelessContainer;
import appeng.helpers.AEMaterials;
import appeng.tile.networking.WirelessTileEntity;
import appeng.util.InteractionUtil;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class WirelessBlock
extends AEBaseTileBlock<WirelessTileEntity> {
    public static final EnumProperty<State> STATE = EnumProperty.func_177709_a((String)"state", State.class);

    public WirelessBlock() {
        super(WirelessBlock.defaultProps(AEMaterials.GLASS).func_226896_b_());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)State.OFF)));
    }

    @Override
    protected BlockState updateBlockStateFromTileEntity(BlockState currentState, WirelessTileEntity te) {
        State teState = State.OFF;
        if (te.isActive()) {
            teState = State.HAS_CHANNEL;
        } else if (te.isPowered()) {
            teState = State.ON;
        }
        return (BlockState)currentState.func_206870_a(STATE, (Comparable)((Object)teState));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STATE});
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World w, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        WirelessTileEntity tg = (WirelessTileEntity)this.getTileEntity((IBlockReader)w, pos);
        if (tg != null && !InteractionUtil.isInAlternateUseMode(player)) {
            if (!w.func_201670_d()) {
                ContainerOpener.openContainer(WirelessContainer.TYPE, player, ContainerLocator.forTileEntitySide(tg, hit.func_216354_b()));
            }
            return ActionResultType.func_233537_a_((boolean)w.func_201670_d());
        }
        return super.func_225533_a_(state, w, pos, player, hand, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        WirelessTileEntity tile = (WirelessTileEntity)this.getTileEntity(w, pos);
        if (tile != null) {
            Direction forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 1.0;
                    minY = 0.3125;
                    break;
                }
                case EAST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 0.6875;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 1.0;
                    minZ = 0.3125;
                    break;
                }
                case SOUTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 0.6875;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 0.6875;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 1.0;
                    minX = 0.3125;
                    break;
                }
            }
            return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader w, BlockPos pos, ISelectionContext context) {
        WirelessTileEntity tile = (WirelessTileEntity)this.getTileEntity(w, pos);
        if (tile != null) {
            Direction forward = tile.getForward();
            double minX = 0.0;
            double minY = 0.0;
            double minZ = 0.0;
            double maxX = 1.0;
            double maxY = 1.0;
            double maxZ = 1.0;
            switch (forward) {
                case DOWN: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 1.0;
                    minY = 0.3125;
                    break;
                }
                case EAST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 0.6875;
                    minX = 0.0;
                    break;
                }
                case NORTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 1.0;
                    minZ = 0.3125;
                    break;
                }
                case SOUTH: {
                    minX = 0.1875;
                    minY = 0.1875;
                    maxX = 0.8125;
                    maxY = 0.8125;
                    maxZ = 0.6875;
                    minZ = 0.0;
                    break;
                }
                case UP: {
                    minX = 0.1875;
                    minZ = 0.1875;
                    maxX = 0.8125;
                    maxZ = 0.8125;
                    maxY = 0.6875;
                    minY = 0.0;
                    break;
                }
                case WEST: {
                    minY = 0.1875;
                    minZ = 0.1875;
                    maxY = 0.8125;
                    maxZ = 0.8125;
                    maxX = 1.0;
                    minX = 0.3125;
                    break;
                }
            }
            return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ));
        }
        return VoxelShapes.func_197880_a();
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    static enum State implements IStringSerializable
    {
        OFF,
        ON,
        HAS_CHANNEL;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

