/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import appeng.core.AEConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class NumberEntryWidget
extends AbstractGui
implements ICompositeWidget {
    private static final ITextComponent INVALID_NUMBER = new TranslationTextComponent("gui.appliedenergistics2.validation.InvalidNumber");
    private static final String NUMBER_LESS_THAN_MIN_VALUE = "gui.appliedenergistics2.validation.NumberLessThanMinValue";
    private static final ITextComponent PLUS = new StringTextComponent("+");
    private static final ITextComponent MINUS = new StringTextComponent("-");
    private static final int TEXT_COLOR_ERROR = 16718080;
    private static final int TEXT_COLOR_NORMAL = 0xFFFFFF;
    private final ConfirmableTextField textField;
    private final NumberEntryType type;
    private List<Button> buttons;
    private long minValue;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;
    private Rectangle2d bounds = new Rectangle2d(0, 0, 0, 0);
    private Point textFieldOrigin = Point.ZERO;

    public NumberEntryWidget(NumberEntryType type) {
        this.type = type;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        font.getClass();
        this.textField = new ConfirmableTextField(font, 0, 0, 0, 9, StringTextComponent.field_240750_d_);
        this.textField.func_146185_a(false);
        this.textField.func_146203_f(16);
        this.textField.func_146193_g(0xFFFFFF);
        this.textField.func_146189_e(true);
        this.textField.func_146195_b(true);
        this.textField.func_212954_a(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.func_146184_c(active);
        this.buttons.forEach(b -> {
            b.field_230693_o_ = active;
        });
    }

    public void setTextFieldBounds(int x, int y, int width) {
        this.textFieldOrigin = new Point(x, y);
        this.textField.func_230991_b_(width);
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    @Override
    public void setPosition(Point position) {
        this.bounds = new Rectangle2d(position.getX(), position.getY(), this.bounds.func_199316_c(), this.bounds.func_199317_d());
    }

    @Override
    public void setSize(int width, int height) {
        this.bounds = new Rectangle2d(this.bounds.func_199318_a(), this.bounds.func_199319_b(), width, height);
    }

    @Override
    public Rectangle2d getBounds() {
        return this.bounds;
    }

    @Override
    public void populateScreen(Consumer<Widget> addWidget, Rectangle2d bounds, AEBaseScreen<?> screen) {
        int[] steps = AEConfig.instance().getNumberEntrySteps(this.type);
        int a = steps[0];
        int b = steps[1];
        int c = steps[2];
        int d = steps[3];
        int left = bounds.func_199318_a() + this.bounds.func_199318_a();
        int top = bounds.func_199319_b() + this.bounds.func_199319_b();
        ArrayList<Button> buttons = new ArrayList<Button>(9);
        buttons.add(new Button(left, top, 22, 20, this.makeLabel(PLUS, a), btn -> this.addQty(a)));
        buttons.add(new Button(left + 28, top, 28, 20, this.makeLabel(PLUS, b), btn -> this.addQty(b)));
        buttons.add(new Button(left + 62, top, 32, 20, this.makeLabel(PLUS, c), btn -> this.addQty(c)));
        buttons.add(new Button(left + 100, top, 38, 20, this.makeLabel(PLUS, d), btn -> this.addQty(d)));
        buttons.forEach(addWidget);
        this.textField.field_230690_l_ = bounds.func_199318_a() + this.textFieldOrigin.getX();
        this.textField.field_230691_m_ = bounds.func_199319_b() + this.textFieldOrigin.getY();
        screen.func_212928_a((IGuiEventListener)this.textField);
        addWidget.accept((Widget)this.textField);
        buttons.add(new Button(left, top + 42, 22, 20, this.makeLabel(MINUS, a), btn -> this.addQty(-a)));
        buttons.add(new Button(left + 28, top + 42, 28, 20, this.makeLabel(MINUS, b), btn -> this.addQty(-b)));
        buttons.add(new Button(left + 62, top + 42, 32, 20, this.makeLabel(MINUS, c), btn -> this.addQty(-c)));
        buttons.add(new Button(left + 100, top + 42, 38, 20, this.makeLabel(MINUS, d), btn -> this.addQty(-d)));
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon();
            this.validationIcon.field_230690_l_ = left + 104;
            this.validationIcon.field_230691_m_ = top + 27;
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addWidget);
        this.buttons = buttons;
        this.validate();
        screen.func_231049_c__(true);
    }

    public OptionalInt getIntValue() {
        String text = this.textField.func_146179_b().trim();
        try {
            int value = Integer.parseInt(text, 10);
            if ((long)value < this.minValue) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(value);
        }
        catch (NumberFormatException ignored) {
            return OptionalInt.empty();
        }
    }

    public OptionalLong getLongValue() {
        String text = this.textField.func_146179_b().trim();
        try {
            long value = Long.parseLong(text, 10);
            if (value < this.minValue) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(value);
        }
        catch (NumberFormatException ignored) {
            return OptionalLong.empty();
        }
    }

    public void setValue(long value) {
        this.textField.func_146180_a(String.valueOf(Math.max(this.minValue, value)));
        this.textField.func_146202_e();
        this.textField.func_146199_i(0);
        this.validate();
    }

    private void addQty(long i) {
        this.getLongValue().ifPresent(currentValue -> this.setValue(currentValue + i));
    }

    public void render(MatrixStack matrices, int mouseX, int mouseY, float partialTicks) {
        this.textField.func_230430_a_(matrices, mouseX, mouseY, partialTicks);
    }

    private void validate() {
        ArrayList<ITextComponent> validationErrors = new ArrayList<ITextComponent>();
        String text = this.textField.func_146179_b().trim();
        try {
            long value = Long.parseLong(text, 10);
            if (value < this.minValue) {
                validationErrors.add((ITextComponent)new TranslationTextComponent(NUMBER_LESS_THAN_MIN_VALUE, new Object[]{this.minValue}));
            }
        }
        catch (NumberFormatException ignored) {
            validationErrors.add(INVALID_NUMBER);
        }
        boolean valid = validationErrors.isEmpty();
        this.textField.func_146193_g(valid ? 0xFFFFFF : 16718080);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(validationErrors);
        }
    }

    private ITextComponent makeLabel(ITextComponent prefix, int amount) {
        return prefix.func_230531_f_().func_240702_b_(String.valueOf(amount));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }
}

