/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.container.me.crafting.CraftAmountContainer;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;

public class ConfirmAutoCraftPacket
extends BasePacket {
    private final int amount;
    private final boolean autoStart;

    public ConfirmAutoCraftPacket(PacketBuffer stream) {
        this.autoStart = stream.readBoolean();
        this.amount = stream.readInt();
    }

    public ConfirmAutoCraftPacket(int craftAmt, boolean autoStart) {
        this.amount = craftAmt;
        this.autoStart = autoStart;
        PacketBuffer data = new PacketBuffer(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(autoStart);
        data.writeInt(this.amount);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, PlayerEntity player) {
        if (player.field_71070_bA instanceof CraftAmountContainer) {
            CraftAmountContainer cca = (CraftAmountContainer)player.field_71070_bA;
            cca.confirm(this.amount, this.autoStart);
        }
    }
}

