/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import twilightforest.TwilightForestMod;
import twilightforest.entity.KoboldEntity;
import twilightforest.entity.TFEntities;
import twilightforest.structures.HedgeMazeComponent;
import twilightforest.structures.HollowHillComponent;
import twilightforest.structures.HydraLairComponent;
import twilightforest.structures.QuestGroveComponent;
import twilightforest.structures.YetiCaveComponent;
import twilightforest.structures.courtyard.NagaCourtyardMainComponent;
import twilightforest.structures.darktower.DarkTowerMainComponent;
import twilightforest.structures.finalcastle.FinalCastleMainComponent;
import twilightforest.structures.icetower.IceTowerMainComponent;
import twilightforest.structures.lichtower.TowerMainComponent;
import twilightforest.structures.minotaurmaze.MazeRuinsComponent;
import twilightforest.structures.mushroomtower.MushroomTowerMainComponent;
import twilightforest.structures.stronghold.StrongholdEntranceComponent;
import twilightforest.structures.trollcave.TrollCaveMainComponent;
import twilightforest.structures.trollcave.TrollCavePieces;
import twilightforest.util.IntPair;
import twilightforest.util.PlayerHelper;
import twilightforest.worldgen.biomes.BiomeKeys;

public enum TFFeature {
    NOTHING(0, "no_feature", false, new ResourceLocation[0]){
        {
            this.enableDecorations().disableStructure();
        }
    }
    ,
    SMALL_HILL(1, "small_hollow_hill", true, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.field_200748_an, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200725_aD, 10, 4, 4).addMonster(TFEntities.redcap, 10, 4, 4).addMonster(TFEntities.swarm_spider, 10, 4, 4).addMonster(TFEntities.kobold, 10, 4, 8);
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x, y - 2, z);
        }
    }
    ,
    MEDIUM_HILL(2, "medium_hollow_hill", true, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.addMonster(TFEntities.redcap, 10, 4, 4).addMonster(TFEntities.redcap_sapper, 1, 1, 4).addMonster(TFEntities.kobold, 10, 4, 8).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200741_ag, 10, 4, 4).addMonster(TFEntities.swarm_spider, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200748_an, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 10, 4, 4).addMonster(TFEntities.fire_beetle, 5, 4, 4).addMonster(TFEntities.slime_beetle, 5, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200759_ay, 1, 1, 1);
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x, y - 5, z);
        }
    }
    ,
    LARGE_HILL(3, "large_hollow_hill", true, true, new ResourceLocation[0]){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.addMonster(TFEntities.redcap, 10, 4, 4).addMonster(TFEntities.redcap_sapper, 2, 1, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200741_ag, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200794_h, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200803_q, 1, 1, 4).addMonster(TFEntities.wraith, 2, 1, 4).addMonster(TFEntities.fire_beetle, 10, 4, 4).addMonster(TFEntities.slime_beetle, 10, 4, 4).addMonster(TFEntities.pinch_beetle, 10, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200759_ay, 1, 1, 1);
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new HollowHillComponent(TFHill, this, 0, this.size, x, y - 5, z);
        }
    }
    ,
    HEDGE_MAZE(2, "hedge_maze", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new HedgeMazeComponent(this, 0, x, y, z);
        }
    }
    ,
    NAGA_COURTYARD(3, "naga_courtyard", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new NagaCourtyardMainComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    LICH_TOWER(1, "lich_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_naga")}){
        {
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.field_200725_aD, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200741_ag, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 1, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200803_q, 1, 1, 4).addMonster(TFEntities.death_tome, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200759_ay, 1, 1, 1);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.lichtower", 4);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on a Pointy Tower"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new TowerMainComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    ICE_TOWER(2, "ice_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_yeti")}){
        {
            this.addMonster(TFEntities.snow_guardian, 10, 4, 4).addMonster(TFEntities.stable_ice_core, 10, 4, 4).addMonster(TFEntities.unstable_ice_core, 5, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.icetower", 3);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on Auroral Fortification"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new IceTowerMainComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    QUEST_ISLAND(1, "quest_island", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    QUEST_GROVE(1, "quest_grove", true, new ResourceLocation[0]){
        {
            this.enableTerrainAlterations();
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new QuestGroveComponent(this, 0, x, y, z);
        }
    }
    ,
    DRUID_GROVE(1, "druid_grove", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    FLOATING_RUINS(3, "floating_ruins", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    HYDRA_LAIR(2, "hydra_lair", true, true, new ResourceLocation[]{TwilightForestMod.prefix("progress_labyrinth")}){
        {
            this.enableTerrainAlterations();
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.hydralair", 4);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on the Fire Swamp"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new HydraLairComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    LABYRINTH(3, "labyrinth", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations();
            this.addMonster(TFEntities.minotaur, 20, 2, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200794_h, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 10, 4, 4).addMonster(TFEntities.maze_slime, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200803_q, 1, 1, 4).addMonster(TFEntities.fire_beetle, 10, 4, 4).addMonster(TFEntities.slime_beetle, 10, 4, 4).addMonster(TFEntities.pinch_beetle, 10, 2, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.labyrinth", 5);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on a Swampy Labyrinth"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new MazeRuinsComponent(this, 0, x, y, z);
        }

        @Override
        public GenerationStage.Decoration getDecorationStage() {
            return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
        }
    }
    ,
    DARK_TOWER(1, "dark_tower", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_knights")}){
        {
            this.addMonster(TFEntities.tower_golem, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200741_ag, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200803_q, 2, 1, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200759_ay, 1, 1, 1).addMonster(TFEntities.mini_ghast, 10, 1, 4).addMonster(TFEntities.tower_broodling, 10, 8, 8).addMonster(TFEntities.pinch_beetle, 10, 2, 4).addMonster(1, TFEntities.tower_ghast, 10, 1, 4).addWaterCreature((EntityType<? extends LivingEntity>)EntityType.field_200749_ao, 10, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.darktower", 3);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on a Wooden Tower"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new DarkTowerMainComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    KNIGHT_STRONGHOLD(3, "knight_stronghold", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_trophy_pedestal")}){
        {
            this.enableDecorations().disableProtectionAura();
            this.addMonster(TFEntities.blockchain_goblin, 10, 4, 4).addMonster(TFEntities.goblin_knight_lower, 5, 1, 2).addMonster(TFEntities.helmet_crab, 10, 4, 4).addMonster(TFEntities.slime_beetle, 10, 4, 4).addMonster(TFEntities.redcap_sapper, 2, 1, 4).addMonster(TFEntities.kobold, 10, 4, 8).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 10, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200743_ai, 5, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.tfstronghold", 5);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on a Stronghold"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new StrongholdEntranceComponent(this, 0, x, y, z);
        }

        @Override
        public GenerationStage.Decoration getDecorationStage() {
            return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
        }
    }
    ,
    WORLD_TREE(3, "world_tree", false, new ResourceLocation[0]){
        {
            this.disableStructure();
        }
    }
    ,
    YETI_CAVE(2, "yeti_lairs", true, true, new ResourceLocation[]{TwilightForestMod.prefix("progress_lich")}){
        {
            this.enableDecorations().enableTerrainAlterations();
            this.addMonster(TFEntities.yeti, 10, 4, 4);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.yeticave", 3);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on an Icy Cave"));
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new YetiCaveComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    TROLL_CAVE(4, "troll_lairs", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_merge")}){
        {
            this.enableDecorations().enableTerrainAlterations().disableProtectionAura();
            this.addMonster((EntityType<? extends LivingEntity>)EntityType.field_200797_k, 5, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200741_ag, 10, 4, 4).addMonster(TFEntities.troll, 20, 4, 4).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200759_ay, 5, 1, 1).addMonster(1, TFEntities.giant_miner, 10, 1, 1).addMonster(1, TFEntities.armored_giant, 10, 1, 1);
        }

        @Override
        protected void addBookInformation(ItemStack book, ListNBT bookPages) {
            TFFeature.addTranslatedPages(bookPages, "twilightforest.book.trollcave", 3);
            book.func_77983_a("pages", (INBT)bookPages);
            book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)TFFeature.BOOK_AUTHOR));
            book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on the Highlands"));
        }

        @Override
        public GenerationStage.Decoration getDecorationStage() {
            return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new TrollCaveMainComponent(TrollCavePieces.TFTCMai, this, 0, x, y, z);
        }
    }
    ,
    FINAL_CASTLE(4, "final_castle", true, new ResourceLocation[]{TwilightForestMod.prefix("progress_troll")}){
        {
            this.addMonster(TFEntities.kobold, 10, 4, 4).addMonster(TFEntities.adherent, 10, 1, 1).addMonster(TFEntities.harbinger_cube, 10, 1, 1).addMonster((EntityType<? extends LivingEntity>)EntityType.field_200803_q, 10, 1, 1).addMonster(1, TFEntities.kobold, 10, 4, 4).addMonster(1, TFEntities.adherent, 10, 1, 1).addMonster(1, TFEntities.harbinger_cube, 10, 1, 1).addMonster(1, TFEntities.armored_giant, 10, 1, 1).addMonster(2, TFEntities.adherent, 10, 1, 1).addMonster(3, (EntityType<? extends LivingEntity>)EntityType.field_200792_f, 10, 1, 1);
        }

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new FinalCastleMainComponent(this, rand, 0, x, y, z);
        }
    }
    ,
    MUSHROOM_TOWER(2, "mushroom_tower", true, new ResourceLocation[0]){

        @Override
        public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
            return new MushroomTowerMainComponent(this, rand, 0, x, y, z);
        }
    };

    private static final Map<ResourceLocation, TFFeature> BIOME_FEATURES;
    public static final IStructurePieceType TFHill;
    public static final IStructurePieceType TFHedge;
    public static final IStructurePieceType TFQuest1;
    public static final IStructurePieceType TFHydra;
    public static final IStructurePieceType TFYeti;
    public final int size;
    public final String name;
    public final boolean centerBounds;
    public boolean areChunkDecorationsEnabled;
    public boolean isStructureEnabled;
    public boolean isTerrainAltered;
    private final ResourceLocation[] requiredAdvancements;
    public boolean hasProtectionAura;
    private List<List<MobSpawnInfo.Spawners>> spawnableMonsterLists;
    private List<MobSpawnInfo.Spawners> ambientCreatureList;
    private List<MobSpawnInfo.Spawners> waterCreatureList;
    private long lastSpawnedHintMonsterTime;
    private static final String BOOK_AUTHOR = "A Forgotten Explorer";
    private static final TFFeature[] VALUES;
    private static final int maxSize;

    private TFFeature(int size, String name, boolean featureGenerator, ResourceLocation ... requiredAdvancements) {
        this(size, name, featureGenerator, false, requiredAdvancements);
    }

    private TFFeature(int size, String name, boolean featureGenerator, boolean centerBounds, ResourceLocation ... requiredAdvancements) {
        this.size = size;
        this.name = name;
        this.areChunkDecorationsEnabled = false;
        this.isStructureEnabled = true;
        this.isTerrainAltered = false;
        this.spawnableMonsterLists = new ArrayList<List<MobSpawnInfo.Spawners>>();
        this.ambientCreatureList = new ArrayList<MobSpawnInfo.Spawners>();
        this.waterCreatureList = new ArrayList<MobSpawnInfo.Spawners>();
        this.hasProtectionAura = true;
        if (!name.equals("hydra_lair")) {
            this.ambientCreatureList.add(new MobSpawnInfo.Spawners(EntityType.field_200791_e, 10, 8, 8));
        }
        this.requiredAdvancements = requiredAdvancements;
        this.centerBounds = centerBounds;
    }

    static void init() {
    }

    public static int getCount() {
        return VALUES.length;
    }

    public static int getMaxSize() {
        return maxSize;
    }

    public static TFFeature getFeatureByName(String name) {
        for (TFFeature feature : VALUES) {
            if (!feature.name.equalsIgnoreCase(name)) continue;
            return feature;
        }
        return NOTHING;
    }

    public static TFFeature getFeatureByName(ResourceLocation name) {
        if (name.func_110624_b().equalsIgnoreCase("twilightforest")) {
            return TFFeature.getFeatureByName(name.func_110623_a());
        }
        return NOTHING;
    }

    public static TFFeature getFeatureByID(int id) {
        return id < VALUES.length ? VALUES[id] : NOTHING;
    }

    public static int getFeatureID(int mapX, int mapZ, ISeedReader world) {
        return TFFeature.getFeatureAt(mapX, mapZ, world).ordinal();
    }

    public static TFFeature getFeatureAt(int mapX, int mapZ, ISeedReader world) {
        return TFFeature.generateFeature(mapX >> 4, mapZ >> 4, world);
    }

    public static boolean isInFeatureChunk(int mapX, int mapZ) {
        int chunkX = mapX >> 4;
        int chunkZ = mapZ >> 4;
        BlockPos cc = TFFeature.getNearestCenterXYZ(chunkX, chunkZ);
        return chunkX == cc.func_177958_n() >> 4 && chunkZ == cc.func_177952_p() >> 4;
    }

    public TFFeature enableDecorations() {
        this.areChunkDecorationsEnabled = true;
        return this;
    }

    public TFFeature disableStructure() {
        this.isStructureEnabled = false;
        return this;
    }

    public TFFeature enableTerrainAlterations() {
        this.isTerrainAltered = true;
        return this;
    }

    public TFFeature disableProtectionAura() {
        this.hasProtectionAura = false;
        return this;
    }

    public TFFeature addMonster(EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        this.addMonster(0, monsterClass, weight, minGroup, maxGroup);
        return this;
    }

    public TFFeature addMonster(int listIndex, EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        List<Object> monsterList;
        if (this.spawnableMonsterLists.size() > listIndex) {
            monsterList = this.spawnableMonsterLists.get(listIndex);
        } else {
            monsterList = new ArrayList();
            this.spawnableMonsterLists.add(listIndex, monsterList);
        }
        monsterList.add(new MobSpawnInfo.Spawners(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public TFFeature addWaterCreature(EntityType<? extends LivingEntity> monsterClass, int weight, int minGroup, int maxGroup) {
        this.waterCreatureList.add(new MobSpawnInfo.Spawners(monsterClass, weight, minGroup, maxGroup));
        return this;
    }

    public static TFFeature getFeatureDirectlyAt(int chunkX, int chunkZ, ISeedReader world) {
        if (TFFeature.isInFeatureChunk(chunkX << 4, chunkZ << 4)) {
            return TFFeature.getFeatureAt(chunkX << 4, chunkZ << 4, world);
        }
        return NOTHING;
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, ISeedReader world) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        Biome biomeAt = world.func_226691_t_(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
        return TFFeature.generateFeature(chunkX, chunkZ, biomeAt, world.func_72905_C());
    }

    public static TFFeature generateFeature(int chunkX, int chunkZ, Biome biome, long seed) {
        chunkX = Math.round((float)chunkX / 16.0f) * 16;
        chunkZ = Math.round((float)chunkZ / 16.0f) * 16;
        TFFeature biomeFeature = BIOME_FEATURES.get(biome.getRegistryName());
        if (biomeFeature != null) {
            return biomeFeature;
        }
        int regionOffsetX = Math.abs((chunkX + 64 >> 4) % 8);
        int regionOffsetZ = Math.abs((chunkZ + 64 >> 4) % 8);
        if (regionOffsetX == 4 && regionOffsetZ == 5 || regionOffsetX == 4 && regionOffsetZ == 3) {
            return LICH_TOWER;
        }
        if (regionOffsetX == 5 && regionOffsetZ == 4 || regionOffsetX == 3 && regionOffsetZ == 4) {
            return NAGA_COURTYARD;
        }
        switch (new Random(seed + (long)(chunkX * 25117) + (long)(chunkZ * 151121)).nextInt(16)) {
            default: {
                return SMALL_HILL;
            }
            case 6: 
            case 7: 
            case 8: {
                return MEDIUM_HILL;
            }
            case 9: {
                return LARGE_HILL;
            }
            case 10: 
            case 11: {
                return HEDGE_MAZE;
            }
            case 12: 
            case 13: {
                return NAGA_COURTYARD;
            }
            case 14: 
            case 15: 
        }
        return LICH_TOWER;
    }

    public static TFFeature getNearestFeature(int cx, int cz, ISeedReader world) {
        return TFFeature.getNearestFeature(cx, cz, world, null);
    }

    public static TFFeature getNearestFeature(int cx, int cz, ISeedReader world, @Nullable IntPair center) {
        int diam = maxSize * 2 + 1;
        TFFeature[] features = new TFFeature[diam * diam];
        for (int rad = 1; rad <= maxSize; ++rad) {
            for (int x = -rad; x <= rad; ++x) {
                for (int z = -rad; z <= rad; ++z) {
                    int idx = (x + maxSize) * diam + (z + maxSize);
                    TFFeature directlyAt = features[idx];
                    if (directlyAt == null) {
                        features[idx] = directlyAt = TFFeature.getFeatureDirectlyAt(x + cx, z + cz, world);
                    }
                    if (directlyAt.size != rad) continue;
                    if (center != null) {
                        center.x = (x << 4) + 8;
                        center.z = (z << 4) + 8;
                    }
                    return directlyAt;
                }
            }
        }
        return NOTHING;
    }

    @Nullable
    public static BlockPos findNearestFeaturePosBySpacing(ISeedReader worldIn, TFFeature feature, BlockPos blockPos, int p_191069_3_, int p_191069_4_, int p_191069_5_, boolean p_191069_6_, int p_191069_7_, boolean findUnexplored) {
        int i = blockPos.func_177958_n() >> 4;
        int j = blockPos.func_177952_p() >> 4;
        Random random = new Random();
        block0: for (int k = 0; k <= p_191069_7_; ++k) {
            for (int l = -k; l <= k; ++l) {
                boolean flag = l == -k || l == k;
                for (int i1 = -k; i1 <= k; ++i1) {
                    boolean flag1;
                    boolean bl = flag1 = i1 == -k || i1 == k;
                    if (!flag && !flag1) continue;
                    int j1 = i + p_191069_3_ * l;
                    int k1 = j + p_191069_3_ * i1;
                    if (j1 < 0) {
                        j1 -= p_191069_3_ - 1;
                    }
                    if (k1 < 0) {
                        k1 -= p_191069_3_ - 1;
                    }
                    int l1 = j1 / p_191069_3_;
                    int i2 = k1 / p_191069_3_;
                    Random random1 = new Random();
                    l1 *= p_191069_3_;
                    i2 *= p_191069_3_;
                    if (p_191069_6_) {
                        l1 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                        i2 += (random1.nextInt(p_191069_3_ - p_191069_4_) + random1.nextInt(p_191069_3_ - p_191069_4_)) / 2;
                    } else {
                        l1 += random1.nextInt(p_191069_3_ - p_191069_4_);
                        i2 += random1.nextInt(p_191069_3_ - p_191069_4_);
                    }
                    random.nextInt();
                    if (TFFeature.getFeatureAt(l1 << 4, i2 << 4, (ISeedReader)worldIn.func_201672_e()) == feature) {
                        if (findUnexplored && worldIn.func_217354_b(l1, i2)) continue;
                        return new BlockPos((l1 << 4) + 8, 64, (i2 << 4) + 8);
                    }
                    if (k == 0) break;
                }
                if (k == 0) continue block0;
            }
        }
        return null;
    }

    public static TFFeature getFeatureForRegion(int chunkX, int chunkZ, ISeedReader world) {
        int featureX = Math.round((float)chunkX / 16.0f) * 16;
        int featureZ = Math.round((float)chunkZ / 16.0f) * 16;
        return TFFeature.generateFeature(featureX, featureZ, world);
    }

    public static TFFeature getFeatureForRegionPos(int posX, int posZ, ISeedReader world) {
        return TFFeature.getFeatureForRegion(posX >> 4, posZ >> 4, world);
    }

    public static BlockPos getNearestCenterXYZ(int cx, int cz) {
        int regionX = cx + 8 >> 4;
        int regionZ = cz + 8 >> 4;
        long seed = (long)(regionX * 3129871) ^ (long)regionZ * 116129781L;
        seed = seed * seed * 42317861L + seed * 7L;
        int num0 = (int)(seed >> 12 & 3L);
        int num1 = (int)(seed >> 15 & 3L);
        int num2 = (int)(seed >> 18 & 3L);
        int num3 = (int)(seed >> 21 & 3L);
        int centerX = 8 + num0 - num1;
        int centerZ = 8 + num2 - num3;
        int ccz = regionZ >= 0 ? (regionZ * 16 + centerZ - 8) * 16 + 8 : (regionZ * 16 + (16 - centerZ) - 8) * 16 + 9;
        int ccx = regionX >= 0 ? (regionX * 16 + centerX - 8) * 16 + 8 : (regionX * 16 + (16 - centerX) - 8) * 16 + 9;
        return new BlockPos(ccx, 31, ccz);
    }

    public List<MobSpawnInfo.Spawners> getCombinedMonsterSpawnableList() {
        ArrayList<MobSpawnInfo.Spawners> list = new ArrayList<MobSpawnInfo.Spawners>();
        this.spawnableMonsterLists.forEach(l -> {
            if (l != null) {
                list.addAll((Collection<MobSpawnInfo.Spawners>)l);
            }
        });
        return list;
    }

    public List<MobSpawnInfo.Spawners> getCombinedCreatureSpawnableList() {
        ArrayList<MobSpawnInfo.Spawners> list = new ArrayList<MobSpawnInfo.Spawners>();
        list.addAll(this.ambientCreatureList);
        list.addAll(this.waterCreatureList);
        return list;
    }

    public List<MobSpawnInfo.Spawners> getSpawnableList(EntityClassification creatureType) {
        switch (creatureType) {
            case MONSTER: {
                return this.getSpawnableMonsterList(0);
            }
            case AMBIENT: {
                return this.ambientCreatureList;
            }
            case WATER_CREATURE: {
                return this.waterCreatureList;
            }
        }
        return new ArrayList<MobSpawnInfo.Spawners>();
    }

    public List<MobSpawnInfo.Spawners> getSpawnableMonsterList(int index) {
        if (index >= 0 && index < this.spawnableMonsterLists.size()) {
            return this.spawnableMonsterLists.get(index);
        }
        return new ArrayList<MobSpawnInfo.Spawners>();
    }

    public boolean doesPlayerHaveRequiredAdvancements(PlayerEntity player) {
        return PlayerHelper.doesPlayerHaveRequiredAdvancements(player, this.requiredAdvancements);
    }

    public void trySpawnHintMonster(World world, PlayerEntity player) {
        this.trySpawnHintMonster(world, player, player.func_233580_cy_());
    }

    public void trySpawnHintMonster(World world, PlayerEntity player, BlockPos pos) {
        long currentTime = world.func_82737_E();
        if (currentTime < this.lastSpawnedHintMonsterTime) {
            this.lastSpawnedHintMonsterTime = 0L;
        }
        if (currentTime - this.lastSpawnedHintMonsterTime > 1200L) {
            for (int i = 0; i < 20; ++i) {
                if (!this.didSpawnHintMonster(world, player, pos)) continue;
                this.lastSpawnedHintMonsterTime = currentTime;
                break;
            }
        }
    }

    private boolean didSpawnHintMonster(World world, PlayerEntity player, BlockPos pos) {
        int dx = world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16);
        int dy = world.field_73012_v.nextInt(4) - world.field_73012_v.nextInt(4);
        int dz = world.field_73012_v.nextInt(16) - world.field_73012_v.nextInt(16);
        KoboldEntity hinty = new KoboldEntity(TFEntities.kobold, world);
        hinty.func_174828_a(pos.func_177982_a(dx, dy, dz), 0.0f, 0.0f);
        if (hinty.func_205019_a((IWorldReader)world) && hinty.func_70635_at().func_75522_a((Entity)player)) {
            ItemStack book = this.createHintBook();
            hinty.func_184201_a(EquipmentSlotType.MAINHAND, book);
            hinty.func_184642_a(EquipmentSlotType.MAINHAND, 1.0f);
            world.func_217376_c((Entity)hinty);
            return true;
        }
        return false;
    }

    public ItemStack createHintBook() {
        ItemStack book = new ItemStack((IItemProvider)Items.field_151164_bB);
        this.addBookInformation(book, new ListNBT());
        return book;
    }

    protected void addBookInformation(ItemStack book, ListNBT bookPages) {
        TFFeature.addTranslatedPages(bookPages, "twilightforest.book.unknown", 2);
        book.func_77983_a("pages", (INBT)bookPages);
        book.func_77983_a("author", (INBT)StringNBT.func_229705_a_((String)BOOK_AUTHOR));
        book.func_77983_a("title", (INBT)StringNBT.func_229705_a_((String)"Notes on the Unexplained"));
    }

    @Nullable
    public StructurePiece provideStructureStart(Random rand, int x, int y, int z) {
        return null;
    }

    public GenerationStage.Decoration getDecorationStage() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    private static void addTranslatedPages(ListNBT bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.add((Object)StringNBT.func_229705_a_((String)ITextComponent.Serializer.func_150696_a((ITextComponent)new TranslationTextComponent(translationKey + "." + i))));
        }
    }

    public static IStructurePieceType registerPiece(String name, IStructurePieceType piece) {
        return (IStructurePieceType)Registry.func_218322_a((Registry)Registry.field_218362_C, (ResourceLocation)TwilightForestMod.prefix(name.toLowerCase(Locale.ROOT)), (Object)piece);
    }

    public final MutableBoundingBox getComponentToAddBoundingBox(int x, int y, int z, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, @Nullable Direction dir) {
        if (this.centerBounds) {
            x += (maxX + minX) / 4;
            y += (maxY + minY) / 4;
            z += (maxZ + minZ) / 4;
        }
        switch (dir) {
            default: {
                return new MutableBoundingBox(x + minX, y + minY, z + minZ, x + maxX + minX, y + maxY + minY, z + maxZ + minZ);
            }
            case WEST: {
                return new MutableBoundingBox(x - maxZ + minZ, y + minY, z + minX, x + minZ, y + maxY + minY, z + maxX + minX);
            }
            case NORTH: {
                return new MutableBoundingBox(x - maxX - minX, y + minY, z - maxZ - minZ, x - minX, y + maxY + minY, z - minZ);
            }
            case EAST: 
        }
        return new MutableBoundingBox(x + minZ, y + minY, z - maxX, x + maxZ + minZ, y + maxY + minY, z + minX);
    }

    static {
        BIOME_FEATURES = new ImmutableMap.Builder().put((Object)BiomeKeys.DARK_FOREST.func_240901_a_(), (Object)KNIGHT_STRONGHOLD).put((Object)BiomeKeys.DARK_FOREST_CENTER.func_240901_a_(), (Object)DARK_TOWER).put((Object)BiomeKeys.DENSE_MUSHROOM_FOREST.func_240901_a_(), (Object)MUSHROOM_TOWER).put((Object)BiomeKeys.ENCHANTED_FOREST.func_240901_a_(), (Object)QUEST_GROVE).put((Object)BiomeKeys.FINAL_PLATEAU.func_240901_a_(), (Object)FINAL_CASTLE).put((Object)BiomeKeys.FIRE_SWAMP.func_240901_a_(), (Object)HYDRA_LAIR).put((Object)BiomeKeys.GLACIER.func_240901_a_(), (Object)ICE_TOWER).put((Object)BiomeKeys.HIGHLANDS.func_240901_a_(), (Object)TROLL_CAVE).put((Object)BiomeKeys.SNOWY_FOREST.func_240901_a_(), (Object)YETI_CAVE).put((Object)BiomeKeys.SWAMP.func_240901_a_(), (Object)LABYRINTH).put((Object)BiomeKeys.LAKE.func_240901_a_(), (Object)QUEST_ISLAND).build();
        TFHill = TFFeature.registerPiece("TFHill", HollowHillComponent::new);
        TFHedge = TFFeature.registerPiece("TFHedge", HedgeMazeComponent::new);
        TFQuest1 = TFFeature.registerPiece("TFQuest1", QuestGroveComponent::new);
        TFHydra = TFFeature.registerPiece("TFHydra", HydraLairComponent::new);
        TFYeti = TFFeature.registerPiece("TFYeti", YetiCaveComponent::new);
        VALUES = TFFeature.values();
        maxSize = Arrays.stream(VALUES).mapToInt(v -> v.size).max().orElse(0);
    }
}

