/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import twilightforest.data.BlockTagGenerator;
import twilightforest.data.FluidTagGenerator;
import twilightforest.enums.FireJetVariant;
import twilightforest.tileentity.FireJetTileEntity;

public class FireJetBlock
extends Block {
    public static final EnumProperty<FireJetVariant> STATE = EnumProperty.func_177709_a((String)"state", FireJetVariant.class);

    protected FireJetBlock(AbstractBlock.Properties props) {
        super(props);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(STATE, (Comparable)((Object)FireJetVariant.IDLE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{STATE});
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return state.func_177229_b(STATE) == FireJetVariant.IDLE ? null : PathNodeType.DAMAGE_FIRE;
    }

    @Deprecated
    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        BlockPos lavaPos;
        if (!world.field_72995_K && state.func_177229_b(STATE) == FireJetVariant.IDLE && this.isLava((World)world, lavaPos = this.findLavaAround((World)world, pos.func_177977_b()))) {
            world.func_175656_a(lavaPos, Blocks.field_150350_a.func_176223_P());
            world.func_175656_a(pos, (BlockState)state.func_206870_a(STATE, (Comparable)((Object)FireJetVariant.POPPING)));
        }
    }

    private BlockPos findLavaAround(World world, BlockPos pos) {
        if (this.isLava(world, pos)) {
            return pos;
        }
        for (int i = 0; i < 3; ++i) {
            BlockPos randPos = pos.func_177982_a(world.field_73012_v.nextInt(3) - 1, 0, world.field_73012_v.nextInt(3) - 1);
            if (!this.isLava(world, randPos)) continue;
            return randPos;
        }
        return pos;
    }

    private boolean isLava(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        return b.func_203417_a(BlockTagGenerator.FIRE_JET_FUEL) || b.func_204507_t(state).func_206884_a(FluidTagGenerator.FIRE_JET_FUEL);
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(STATE) == FireJetVariant.POPPING || state.func_177229_b(STATE) == FireJetVariant.FLAME;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.hasTileEntity(state) ? new FireJetTileEntity() : null;
    }
}

