/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import net.minecraft.block.WoodType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.world.DimensionRenderInfo;
import net.minecraft.entity.LivingEntity;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.LoadingScreenListener;
import twilightforest.client.OptifineWarningScreen;
import twilightforest.client.RenderLayerRegistration;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.TwilightLegacyPack;
import twilightforest.client.renderer.entity.IceLayer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.entity.TFEntities;
import twilightforest.inventory.TFContainers;
import twilightforest.item.ArcticArmorItem;
import twilightforest.item.FieryArmorItem;
import twilightforest.item.KnightmetalArmorItem;
import twilightforest.item.PhantomArmorItem;
import twilightforest.item.TFItems;
import twilightforest.item.YetiArmorItem;
import twilightforest.tileentity.TFTileEntities;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="twilightforest")
public class TFClientSetup {
    public static boolean optifinePresent = false;

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent evt) {
        try {
            Class.forName("net.optifine.Config");
            optifinePresent = true;
        }
        catch (ClassNotFoundException e) {
            optifinePresent = false;
        }
        TFItems.addItemModelProperties();
        KnightmetalArmorItem.initArmorModel();
        PhantomArmorItem.initArmorModel();
        YetiArmorItem.initArmorModel();
        ArcticArmorItem.initArmorModel();
        FieryArmorItem.initArmorModel();
        MinecraftForge.EVENT_BUS.register((Object)new LoadingScreenListener());
        RenderLayerRegistration.init();
        TFEntities.registerEntityRenderer();
        TFTileEntities.registerTileEntityRenders();
        TFContainers.renderScreens();
        TwilightForestRenderInfo renderInfo = new TwilightForestRenderInfo(128.0f, false, DimensionRenderInfo.FogType.NONE, false, false);
        DimensionRenderInfo.field_239208_a_.put((Object)TwilightForestMod.prefix("renderer"), (Object)renderInfo);
        evt.enqueueWork(() -> {
            Atlases.addWoodType((WoodType)TFBlocks.TWILIGHT_OAK);
            Atlases.addWoodType((WoodType)TFBlocks.CANOPY);
            Atlases.addWoodType((WoodType)TFBlocks.MANGROVE);
            Atlases.addWoodType((WoodType)TFBlocks.DARKWOOD);
            Atlases.addWoodType((WoodType)TFBlocks.TIMEWOOD);
            Atlases.addWoodType((WoodType)TFBlocks.TRANSFORMATION);
            Atlases.addWoodType((WoodType)TFBlocks.MINING);
            Atlases.addWoodType((WoodType)TFBlocks.SORTING);
        });
    }

    public static void addLegacyPack() {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        Minecraft.func_71410_x().func_195548_H().addPackFinder((consumer, iFactory) -> consumer.accept(ResourcePackInfo.func_195793_a((String)TwilightForestMod.prefix("classic_textures").toString(), (boolean)false, () -> new TwilightLegacyPack(ModList.get().getModFileById("twilightforest").getFile()), (ResourcePackInfo.IFactory)iFactory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, iTextComponent -> iTextComponent)));
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent evt) {
        Minecraft.func_71410_x().func_175598_ae().field_78729_o.values().forEach(r -> {
            if (r instanceof LivingRenderer) {
                TFClientSetup.attachRenderLayers((LivingRenderer)r);
            }
        });
        Minecraft.func_71410_x().func_175598_ae().getSkinMap().values().forEach(TFClientSetup::attachRenderLayers);
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void attachRenderLayers(LivingRenderer<T, M> renderer) {
        renderer.func_177094_a(new ShieldLayer<T, M>(renderer));
        renderer.func_177094_a(new IceLayer<T, M>(renderer));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE, modid="twilightforest")
    public static class ForgeEvents {
        private static boolean optifineWarningShown = false;

        @SubscribeEvent
        public static void showOptifineWarning(GuiScreenEvent.InitGuiEvent.Post event) {
            if (optifinePresent && !optifineWarningShown && !((Boolean)TFConfig.CLIENT_CONFIG.disableOptifineNagScreen.get()).booleanValue() && event.getGui() instanceof MainMenuScreen) {
                optifineWarningShown = true;
                Minecraft.func_71410_x().func_147108_a((Screen)new OptifineWarningScreen(event.getGui()));
            }
        }
    }
}

