/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.network.NetworkDirection;
import twilightforest.TFMazeMapData;
import twilightforest.item.TFItems;
import twilightforest.network.MazeMapPacket;
import twilightforest.network.TFPacketHandler;

public class MazeMapItem
extends FilledMapItem {
    public static final String STR_ID = "mazemap";
    private static final int YSEARCH = 3;
    protected final boolean mapOres;

    protected MazeMapItem(boolean mapOres, Item.Properties props) {
        super(props);
        this.mapOres = mapOres;
    }

    public static ItemStack setupNewMap(World world, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking, int worldY, boolean mapOres) {
        ItemStack itemstack = new ItemStack(mapOres ? (IItemProvider)TFItems.ore_map.get() : (IItemProvider)TFItems.maze_map.get());
        MazeMapItem.createMapData(itemstack, world, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (RegistryKey<World>)world.func_234923_W_(), worldY);
        return itemstack;
    }

    @Nullable
    public static TFMazeMapData getData(ItemStack stack, World world) {
        return TFMazeMapData.getMazeMapData(world, MazeMapItem.getMapName(MazeMapItem.func_195949_f((ItemStack)stack)));
    }

    @Nullable
    protected TFMazeMapData getCustomMapData(ItemStack stack, World world) {
        TFMazeMapData mapdata = MazeMapItem.getData(stack, world);
        if (mapdata == null && !world.field_72995_K) {
            mapdata = MazeMapItem.createMapData(stack, world, world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e(), 0, false, false, (RegistryKey<World>)world.func_234923_W_(), world.func_72912_H().func_76075_d());
        }
        return mapdata;
    }

    private static TFMazeMapData createMapData(ItemStack stack, World world, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, RegistryKey<World> dimension, int y) {
        int i = world.func_217395_y();
        TFMazeMapData mapdata = new TFMazeMapData(MazeMapItem.getMapName(i));
        mapdata.func_237241_a_(x, z, scale, trackingPosition, unlimitedTracking, dimension);
        mapdata.calculateMapCenter(world, x, y, z, scale);
        TFMazeMapData.registerMazeMapData(world, mapdata);
        stack.func_196082_o().func_74768_a("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "mazemap_" + id;
    }

    public void func_77872_a(World world, Entity viewer, MapData data) {
        if (world.func_234923_W_() == data.field_76200_c && viewer instanceof PlayerEntity) {
            int blocksPerPixel = 1 << data.field_76197_d;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerX = MathHelper.func_76128_c((double)(viewer.func_226277_ct_() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = MathHelper.func_76128_c((double)(viewer.func_226281_cx_() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 16;
            if (world.func_230315_m_().func_236037_d_()) {
                viewRadiusPixels /= 2;
            }
            MapData.MapInfo mapdata$mapinfo = data.func_82568_a((PlayerEntity)viewer);
            ++mapdata$mapinfo.field_82569_d;
            boolean flag = false;
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                if ((xPixel & 0xF) != (mapdata$mapinfo.field_82569_d & 0xF) && !flag) continue;
                flag = false;
                double d0 = 0.0;
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    byte b1;
                    byte b0;
                    if (xPixel < 0 || zPixel < -1 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    int worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel;
                    int worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel;
                    HashMultiset multiset = HashMultiset.create();
                    Chunk chunk = world.func_175726_f(new BlockPos(worldX, 0, worldZ));
                    int brightness = 1;
                    if (chunk.func_76621_g()) continue;
                    int worldXRounded = worldX & 0xF;
                    int worldZRounded = worldZ & 0xF;
                    boolean numLiquid = false;
                    double d1 = 0.0;
                    if (world.func_230315_m_().func_236037_d_()) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.field_150346_d.func_176223_P().func_185909_g((IBlockReader)world, BlockPos.field_177992_a), 10);
                        } else {
                            multiset.add((Object)Blocks.field_150348_b.func_176223_P().func_185909_g((IBlockReader)world, BlockPos.field_177992_a), 100);
                        }
                    } else {
                        int yCenter = ((TFMazeMapData)data).yCenter;
                        BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable(worldXRounded, yCenter, worldZRounded);
                        BlockState state = chunk.func_180495_p((BlockPos)blockpos$mutableblockpos);
                        multiset.add((Object)state.func_185909_g((IBlockReader)world, (BlockPos)blockpos$mutableblockpos));
                        if (state.func_177230_c() == Blocks.field_150348_b || state.func_177230_c() == Blocks.field_150350_a) {
                            for (int i = -3; i <= 3; ++i) {
                                blockpos$mutableblockpos.func_185336_p(yCenter + i);
                                BlockState searchID = chunk.func_180495_p((BlockPos)blockpos$mutableblockpos);
                                if (searchID.func_177230_c() == Blocks.field_150348_b || searchID.func_177230_c() == Blocks.field_150350_a) continue;
                                state = searchID;
                                if (i > 0) {
                                    brightness = 2;
                                }
                                if (i >= 0) break;
                                brightness = 0;
                                break;
                            }
                        }
                        if (this.mapOres) {
                            if (state.func_177230_c() == Blocks.field_150365_q) {
                                multiset.add((Object)MaterialColor.field_151646_E, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150352_o) {
                                multiset.add((Object)MaterialColor.field_151647_F, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150366_p) {
                                multiset.add((Object)MaterialColor.field_151668_h, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150369_x) {
                                multiset.add((Object)MaterialColor.field_151652_H, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150450_ax) {
                                multiset.add((Object)MaterialColor.field_151645_D, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150482_ag) {
                                multiset.add((Object)MaterialColor.field_151648_G, 1000);
                            } else if (state.func_177230_c() == Blocks.field_150412_bA) {
                                multiset.add((Object)MaterialColor.field_151653_I, 1000);
                            } else if (state.func_177230_c() != Blocks.field_150350_a && state.func_235714_a_((ITag)Tags.Blocks.ORES)) {
                                multiset.add((Object)MaterialColor.field_151671_v, 1000);
                            }
                        }
                    }
                    MaterialColor mapcolor = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MaterialColor.field_151660_b);
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0 || (b0 = data.field_76198_e[xPixel + zPixel * 128]) == (b1 = (byte)(mapcolor.field_76290_q * 4 + brightness))) continue;
                    data.field_76198_e[xPixel + zPixel * 128] = b1;
                    data.func_176053_a(xPixel, zPixel);
                    flag = true;
                }
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int slot, boolean isSelected) {
        TFMazeMapData mapdata;
        if (!worldIn.field_72995_K && (mapdata = this.getCustomMapData(stack, worldIn)) != null) {
            if (entityIn instanceof PlayerEntity) {
                MapDecoration decoration;
                PlayerEntity entityplayer = (PlayerEntity)entityIn;
                mapdata.func_76191_a(entityplayer, stack);
                int yProximity = MathHelper.func_76128_c((double)(entityplayer.func_226278_cu_() - (double)mapdata.yCenter));
                if ((yProximity < -3 || yProximity > 3) && (decoration = (MapDecoration)mapdata.field_76203_h.get(entityplayer.func_200200_C_().getString())) != null) {
                    mapdata.field_76203_h.put(entityplayer.func_200200_C_().getString(), new MapDecoration(MapDecoration.Type.PLAYER_OFF_MAP, decoration.func_176112_b(), decoration.func_176113_c(), decoration.func_176111_d(), null));
                }
            }
            if (!mapdata.field_215161_h && (isSelected || entityIn instanceof PlayerEntity && ((PlayerEntity)entityIn).func_184592_cb() == stack)) {
                this.func_77872_a(worldIn, entityIn, mapdata);
            }
        }
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
    }

    @Nullable
    public IPacket<?> func_150911_c(ItemStack stack, World worldIn, PlayerEntity player) {
        IPacket p = super.func_150911_c(stack, worldIn, player);
        if (p instanceof SMapDataPacket) {
            return TFPacketHandler.CHANNEL.toVanillaPacket((Object)new MazeMapPacket((SMapDataPacket)p), NetworkDirection.PLAY_TO_CLIENT);
        }
        return p;
    }
}

