/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.FinalCastleDungeonRoom31Component;
import twilightforest.structures.finalcastle.FinalCastleDungeonStepsComponent;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.util.StructureBoundingBoxUtils;

public class FinalCastleDungeonExitComponent
extends FinalCastleDungeonRoom31Component {
    public FinalCastleDungeonExitComponent(TemplateManager manager, CompoundNBT nbt) {
        super(FinalCastlePieces.TFFCDunEx, nbt);
    }

    public FinalCastleDungeonExitComponent(TFFeature feature, Random rand, int i, int x, int y, int z, Direction direction, int level) {
        super(FinalCastlePieces.TFFCDunEx, feature, rand, i, x, y, z, direction, level);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        Rotation bestDir = this.findStairDirectionTowards(parent.func_74874_b().field_78897_a, parent.func_74874_b().field_78896_c);
        FinalCastleDungeonStepsComponent steps0 = new FinalCastleDungeonStepsComponent(this.getFeatureType(), rand, 5, this.field_74887_e.field_78897_a + 15, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 15, bestDir.func_185831_a(Direction.SOUTH));
        list.add(steps0);
        steps0.func_74861_a(this, list, rand);
        if (this.level == 1) {
            steps0.buildLevelUnder(parent, list, rand, this.level + 1);
        } else {
            steps0.buildBossRoomUnder(parent, list, rand);
        }
    }

    @Override
    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        if (!super.func_230383_a_(world, manager, generator, rand, sbb, chunkPosIn, blockPos)) {
            return false;
        }
        BlockState castleDoor = ((Block)TFBlocks.castle_door_pink.get()).func_176223_P();
        this.func_175804_a(world, sbb, 7, 0, 16, 7, 3, 18, castleDoor, AIR, false);
        this.func_175804_a(world, sbb, 7, 4, 16, 7, 4, 18, this.deco.blockState, this.deco.blockState, false);
        return true;
    }

    public Rotation findStairDirectionTowards(int x, int z) {
        Vector3i center = StructureBoundingBoxUtils.getCenter(this.field_74887_e);
        int dx = center.func_177958_n() - x;
        int dz = center.func_177952_p() - z;
        Rotation absoluteDir = Math.abs(dz) >= Math.abs(dx) ? (dz >= 0 ? Rotation.CLOCKWISE_180 : Rotation.NONE) : (dx >= 0 ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
        return absoluteDir;
    }

    @Override
    protected BlockState getForceFieldColor(Random decoRNG) {
        return ((Block)TFBlocks.force_field_pink.get()).func_176223_P();
    }

    @Override
    protected BlockState getRuneColor(BlockState fieldColor) {
        return ((Block)TFBlocks.castle_rune_brick_pink.get()).func_176223_P();
    }
}

