/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.structures.finalcastle.FinalCastleEntranceBottomTowerComponent;
import twilightforest.structures.finalcastle.FinalCastleEntranceSideTowerComponent;
import twilightforest.structures.finalcastle.FinalCastleFoundation13Component;
import twilightforest.structures.finalcastle.FinalCastleMazeTower13Component;
import twilightforest.structures.finalcastle.FinalCastlePieces;
import twilightforest.structures.finalcastle.FinalCastleRoof13PeakedComponent;

public class FinalCastleEntranceTowerComponent
extends FinalCastleMazeTower13Component {
    public FinalCastleEntranceTowerComponent(TemplateManager manager, CompoundNBT nbt) {
        super(FinalCastlePieces.TFFCEnTo, nbt);
    }

    public FinalCastleEntranceTowerComponent(TFFeature feature, Random rand, int i, int x, int y, int z, Direction direction) {
        super(FinalCastlePieces.TFFCEnTo, feature, rand, i, x, y, z, 3, 2, ((Block)TFBlocks.castle_rune_brick_pink.get()).func_176223_P(), direction);
    }

    @Override
    public void func_74861_a(StructurePiece parent, List<StructurePiece> list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        FinalCastleFoundation13Component foundation = new FinalCastleFoundation13Component(FinalCastlePieces.TFFCToF13, this.getFeatureType(), rand, 4, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        FinalCastleRoof13PeakedComponent roof = new FinalCastleRoof13PeakedComponent(this.getFeatureType(), rand, 4, this);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
        int missingFloors = (this.field_74887_e.field_78895_b - 127) / 8;
        int bottomFloors = missingFloors / 2;
        int middleFloors = missingFloors - bottomFloors;
        Direction facing = Rotation.CLOCKWISE_90.func_185831_a(this.func_186165_e());
        int howFar = 20;
        if (this.buildSideTower(list, rand, middleFloors + 1, facing, howFar) || this.buildSideTower(list, rand, middleFloors + 1, facing = Rotation.COUNTERCLOCKWISE_90.func_185831_a(this.func_186165_e()), howFar) || !this.buildSideTower(list, rand, middleFloors + 1, facing = Rotation.NONE.func_185831_a(this.func_186165_e()), howFar)) {
            // empty if block
        }
        FinalCastleEntranceBottomTowerComponent eTower = new FinalCastleEntranceBottomTowerComponent(this.getFeatureType(), rand, this.func_74877_c() + 1, this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78895_b - middleFloors * 8, this.field_74887_e.field_78896_c + 6, bottomFloors + 1, bottomFloors, facing.func_176734_d());
        list.add(eTower);
        eTower.func_74861_a(this, list, rand);
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        opening = opening.func_177979_c(middleFloors * 8);
        BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
        FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
        list.add(bridge);
        bridge.func_74861_a(this, list, rand);
    }

    private boolean buildSideTower(List<StructurePiece> list, Random rand, int middleFloors, Direction facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        FinalCastleEntranceSideTowerComponent eTower = new FinalCastleEntranceSideTowerComponent(this.getFeatureType(), rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), middleFloors, middleFloors - 1, facing);
        MutableBoundingBox largerBB = new MutableBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructurePiece intersect = StructurePiece.func_74883_a(list, (MutableBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
            return true;
        }
        TwilightForestMod.LOGGER.info("side entrance tower blocked");
        return false;
    }

    @Override
    public BlockPos getValidOpeningCC(Random rand, Direction facing) {
        BlockPos opening = super.getValidOpeningCC(rand, facing);
        return new BlockPos(opening.func_177958_n(), 0, opening.func_177952_p());
    }
}

