/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.minotaurmaze;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFConfig;
import twilightforest.TFFeature;
import twilightforest.block.TFBlocks;
import twilightforest.structures.TFMaze;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.structures.minotaurmaze.MazeCorridorComponent;
import twilightforest.structures.minotaurmaze.MazeCorridorIronFenceComponent;
import twilightforest.structures.minotaurmaze.MazeCorridorRootsComponent;
import twilightforest.structures.minotaurmaze.MazeCorridorShroomsComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndChestComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndFountainComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndFountainLavaComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndPaintingComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndRootsComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndShroomsComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndTorchesComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndTrappedChestComponent;
import twilightforest.structures.minotaurmaze.MazeDeadEndTripwireChestComponent;
import twilightforest.structures.minotaurmaze.MazeMushRoomComponent;
import twilightforest.structures.minotaurmaze.MazeRoomBossComponent;
import twilightforest.structures.minotaurmaze.MazeRoomCollapseComponent;
import twilightforest.structures.minotaurmaze.MazeRoomComponent;
import twilightforest.structures.minotaurmaze.MazeRoomExitComponent;
import twilightforest.structures.minotaurmaze.MazeRoomFountainComponent;
import twilightforest.structures.minotaurmaze.MazeRoomSpawnerChestsComponent;
import twilightforest.structures.minotaurmaze.MazeRoomVaultComponent;
import twilightforest.structures.minotaurmaze.MazestoneProcessor;
import twilightforest.structures.minotaurmaze.MinotaurMazePieces;

public class MinotaurMazeComponent
extends TFStructureComponentOld {
    TFMaze maze;
    int[] rcoords;
    private int level;

    public MinotaurMazeComponent(TemplateManager manager, CompoundNBT nbt) {
        super(MinotaurMazePieces.TFMMaze, nbt);
        this.level = nbt.func_74762_e("mazeLevel");
        this.rcoords = nbt.func_74759_k("roomCoords");
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        for (int i = 2; i < this.rcoords.length; ++i) {
            this.rcoords[i] = 0;
        }
        this.addRoomsToMaze(this.rcoords[0], this.rcoords[1], (this.rcoords.length + 1) / 2);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    public MinotaurMazeComponent(TFFeature feature, int index, int x, int y, int z, int entranceX, int entranceZ, int level) {
        super(MinotaurMazePieces.TFMMaze, feature, index);
        this.func_186164_a(Direction.SOUTH);
        this.level = level;
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -this.getRadius(), 0, -this.getRadius(), this.getRadius() * 2, 5, this.getRadius() * 2, Direction.SOUTH);
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        int nrooms = 7;
        this.rcoords = new int[nrooms * 2];
        this.addRoomsToMaze(entranceX, entranceZ, nrooms);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    private void addRoomsToMaze(int entranceX, int entranceZ, int nrooms) {
        this.rcoords[0] = entranceX;
        this.rcoords[1] = entranceZ;
        this.maze.carveRoom1(entranceX, entranceZ);
        for (int i = 1; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, rz = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, this.rcoords, i == 1 ? 7 : 4)) {
            }
            this.maze.carveRoom1(rx, rz);
            this.rcoords[i * 2] = rx;
            this.rcoords[i * 2 + 1] = rz;
        }
    }

    private void setFixedMazeSeed() {
        this.maze.setSeed(this.field_74887_e.field_78897_a * 90342903 + this.field_74887_e.field_78895_b * 90342903 ^ this.field_74887_e.field_78896_c);
    }

    public MinotaurMazeComponent(TFFeature feature, int index, int x, int y, int z, int level) {
        this(feature, index, x, y, z, 11, 11, level);
    }

    @Override
    protected void func_143011_b(CompoundNBT tagCompound) {
        super.func_143011_b(tagCompound);
        tagCompound.func_74768_a("mazeLevel", this.level);
        tagCompound.func_74783_a("roomCoords", this.rcoords);
    }

    protected MazeRoomComponent makeRoom(Random random, int i, int dx, int dz) {
        int worldX = this.field_74887_e.field_78897_a + dx * 5 - 4;
        int worldY = this.field_74887_e.field_78895_b;
        int worldZ = this.field_74887_e.field_78896_c + dz * 5 - 4;
        MazeRoomComponent room = i == 0 ? new MazeRoomComponent(MinotaurMazePieces.TFMMR, this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : (i == 1 ? (this.level == 1 ? new MazeRoomExitComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeRoomBossComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 2 || i == 3 ? (this.level == 1 ? new MazeRoomCollapseComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeMushRoomComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 4 ? (this.level == 1 ? new MazeRoomFountainComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeRoomVaultComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : new MazeRoomSpawnerChestsComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ))));
        return room;
    }

    protected void decorateDeadEndsCorridors(Random random, List<StructurePiece> list) {
        for (int x = 0; x < this.maze.width; ++x) {
            for (int z = 0; z < this.maze.depth; ++z) {
                TFStructureComponentOld component = null;
                if (!this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.EAST);
                }
                if (this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.WEST);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && !this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.SOUTH);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.NORTH);
                }
                if (!this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x - 1, z, x - 1, z - 1) && this.maze.isWall(x - 1, z, x - 1, z + 1) && this.maze.isWall(x + 1, z, x + 1, z - 1) && this.maze.isWall(x + 1, z, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, Direction.WEST);
                }
                if (!this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z - 1, x - 1, z - 1) && this.maze.isWall(x, z - 1, x + 1, z - 1) && this.maze.isWall(x, z + 1, x - 1, z + 1) && this.maze.isWall(x, z + 1, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, Direction.SOUTH);
                }
                if (component == null) continue;
                list.add(component);
                component.func_74861_a(this, list, random);
            }
        }
    }

    protected MazeDeadEndComponent makeDeadEnd(Random random, int dx, int dz, Direction rotation) {
        int worldX = this.field_74887_e.field_78897_a + dx * 5 + 1;
        int worldY = this.field_74887_e.field_78895_b;
        int worldZ = this.field_74887_e.field_78896_c + dz * 5 + 1;
        int decorationType = random.nextInt(8);
        switch (decorationType) {
            default: {
                return new MazeDeadEndComponent(MinotaurMazePieces.TFMMDE, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 1: {
                return new MazeDeadEndChestComponent(MinotaurMazePieces.TFMMDEC, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 2: {
                return random.nextBoolean() ? new MazeDeadEndTripwireChestComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation) : new MazeDeadEndTrappedChestComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 3: {
                return new MazeDeadEndTorchesComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 4: {
                return new MazeDeadEndFountainComponent(MinotaurMazePieces.TFMMDEF, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 5: {
                return new MazeDeadEndFountainLavaComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 6: {
                return new MazeDeadEndPaintingComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 7: 
        }
        return this.level == 1 ? new MazeDeadEndRootsComponent(MinotaurMazePieces.TFMMDER, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation) : new MazeDeadEndShroomsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
    }

    protected MazeCorridorComponent makeCorridor(Random random, int dx, int dz, Direction rotation) {
        int worldX = this.field_74887_e.field_78897_a + dx * 5 + 1;
        int worldY = this.field_74887_e.field_78895_b;
        int worldZ = this.field_74887_e.field_78896_c + dz * 5 + 1;
        int decorationType = random.nextInt(5);
        switch (decorationType) {
            default: {
                return null;
            }
            case 1: {
                return new MazeCorridorComponent(MinotaurMazePieces.TFMMC, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 2: {
                return new MazeCorridorIronFenceComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 3: {
                return null;
            }
            case 4: 
        }
        return this.level == 1 ? new MazeCorridorRootsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation) : new MazeCorridorShroomsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
    }

    public void func_74861_a(StructurePiece structurecomponent, List<StructurePiece> list, Random random) {
        super.func_74861_a(structurecomponent, list, random);
        if (this.level == 1) {
            int centerX = this.field_74887_e.field_78897_a + (this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a) / 2;
            int centerZ = this.field_74887_e.field_78896_c + (this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c) / 2;
            MinotaurMazeComponent maze = new MinotaurMazeComponent(this.getFeatureType(), 1, centerX, this.field_74887_e.field_78895_b - 10, centerZ, this.rcoords[2], this.rcoords[3], 2);
            list.add(maze);
            maze.func_74861_a(this, list, random);
        }
        for (int i = 0; i < this.rcoords.length / 2; ++i) {
            int dx = this.rcoords[i * 2];
            int dz = this.rcoords[i * 2 + 1];
            MazeRoomComponent room = this.makeRoom(random, i, dx, dz);
            list.add(room);
            room.func_74861_a(this, list, random);
        }
        this.decorateDeadEndsCorridors(random, list);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState bedrock = Blocks.field_150357_h.func_176223_P();
        BlockState stone = Blocks.field_150348_b.func_176223_P();
        if (this.level == 2) {
            this.func_175804_a(world, sbb, 0, -1, 0, this.getDiameter() + 2, 6, this.getDiameter() + 2, bedrock, AIR, false);
        }
        this.func_74878_a(world, sbb, 1, 1, 1, this.getDiameter(), 4, this.getDiameter());
        boolean onlyReplaceCeiling = this.level == 1 && (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.skylightForest.get() == false;
        this.func_175804_a(world, sbb, 1, 5, 1, this.getDiameter(), 5, this.getDiameter(), ((Block)TFBlocks.maze_stone.get()).func_176223_P(), stone, onlyReplaceCeiling);
        this.func_175804_a(world, sbb, 1, 0, 1, this.getDiameter(), 0, this.getDiameter(), ((Block)TFBlocks.maze_stone_mosaic.get()).func_176223_P(), stone, false);
        this.maze.headBlockState = ((Block)TFBlocks.maze_stone_decorative.get()).func_176223_P();
        this.maze.wallBlockState = ((Block)TFBlocks.maze_stone_brick.get()).func_176223_P();
        this.maze.rootBlockState = ((Block)TFBlocks.maze_stone_decorative.get()).func_176223_P();
        this.maze.pillarBlockState = ((Block)TFBlocks.maze_stone_chiseled.get()).func_176223_P();
        this.maze.wallBlocks = new MazestoneProcessor();
        this.maze.torchRarity = 0.05f;
        this.maze.tall = 2;
        this.maze.head = 1;
        this.maze.roots = 1;
        this.maze.oddBias = 4;
        this.maze.copyToStructure(world, manager, generator, 1, 2, 1, this, sbb);
        return true;
    }

    public int getMazeSize() {
        return 22;
    }

    public int getRadius() {
        return (int)((double)this.getMazeSize() * 2.5);
    }

    public int getDiameter() {
        return this.getMazeSize() * 5;
    }

    protected boolean isNearRoom(int dx, int dz, int[] rcoords, int range) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= range || Math.abs(dz - rz) >= range) continue;
            return true;
        }
        return false;
    }
}

