/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import twilightforest.util.FeatureUtil;
import twilightforest.world.feature.TFGenHollowTree;
import twilightforest.world.feature.config.TFTreeFeatureConfig;

public class TFGenHollowStump
extends TFGenHollowTree {
    public TFGenHollowStump(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(IWorld world, Random rand, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, Set<BlockPos> branch, Set<BlockPos> root, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int radius = rand.nextInt(2) + 2;
        if (!FeatureUtil.isAreaSuitable(world, pos.func_177982_a(-radius, 0, -radius), 2 * radius, 6, 2 * radius)) {
            return false;
        }
        this.buildTrunk(world, rand, pos, trunk, branch, root, radius, 6, mbb, config);
        this.buildBranchRing(world, rand, pos, leaves, branch, radius, 3, 2, 6, 0.75, 3, 5, 3, false, mbb, config);
        this.buildBranchRing(world, rand, pos, leaves, branch, radius, 1, 2, 8, 0.9, 3, 5, 3, false, mbb, config);
        return true;
    }

    @Override
    protected void buildTrunk(IWorld world, Random random, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> branch, Set<BlockPos> root, int diameter, int maxHeight, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int dz;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (int dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    BlockPos dPos = pos.func_177982_a(dx, dy, dz);
                    if (FeatureUtil.hasAirAround(world, dPos)) {
                        if (dist > hollow) {
                            this.setLogBlockState(world, random, dPos, trunk, mbb, config);
                            continue;
                        }
                        this.setLogBlockState(world, random, dPos, branch, mbb, config);
                        continue;
                    }
                    this.setRootsBlockState(world, random, dPos, root, mbb, config);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                int height = 2 + random.nextInt(3) + random.nextInt(2);
                for (int dy = 0; dy <= height; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter || dist <= hollow) continue;
                    this.setLogBlockState(world, random, pos.func_177982_a(dx, dy, dz), trunk, mbb, config);
                }
            }
        }
    }
}

