/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import twilightforest.block.TFBlocks;
import twilightforest.entity.TFEntities;
import twilightforest.loot.TFTreasure;
import twilightforest.util.FeatureUtil;
import twilightforest.world.feature.TFTreeGenerator;
import twilightforest.world.feature.config.TFTreeFeatureConfig;

public class TFGenHollowTree
extends TFTreeGenerator<TFTreeFeatureConfig> {
    private static final int LEAF_DUNGEON_CHANCE = 8;

    public TFGenHollowTree(Codec<TFTreeFeatureConfig> config) {
        super(config);
    }

    @Override
    public boolean generate(IWorld world, Random random, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> leaves, Set<BlockPos> branch, Set<BlockPos> root, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int diameter = random.nextInt(3) + 2;
        int height = random.nextInt(64) + diameter * 4;
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height + diameter > 256) {
            return false;
        }
        int crownRadius = diameter * 4 + 8;
        for (int dx = -crownRadius; dx <= crownRadius; ++dx) {
            for (int dz = -crownRadius; dz <= crownRadius; ++dz) {
                for (int dy = height - crownRadius; dy <= height + crownRadius; ++dy) {
                    Block whatsThere = world.func_180495_p(pos.func_177982_a(dx, dy, dz)).func_177230_c();
                    if (whatsThere == Blocks.field_150350_a || whatsThere instanceof LeavesBlock) continue;
                    return false;
                }
            }
        }
        BlockState state = world.func_180495_p(pos.func_177977_b());
        if (!state.func_177230_c().canSustainPlant(state, (IBlockReader)world, pos.func_177977_b(), Direction.UP, config.getSapling(random, pos))) {
            return false;
        }
        this.buildTrunk(world, random, pos, trunk, branch, root, diameter, height, mbb, config);
        int numFireflies = random.nextInt(6 * diameter) + 5;
        for (int i = 0; i <= numFireflies; ++i) {
            int fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            double fAngle = random.nextDouble();
            this.addFirefly(world, pos, diameter, fHeight, fAngle);
        }
        int numCicadas = random.nextInt(3 * diameter) + 5;
        for (int i = 0; i <= numCicadas; ++i) {
            int fHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            double fAngle = random.nextDouble();
            this.addCicada(world, pos, diameter, fHeight, fAngle);
        }
        this.buildFullCrown(world, random, pos, leaves, branch, diameter, height, mbb, config);
        int numBranches = random.nextInt(3) + 3;
        for (int i = 0; i <= numBranches; ++i) {
            int branchHeight = (int)((double)height * random.nextDouble() * 0.9) + height / 10;
            double branchRotation = random.nextDouble();
            this.makeSmallBranch(world, random, pos, leaves, branch, diameter, branchHeight, 4.0, branchRotation, 0.35, true, mbb, config);
        }
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, 3, 2, 6, 0.75, 3, 5, 3, false, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, 1, 2, 8, 0.9, 3, 5, 3, false, mbb, config);
        return true;
    }

    protected void buildFullCrown(IWorld world, Random random, BlockPos pos, Set<BlockPos> leaves, Set<BlockPos> branch, int diameter, int height, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int crownRadius = diameter * 4 + 4;
        int bvar = diameter + 2;
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height - crownRadius, 0, crownRadius, 0.35, bvar, bvar + 2, 2, true, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height - crownRadius / 2, 0, crownRadius, 0.28, bvar, bvar + 2, 1, true, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height, 0, crownRadius, 0.15, 2, 4, 2, true, mbb, config);
        this.buildBranchRing(world, random, pos, leaves, branch, diameter, height, 0, crownRadius / 2, 0.05, bvar, bvar + 2, 1, true, mbb, config);
    }

    protected void buildBranchRing(IWorld world, Random random, BlockPos pos, Set<BlockPos> leaves, Set<BlockPos> branch, int diameter, int branchHeight, int heightVar, int length, double tilt, int minBranches, int maxBranches, int size, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int numBranches = random.nextInt(maxBranches - minBranches) + minBranches;
        double branchRotation = 1.0 / (double)(numBranches + 1);
        double branchOffset = random.nextDouble();
        for (int i = 0; i <= numBranches; ++i) {
            int dHeight = heightVar > 0 ? branchHeight - heightVar + random.nextInt(2 * heightVar) : branchHeight;
            if (size == 2) {
                this.makeLargeBranch(world, random, pos, leaves, branch, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, mbb, config);
                continue;
            }
            if (size == 1) {
                this.makeMedBranch(world, random, pos, leaves, branch, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, mbb, config);
                continue;
            }
            if (size == 3) {
                this.makeRoot(world, random, pos, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, config);
                continue;
            }
            this.makeSmallBranch(world, random, pos, leaves, branch, diameter, dHeight, length, (double)i * branchRotation + branchOffset, tilt, leafy, mbb, config);
        }
    }

    protected void buildTrunk(IWorld world, Random random, BlockPos pos, Set<BlockPos> trunk, Set<BlockPos> branch, Set<BlockPos> root, int diameter, int height, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        int dy;
        int dz;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    BlockPos dPos = pos.func_177982_a(dx, dy, dz);
                    if (FeatureUtil.hasAirAround(world, dPos)) {
                        if (dist > hollow) {
                            this.setLogBlockState(world, random, dPos, trunk, mbb, config);
                            continue;
                        }
                        this.setBranchBlockState(world, random, dPos, branch, mbb, config);
                        continue;
                    }
                    this.setRootsBlockState(world, random, dPos, root, mbb, config);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (dy = 0; dy <= height; ++dy) {
                    int az;
                    BlockPos dPos = pos.func_177982_a(dx, dy, dz);
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist <= diameter && dist > hollow) {
                        this.setLogBlockState(world, random, dPos, trunk, mbb, config);
                    }
                    if (dist <= hollow) {
                        // empty if block
                    }
                    if (dist != hollow || dx != hollow) continue;
                    world.func_180501_a(dPos, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.field_176278_M, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
        }
    }

    protected void makeMedBranch(IWorld world, Random random, BlockPos pos, Set<BlockPos> leaves, Set<BlockPos> branch, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeMedBranch(world, random, src, leaves, branch, length, angle, tilt, leafy, mbb, config);
    }

    protected void makeMedBranch(IWorld world, Random random, BlockPos src, Set<BlockPos> leaves, Set<BlockPos> branch, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        FeatureUtil.drawBresenhamBranch(this, world, random, src, dest, branch, mbb, config);
        if (leafy) {
            FeatureUtil.drawLeafBlob(world, dest, 2, config.leavesProvider.func_225574_a_(random, dest), leaves);
        }
        int numShoots = random.nextInt(2) + 1;
        double angleInc = 0.8 / (double)numShoots;
        for (int i = 0; i <= numShoots; ++i) {
            double angleVar = angleInc * (double)i - 0.4;
            double outVar = random.nextDouble() * 0.8 + 0.2;
            double tiltVar = random.nextDouble() * 0.75 + 0.15;
            BlockPos bsrc = FeatureUtil.translate(src, length * outVar, angle, tilt);
            double slength = length * 0.4;
            this.makeSmallBranch(world, random, bsrc, leaves, branch, slength, angle + angleVar, tilt * tiltVar, leafy, mbb, config);
        }
    }

    protected void makeSmallBranch(IWorld world, Random random, BlockPos src, Set<BlockPos> leaves, Set<BlockPos> branch, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        FeatureUtil.drawBresenhamBranch(this, world, random, src, dest, branch, mbb, config);
        if (leafy) {
            byte leafRad = (byte)(random.nextInt(2) + 1);
            FeatureUtil.drawLeafBlob(world, dest, leafRad, config.leavesProvider.func_225574_a_(random, dest), leaves);
        }
    }

    protected void makeSmallBranch(IWorld world, Random random, BlockPos pos, Set<BlockPos> leaves, Set<BlockPos> branch, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeSmallBranch(world, random, src, leaves, branch, length, angle, tilt, leafy, mbb, config);
    }

    protected void makeRoot(IWorld world, Random random, BlockPos pos, int diameter, int branchHeight, double length, double angle, double tilt, TFTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        BlockPos[] lineArray = FeatureUtil.getBresenhamArrays(src, dest);
        boolean stillAboveGround = true;
        for (BlockPos coord : lineArray) {
            if (stillAboveGround && FeatureUtil.hasAirAround(world, coord)) {
                world.func_180501_a(coord, config.branchProvider.func_225574_a_(random, coord), 3);
                world.func_180501_a(coord.func_177977_b(), config.branchProvider.func_225574_a_(random, coord.func_177977_b()), 3);
                continue;
            }
            world.func_180501_a(coord, config.rootsProvider.func_225574_a_(random, coord), 3);
            world.func_180501_a(coord.func_177977_b(), config.rootsProvider.func_225574_a_(random, coord.func_177977_b()), 3);
            stillAboveGround = false;
        }
    }

    protected void makeLargeBranch(IWorld world, Random random, BlockPos src, Set<BlockPos> leaves, Set<BlockPos> branch, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        BlockPos dest = FeatureUtil.translate(src, length, angle, tilt);
        FeatureUtil.drawBresenhamBranch(this, world, random, src, dest, branch, mbb, config);
        int reinforcements = random.nextInt(3);
        for (int i = 0; i <= reinforcements; ++i) {
            int vx = (i & 2) == 0 ? 1 : 0;
            int vy = (i & 1) == 0 ? 1 : -1;
            int vz = (i & 2) == 0 ? 0 : 1;
            FeatureUtil.drawBresenhamBranch(this, world, random, src.func_177982_a(vx, vy, vz), dest, branch, mbb, config);
        }
        if (leafy) {
            FeatureUtil.drawLeafBlob(world, dest.func_177984_a(), 3, config.leavesProvider.func_225574_a_(random, dest.func_177984_a()), leaves);
        }
        int numMedBranches = random.nextInt((int)(length / 6.0)) + random.nextInt(2) + 1;
        for (int i = 0; i <= numMedBranches; ++i) {
            double outVar = random.nextDouble() * 0.3 + 0.3;
            double angleVar = random.nextDouble() * 0.225 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = FeatureUtil.translate(src, length * outVar, angle, tilt);
            this.makeMedBranch(world, random, bsrc, leaves, branch, length * 0.6, angle + angleVar, tilt, leafy, mbb, config);
        }
        int numSmallBranches = random.nextInt(2) + 1;
        for (int i = 0; i <= numSmallBranches; ++i) {
            double outVar = random.nextDouble() * 0.25 + 0.25;
            double angleVar = random.nextDouble() * 0.25 * ((i & 1) == 0 ? 1.0 : -1.0);
            BlockPos bsrc = FeatureUtil.translate(src, length * outVar, angle, tilt);
            this.makeSmallBranch(world, random, bsrc, leaves, branch, Math.max(length * 0.3, 2.0), angle + angleVar, tilt, leafy, mbb, config);
        }
        if (random.nextInt(8) == 0) {
            this.makeLeafDungeon(world, random, dest.func_177984_a(), leaves, config);
        }
    }

    private void makeLeafDungeon(IWorld world, Random random, BlockPos pos, Set<BlockPos> leaves, TFTreeFeatureConfig config) {
        FeatureUtil.drawLeafBlob(world, pos, 4, config.leavesProvider.func_225574_a_(random, pos), leaves);
        FeatureUtil.drawBlob(world, pos, 3, config.branchProvider.func_225574_a_(random, pos));
        FeatureUtil.drawBlob(world, pos, 2, Blocks.field_150350_a.func_176223_P());
        world.func_180501_a(pos.func_177984_a(), Blocks.field_150474_ac.func_176223_P(), 18);
        MobSpawnerTileEntity ms = (MobSpawnerTileEntity)world.func_175625_s(pos.func_177984_a());
        if (ms != null) {
            ms.func_145881_a().func_200876_a(TFEntities.swarm_spider);
        }
        this.makeLeafDungeonChest(world, random, pos);
    }

    private void makeLeafDungeonChest(IWorld world, Random random, BlockPos pos) {
        pos = pos.func_177972_a(Direction.Plane.HORIZONTAL.func_179518_a(random));
        TFTreasure.tree_cache.generateChest(world, pos.func_177977_b(), Direction.NORTH, false);
    }

    protected void makeLargeBranch(IWorld world, Random random, BlockPos pos, Set<BlockPos> leaves, Set<BlockPos> branch, int diameter, int branchHeight, double length, double angle, double tilt, boolean leafy, MutableBoundingBox mbb, TFTreeFeatureConfig config) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(branchHeight), diameter, angle, 0.5);
        this.makeLargeBranch(world, random, src, leaves, branch, length, angle, tilt, leafy, mbb, config);
    }

    protected void addFirefly(IWorld world, BlockPos pos, int diameter, int fHeight, double fAngle) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(fHeight), diameter + 1, fAngle, 0.5);
        Direction facing = Direction.EAST;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = Direction.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = Direction.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = Direction.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = Direction.WEST;
        }
        if (((BlockState)((Block)TFBlocks.firefly.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)facing)).func_196955_c((IWorldReader)world, src)) {
            world.func_180501_a(src, (BlockState)((Block)TFBlocks.firefly.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)facing), 3);
        }
    }

    protected void addCicada(IWorld world, BlockPos pos, int diameter, int fHeight, double fAngle) {
        BlockPos src = FeatureUtil.translate(pos.func_177981_b(fHeight), diameter + 1, fAngle, 0.5);
        Direction facing = Direction.EAST;
        if ((fAngle %= 1.0) > 0.875 || fAngle <= 0.125) {
            facing = Direction.SOUTH;
        } else if (fAngle > 0.125 && fAngle <= 0.375) {
            facing = Direction.EAST;
        } else if (fAngle > 0.375 && fAngle <= 0.625) {
            facing = Direction.NORTH;
        } else if (fAngle > 0.625 && fAngle <= 0.875) {
            facing = Direction.WEST;
        }
        if (((BlockState)((Block)TFBlocks.cicada.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)facing)).func_196955_c((IWorldReader)world, src)) {
            world.func_180501_a(src, (BlockState)((Block)TFBlocks.cicada.get()).func_176223_P().func_206870_a((Property)DirectionalBlock.field_176387_N, (Comparable)facing), 3);
        }
    }
}

