/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.sync.ContraptionFluidPacket;
import com.simibubi.create.content.contraptions.fluids.tank.CreativeFluidTankTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.PacketDistributor;

public class MountedFluidStorage {
    SmartFluidTank tank;
    private boolean valid;
    private TileEntity te;
    private int packetCooldown = 0;
    private boolean sendPacket = false;

    public static boolean canUseAsStorage(TileEntity te) {
        if (te instanceof FluidTankTileEntity) {
            return ((FluidTankTileEntity)te).isController();
        }
        return false;
    }

    public MountedFluidStorage(TileEntity te) {
        this.assignTileEntity(te);
    }

    public void assignTileEntity(TileEntity te) {
        this.te = te;
        this.tank = this.createMountedTank(te);
    }

    private SmartFluidTank createMountedTank(TileEntity te) {
        if (te instanceof CreativeFluidTankTileEntity) {
            return new CreativeFluidTankTileEntity.CreativeSmartFluidTank(((FluidTankTileEntity)te).getTotalTankSize() * FluidTankTileEntity.getCapacityMultiplier(), $ -> {});
        }
        if (te instanceof FluidTankTileEntity) {
            return new SmartFluidTank(((FluidTankTileEntity)te).getTotalTankSize() * FluidTankTileEntity.getCapacityMultiplier(), this::onFluidStackChanged);
        }
        return null;
    }

    public void tick(Entity entity, BlockPos pos, boolean isRemote) {
        if (!isRemote) {
            if (this.packetCooldown > 0) {
                --this.packetCooldown;
            } else if (this.sendPacket) {
                this.sendPacket = false;
                AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new ContraptionFluidPacket(entity.func_145782_y(), pos, this.tank.getFluid()));
                this.packetCooldown = 8;
            }
            return;
        }
        if (!(this.te instanceof FluidTankTileEntity)) {
            return;
        }
        FluidTankTileEntity tank = (FluidTankTileEntity)this.te;
        tank.getFluidLevel().tick();
    }

    public void updateFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
        if (!(this.te instanceof FluidTankTileEntity)) {
            return;
        }
        float fillState = (float)this.tank.getFluidAmount() / (float)this.tank.getCapacity();
        FluidTankTileEntity tank = (FluidTankTileEntity)this.te;
        if (tank.getFluidLevel() == null) {
            tank.setFluidLevel(new InterpolatedChasingValue().start(fillState));
        }
        tank.getFluidLevel().target(fillState);
        IFluidTank tankInventory = tank.getTankInventory();
        if (tankInventory instanceof SmartFluidTank) {
            ((SmartFluidTank)tankInventory).setFluid(fluid);
        }
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.te == null) {
            return;
        }
        IFluidHandler teHandler = (IFluidHandler)this.te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        if (!(teHandler instanceof SmartFluidTank)) {
            return;
        }
        SmartFluidTank smartTank = (SmartFluidTank)teHandler;
        this.tank.setFluid(smartTank.getFluid());
        this.sendPacket = false;
        this.valid = true;
    }

    private void onFluidStackChanged(FluidStack fs) {
        this.sendPacket = true;
    }

    public void addStorageToWorld(TileEntity te) {
        if (this.tank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
            return;
        }
        LazyOptional capability = te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        IFluidHandler teHandler = (IFluidHandler)capability.orElse(null);
        if (!(teHandler instanceof SmartFluidTank)) {
            return;
        }
        SmartFluidTank inv = (SmartFluidTank)teHandler;
        inv.setFluid(this.tank.getFluid().copy());
    }

    public IFluidHandler getFluidHandler() {
        return this.tank;
    }

    public CompoundNBT serialize() {
        if (!this.valid) {
            return null;
        }
        CompoundNBT tag = this.tank.writeToNBT(new CompoundNBT());
        tag.func_74768_a("Capacity", this.tank.getCapacity());
        if (this.tank instanceof CreativeFluidTankTileEntity.CreativeSmartFluidTank) {
            NBTHelper.putMarker(tag, "Bottomless");
            tag.func_218657_a("ProvidedStack", (INBT)this.tank.getFluid().writeToNBT(new CompoundNBT()));
        }
        return tag;
    }

    public static MountedFluidStorage deserialize(CompoundNBT nbt) {
        MountedFluidStorage storage = new MountedFluidStorage(null);
        if (nbt == null) {
            return storage;
        }
        int capacity = nbt.func_74762_e("Capacity");
        storage.tank = new SmartFluidTank(capacity, storage::onFluidStackChanged);
        storage.valid = true;
        if (nbt.func_74764_b("Bottomless")) {
            FluidStack providedStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt.func_74775_l("ProvidedStack"));
            CreativeFluidTankTileEntity.CreativeSmartFluidTank creativeSmartFluidTank = new CreativeFluidTankTileEntity.CreativeSmartFluidTank(capacity, $ -> {});
            creativeSmartFluidTank.setContainedFluid(providedStack);
            storage.tank = creativeSmartFluidTank;
            return storage;
        }
        storage.tank.readFromNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }
}

