/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.mutable.MutableInt;

public class ItemHelper {
    public static void dropContents(World world, BlockPos pos, IItemHandler inv) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inv.getStackInSlot(slot));
        }
    }

    public static List<ItemStack> multipliedOutput(ItemStack in, ItemStack out) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ItemStack result = out.func_77946_l();
        result.func_190920_e(in.func_190916_E() * out.func_190916_E());
        while (result.func_190916_E() > result.func_77976_d()) {
            stacks.add(result.func_77979_a(result.func_77976_d()));
        }
        stacks.add(result);
        return stacks;
    }

    public static void addToList(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack s : stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)s)) continue;
            int transferred = Math.min(s.func_77976_d() - s.func_190916_E(), stack.func_190916_E());
            s.func_190917_f(transferred);
            stack.func_190918_g(transferred);
        }
        if (stack.func_190916_E() > 0) {
            stacks.add(stack);
        }
    }

    public static boolean isSameInventory(IItemHandler h1, IItemHandler h2) {
        if (h1 == null || h2 == null) {
            return false;
        }
        if (h1.getSlots() != h2.getSlots()) {
            return false;
        }
        for (int slot = 0; slot < h1.getSlots(); ++slot) {
            if (h1.getStackInSlot(slot) == h2.getStackInSlot(slot)) continue;
            return false;
        }
        return true;
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        }
        int i = 0;
        float f = 0.0f;
        int totalSlots = inv.getSlots();
        for (int j = 0; j < inv.getSlots(); ++j) {
            int slotLimit = inv.getSlotLimit(j);
            if (slotLimit == 0) {
                --totalSlots;
                continue;
            }
            ItemStack itemstack = inv.getStackInSlot(j);
            if (itemstack.func_190926_b()) continue;
            f += (float)itemstack.func_190916_E() / (float)Math.min(slotLimit, itemstack.func_77976_d());
            ++i;
        }
        if (totalSlots == 0) {
            return 0;
        }
        return MathHelper.func_76141_d((float)((f /= (float)totalSlots) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public static List<Pair<Ingredient, MutableInt>> condenseIngredients(NonNullList<Ingredient> recipeIngredients) {
        ArrayList<Pair<Ingredient, MutableInt>> actualIngredients = new ArrayList<Pair<Ingredient, MutableInt>>();
        block0: for (Ingredient igd : recipeIngredients) {
            block1: for (Pair pair : actualIngredients) {
                ItemStack[] stacks2;
                ItemStack[] stacks1 = ((Ingredient)pair.getFirst()).func_193365_a();
                if (stacks1.length != (stacks2 = igd.func_193365_a()).length) continue;
                for (int i = 0; i <= stacks1.length; ++i) {
                    if (i == stacks1.length) {
                        ((MutableInt)pair.getSecond()).increment();
                        continue block0;
                    }
                    if (!ItemStack.func_77989_b((ItemStack)stacks1[i], (ItemStack)stacks2[i])) continue block1;
                }
            }
            actualIngredients.add(Pair.of(igd, new MutableInt(1)));
        }
        return actualIngredients;
    }

    public static boolean matchIngredients(Ingredient i1, Ingredient i2) {
        ItemStack[] stacks2;
        ItemStack[] stacks1 = i1.func_193365_a();
        if (stacks1.length == (stacks2 = i2.func_193365_a()).length) {
            for (int i = 0; i < stacks1.length; ++i) {
                if (ItemStack.func_179545_c((ItemStack)stacks1[i], (ItemStack)stacks2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, boolean simulate) {
        return ItemHelper.extract(inv, test, ExtractionCountMode.UPTO, (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get(), simulate);
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, int exactAmount, boolean simulate) {
        return ItemHelper.extract(inv, test, ExtractionCountMode.EXACTLY, exactAmount, simulate);
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, ExtractionCountMode mode, int amount, boolean simulate) {
        boolean amountRequired;
        ItemStack extracting = ItemStack.field_190927_a;
        boolean checkHasEnoughItems = amountRequired = mode == ExtractionCountMode.EXACTLY;
        boolean hasEnoughItems = !checkHasEnoughItems;
        boolean potentialOtherMatch = false;
        int maxExtractionCount = amount;
        block0: while (true) {
            extracting = ItemStack.field_190927_a;
            for (int slot = 0; slot < inv.getSlots(); ++slot) {
                int amountToExtractFromThisSlot = Math.min(maxExtractionCount - extracting.func_190916_E(), inv.getStackInSlot(slot).func_77976_d());
                ItemStack stack = inv.extractItem(slot, amountToExtractFromThisSlot, true);
                if (stack.func_190926_b() || !test.test(stack)) continue;
                if (!extracting.func_190926_b() && !ItemHelper.canItemStackAmountsStack(stack, extracting)) {
                    potentialOtherMatch = true;
                    continue;
                }
                if (extracting.func_190926_b()) {
                    extracting = stack.func_77946_l();
                } else {
                    extracting.func_190917_f(stack.func_190916_E());
                }
                if (!simulate && hasEnoughItems) {
                    inv.extractItem(slot, stack.func_190916_E(), false);
                }
                if (extracting.func_190916_E() < maxExtractionCount) continue;
                if (!checkHasEnoughItems) break block0;
                hasEnoughItems = true;
                checkHasEnoughItems = false;
                continue block0;
            }
            if (!extracting.func_190926_b() && !hasEnoughItems && potentialOtherMatch) {
                ItemStack blackListed = extracting.func_77946_l();
                test = test.and(i -> !ItemHandlerHelper.canItemStacksStack((ItemStack)i, (ItemStack)blackListed));
                continue;
            }
            if (!checkHasEnoughItems) break;
            checkHasEnoughItems = false;
        }
        if (amountRequired && extracting.func_190916_E() < amount) {
            return ItemStack.field_190927_a;
        }
        return extracting;
    }

    public static ItemStack extract(IItemHandler inv, Predicate<ItemStack> test, Function<ItemStack, Integer> amountFunction, boolean simulate) {
        ItemStack extracting = ItemStack.field_190927_a;
        int maxExtractionCount = (Integer)AllConfigs.SERVER.logistics.defaultExtractionLimit.get();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack;
            if (extracting.func_190926_b()) {
                int maxExtractionCountForItem;
                ItemStack stackInSlot = inv.getStackInSlot(slot);
                if (stackInSlot.func_190926_b() || (maxExtractionCountForItem = amountFunction.apply(stackInSlot).intValue()) == 0) continue;
                maxExtractionCount = Math.min(maxExtractionCount, maxExtractionCountForItem);
            }
            if (!test.test(stack = inv.extractItem(slot, maxExtractionCount - extracting.func_190916_E(), true)) || !extracting.func_190926_b() && !ItemHelper.canItemStackAmountsStack(stack, extracting)) continue;
            if (extracting.func_190926_b()) {
                extracting = stack.func_77946_l();
            } else {
                extracting.func_190917_f(stack.func_190916_E());
            }
            if (!simulate) {
                inv.extractItem(slot, stack.func_190916_E(), false);
            }
            if (extracting.func_190916_E() >= maxExtractionCount) break;
        }
        return extracting;
    }

    public static boolean canItemStackAmountsStack(ItemStack a, ItemStack b) {
        return ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b) && a.func_190916_E() + b.func_190916_E() <= a.func_77976_d();
    }

    public static ItemStack findFirstMatch(IItemHandler inv, Predicate<ItemStack> test) {
        int slot = ItemHelper.findFirstMatchingSlotIndex(inv, test);
        if (slot == -1) {
            return ItemStack.field_190927_a;
        }
        return inv.getStackInSlot(slot);
    }

    public static int findFirstMatchingSlotIndex(IItemHandler inv, Predicate<ItemStack> test) {
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack toTest = inv.getStackInSlot(slot);
            if (!test.test(toTest)) continue;
            return slot;
        }
        return -1;
    }

    public static enum ExtractionCountMode {
        EXACTLY,
        UPTO;

    }
}

