/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.simibubi.create.foundation.ponder.PonderWorld;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.vector.Matrix4f;

public class PonderWorldParticles {
    private final Map<IParticleRenderType, Queue<Particle>> byType = Maps.newIdentityHashMap();
    private final Queue<Particle> queue = Queues.newArrayDeque();
    PonderWorld world;

    public PonderWorldParticles(PonderWorld world) {
        this.world = world;
    }

    public void addParticle(Particle p) {
        this.queue.add(p);
    }

    public void tick() {
        Particle particle;
        this.byType.forEach((p_228347_1_, p_228347_2_) -> this.tickParticleList((Collection<Particle>)p_228347_2_));
        if (this.queue.isEmpty()) {
            return;
        }
        while ((particle = this.queue.poll()) != null) {
            this.byType.computeIfAbsent(particle.func_217558_b(), $ -> EvictingQueue.create((int)16384)).add(particle);
        }
    }

    private void tickParticleList(Collection<Particle> p_187240_1_) {
        if (p_187240_1_.isEmpty()) {
            return;
        }
        Iterator<Particle> iterator = p_187240_1_.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            particle.func_189213_a();
            if (particle.func_187113_k()) continue;
            iterator.remove();
        }
    }

    public void renderParticles(MatrixStack ms, IRenderTypeBuffer buffer, ActiveRenderInfo renderInfo, float pt) {
        Minecraft mc = Minecraft.func_71410_x();
        LightTexture lightTexture = mc.field_71460_t.func_228384_l_();
        lightTexture.func_205109_c();
        Runnable enable = () -> {
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.enableFog();
        };
        RenderSystem.pushMatrix();
        RenderSystem.multMatrix((Matrix4f)ms.func_227866_c_().func_227870_a_());
        for (IParticleRenderType iparticlerendertype : this.byType.keySet()) {
            if (iparticlerendertype == IParticleRenderType.field_217606_f) continue;
            enable.run();
            Iterable iterable = this.byType.get(iparticlerendertype);
            if (iterable == null) continue;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            iparticlerendertype.func_217600_a(bufferbuilder, mc.field_71446_o);
            for (Particle particle : iterable) {
                particle.func_225606_a_((IVertexBuilder)bufferbuilder, renderInfo, pt);
            }
            iparticlerendertype.func_217599_a(tessellator);
        }
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        lightTexture.func_205108_b();
        RenderSystem.disableFog();
    }

    public void clearEffects() {
        this.byType.clear();
    }
}

