/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.ClickListHelper;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.library.TrackSmoothing;
import cam72cam.immersiverailroading.net.ItemRailUpdatePacket;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.gui.helpers.ItemPickerGUI;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.CheckBox;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.gui.screen.Slider;
import cam72cam.mod.gui.screen.TextField;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.render.OpenGL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.lwjgl.opengl.GL11;

public class TrackGui
implements IScreen {
    private TileRailPreview te;
    private Button typeButton;
    private TextField lengthInput;
    private Slider degreesSlider;
    private CheckBox isPreviewCB;
    private CheckBox isGradeCrossingCB;
    private Button gaugeButton;
    private Button trackButton;
    private Button posTypeButton;
    private Button smoothingButton;
    private Button directionButton;
    private Button bedTypeButton;
    private Button bedFillButton;
    private int length;
    private float degrees;
    private Gauge gauge;
    private String track;
    private boolean isPreview;
    private boolean isGradeCrossing;
    private TrackItems type;
    private TrackPositionType posType;
    private TrackSmoothing smoothing;
    private TrackDirection direction;
    private ItemStack bed;
    private ItemStack bedFill;
    List<ItemStack> oreDict;
    private final Predicate<String> integerFilter = inputString -> {
        int val;
        if (inputString == null || inputString.length() == 0) {
            return true;
        }
        try {
            val = Integer.parseInt(inputString);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return val > 0 && val <= 1000;
    };

    public TrackGui() {
        this(MinecraftClient.getPlayer().getHeldItem(Player.Hand.PRIMARY));
    }

    public TrackGui(TileRailPreview te) {
        this(te.getItem());
        this.te = te;
    }

    private TrackGui(ItemStack stack) {
        stack = stack.copy();
        RailSettings settings = RailSettings.from(stack);
        this.length = settings.length;
        this.degrees = settings.degrees;
        this.type = settings.type;
        this.gauge = settings.gauge;
        this.track = settings.track;
        this.posType = settings.posType;
        this.smoothing = settings.smoothing;
        this.direction = settings.direction;
        this.isPreview = settings.isPreview;
        this.isGradeCrossing = settings.isGradeCrossing;
        this.bed = settings.railBed;
        this.bedFill = settings.railBedFill;
        this.oreDict = new ArrayList<ItemStack>();
        this.oreDict.add(ItemStack.EMPTY);
        this.oreDict.addAll(IRFuzzy.IR_RAIL_BED.enumerate());
    }

    public static String getStackName(ItemStack stack) {
        if (stack.isEmpty()) {
            return GuiText.NONE.toString();
        }
        return stack.getDisplayName();
    }

    public void init(final IScreenBuilder screen) {
        this.trackButton = new Button(screen, -100, -24, GuiText.SELECTOR_TRACK.toString(DefinitionManager.getTrack((String)this.track).name)){

            public void onClick(Player.Hand hand) {
                TrackGui.this.track = ClickListHelper.next(DefinitionManager.getTrackIDs(), TrackGui.this.track, hand);
                TrackGui.this.trackButton.setText(GuiText.SELECTOR_TRACK.toString(DefinitionManager.getTrack((String)((TrackGui)TrackGui.this).track).name));
            }
        };
        this.typeButton = new Button(screen, -100, -3, GuiText.SELECTOR_TYPE.toString(new Object[]{this.type})){

            public void onClick(Player.Hand hand) {
                TrackGui.this.type = ClickListHelper.next(TrackGui.this.type, hand);
                TrackGui.this.typeButton.setText(GuiText.SELECTOR_TYPE.toString(new Object[]{TrackGui.this.type}));
                TrackGui.this.degreesSlider.setVisible(TrackGui.this.type == TrackItems.SWITCH || TrackGui.this.type == TrackItems.TURN);
                TrackGui.this.smoothingButton.setVisible(TrackGui.this.type == TrackItems.CUSTOM || TrackGui.this.type == TrackItems.SLOPE || TrackGui.this.type == TrackItems.TURN);
            }
        };
        this.lengthInput = new TextField(screen, -100, 20, 200, 20);
        this.lengthInput.setText("" + this.length);
        this.lengthInput.setValidator(this.integerFilter);
        this.lengthInput.setFocused(true);
        this.degreesSlider = new Slider(screen, -75, 43, "", 1.0, Config.ConfigBalance.AnglePlacementSegmentation, this.degrees / 90.0f * (float)Config.ConfigBalance.AnglePlacementSegmentation, false){

            public void onSlider() {
                TrackGui.this.degreesSlider.setText(GuiText.SELECTOR_QUARTERS.toString((double)this.getValueInt() * (90.0 / (double)Config.ConfigBalance.AnglePlacementSegmentation)));
            }
        };
        this.degreesSlider.onSlider();
        this.degreesSlider.setVisible(this.type == TrackItems.SWITCH || this.type == TrackItems.TURN);
        this.bedTypeButton = new Button(screen, -100, 64, GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(this.bed))){

            public void onClick(Player.Hand hand) {
                ItemPickerGUI ip = new ItemPickerGUI(TrackGui.this.oreDict, bed -> {
                    if (bed != null) {
                        TrackGui.this.bed = bed;
                        TrackGui.this.bedTypeButton.setText(GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(bed)));
                    }
                    screen.show();
                });
                ip.choosenItem = TrackGui.this.bed;
                ip.show();
            }
        };
        this.bedFillButton = new Button(screen, -100, 86, GuiText.SELECTOR_RAIL_BED_FILL.toString(TrackGui.getStackName(this.bedFill))){

            public void onClick(Player.Hand hand) {
                ItemPickerGUI ip = new ItemPickerGUI(TrackGui.this.oreDict, bed -> {
                    if (bed != null) {
                        TrackGui.this.bedFill = bed;
                        TrackGui.this.bedFillButton.setText(GuiText.SELECTOR_RAIL_BED_FILL.toString(TrackGui.getStackName(TrackGui.this.bedFill)));
                    }
                    screen.show();
                });
                ip.choosenItem = TrackGui.this.bedFill;
                ip.show();
            }
        };
        this.posTypeButton = new Button(screen, -100, 108, GuiText.SELECTOR_POSITION.toString(new Object[]{this.posType})){

            public void onClick(Player.Hand hand) {
                TrackGui.this.posType = ClickListHelper.next(TrackGui.this.posType, hand);
                TrackGui.this.posTypeButton.setText(GuiText.SELECTOR_POSITION.toString(new Object[]{TrackGui.this.posType}));
            }
        };
        this.smoothingButton = new Button(screen, -100, 130, GuiText.SELECTOR_SMOOTHING.toString(new Object[]{this.smoothing})){

            public void onClick(Player.Hand hand) {
                TrackGui.this.smoothing = ClickListHelper.next(TrackGui.this.smoothing, hand);
                TrackGui.this.smoothingButton.setText(GuiText.SELECTOR_SMOOTHING.toString(new Object[]{TrackGui.this.smoothing}));
            }
        };
        this.smoothingButton.setVisible(this.type == TrackItems.CUSTOM || this.type == TrackItems.SLOPE || this.type == TrackItems.TURN);
        this.directionButton = new Button(screen, -100, 152, GuiText.SELECTOR_DIRECTION.toString(new Object[]{this.direction})){

            public void onClick(Player.Hand hand) {
                TrackGui.this.direction = ClickListHelper.next(TrackGui.this.direction, hand);
                TrackGui.this.directionButton.setText(GuiText.SELECTOR_DIRECTION.toString(new Object[]{TrackGui.this.direction}));
            }
        };
        this.gaugeButton = new Button(screen, -100, 174, GuiText.SELECTOR_GAUGE.toString(this.gauge)){

            public void onClick(Player.Hand hand) {
                TrackGui.this.gauge = ClickListHelper.next(Gauge.values(), TrackGui.this.gauge, hand);
                TrackGui.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(TrackGui.this.gauge));
            }
        };
        this.isPreviewCB = new CheckBox(screen, -75, 200, GuiText.SELECTOR_PLACE_BLUEPRINT.toString(), this.isPreview){

            public void onClick(Player.Hand hand) {
                TrackGui.this.isPreview = TrackGui.this.isPreviewCB.isChecked();
            }
        };
        this.isGradeCrossingCB = new CheckBox(screen, -75, 222, GuiText.SELECTOR_GRADE_CROSSING.toString(), this.isGradeCrossing){

            public void onClick(Player.Hand hand) {
                TrackGui.this.isGradeCrossing = TrackGui.this.isGradeCrossingCB.isChecked();
            }
        };
    }

    public void onEnterKey(IScreenBuilder builder) {
        builder.close();
    }

    public void onClose() {
        if (!this.lengthInput.getText().isEmpty()) {
            RailSettings settings = new RailSettings(this.gauge, this.track, this.type, Integer.parseInt(this.lengthInput.getText()), (float)this.degreesSlider.getValueInt() * (90.0f / (float)Config.ConfigBalance.AnglePlacementSegmentation), this.posType, this.smoothing, this.direction, this.bed, this.bedFill, this.isPreview, this.isGradeCrossing);
            if (this.te != null) {
                new ItemRailUpdatePacket(this.te.getPos(), settings).sendToServer();
            } else {
                new ItemRailUpdatePacket(settings).sendToServer();
            }
        }
    }

    public void draw(IScreenBuilder builder) {
        if (this.lengthInput.getText().isEmpty()) {
            return;
        }
        int scale = 8;
        RailSettings settings = new RailSettings(this.gauge, this.track, this.type, Integer.parseInt(this.lengthInput.getText()), (float)this.degreesSlider.getValueInt() * (90.0f / (float)Config.ConfigBalance.AnglePlacementSegmentation), this.posType, this.smoothing, this.direction, this.bed, this.bedFill, this.isPreview, this.isGradeCrossing);
        ItemStack stack = new ItemStack((CustomItem)IRItems.ITEM_TRACK_BLUEPRINT, 1);
        settings.write(stack);
        try (OpenGL.With matrix = OpenGL.matrix();){
            GL11.glTranslated((double)(GUIHelpers.getScreenWidth() / 2 + builder.getWidth() / 4), (double)(builder.getHeight() / 4), (double)0.0);
            GL11.glScaled((double)scale, (double)scale, (double)1.0);
            GUIHelpers.drawItem((ItemStack)stack, (int)0, (int)0);
        }
        matrix = OpenGL.matrix();
        var6_6 = null;
        try {
            GL11.glTranslated((double)(GUIHelpers.getScreenWidth() / 2 - builder.getWidth() / 4), (double)(builder.getHeight() / 4), (double)0.0);
            GL11.glScaled((double)(-scale), (double)scale, (double)1.0);
            GUIHelpers.drawItem((ItemStack)stack, (int)0, (int)0);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (matrix != null) {
                if (var6_6 != null) {
                    try {
                        matrix.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    matrix.close();
                }
            }
        }
    }
}

