/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import java.util.stream.Collectors;
import org.lwjgl.opengl.GL11;

public class ConnectingRodValveGear
implements ValveGear {
    protected final WheelSet wheels;
    protected Vec3d centerOfWheels;
    protected final ModelComponent connectingRod;
    protected float angleOffset;

    public static ConnectingRodValveGear get(WheelSet wheels, ComponentProvider provider, String pos, float angleOffset) {
        ModelComponent connectingRod = provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos);
        return connectingRod != null ? new ConnectingRodValveGear(wheels, connectingRod, angleOffset) : null;
    }

    public ConnectingRodValveGear(WheelSet wheels, ModelComponent connectingRod, float angleOffset) {
        this.wheels = wheels;
        this.connectingRod = connectingRod;
        this.angleOffset = angleOffset;
        this.centerOfWheels = ModelComponent.center(wheels.wheels.stream().map(x -> x.wheel).collect(Collectors.toList()));
    }

    @Override
    public float angle(double distance) {
        return this.wheels.angle(distance) + this.angleOffset;
    }

    @Override
    public void render(double distance, float throttle, ComponentRenderer draw) {
        float wheelAngle = this.angle(distance);
        Vec3d connRodPos = this.connectingRod.center;
        double connRodRadius = connRodPos.x - this.centerOfWheels.x;
        Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, wheelAngle);
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)(-connRodRadius), (double)0.0, (double)0.0);
            GL11.glTranslated((double)connRodMovment.x, (double)connRodMovment.z, (double)0.0);
            matrix.render(this.connectingRod);
        }
    }

    @Override
    public void effects(EntityMoveableRollingStock stock, float throttle) {
    }

    @Override
    public boolean isEndStroke(EntityMoveableRollingStock stock, float throttle) {
        return false;
    }
}

