/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.model.ComponentRenderer;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class Wheel {
    protected final ModelComponent wheel;

    protected Wheel(ModelComponent wheel) {
        this.wheel = wheel;
    }

    public double diameter() {
        return this.wheel.height();
    }

    public float angle(double distance) {
        double circumference = this.diameter() * 3.1415927410125732;
        double relDist = distance % circumference;
        return (float)(360.0 * relDist / circumference);
    }

    public void render(float angle, ComponentRenderer draw) {
        Vec3d wheelPos = this.wheel.center;
        try (ComponentRenderer matrix = draw.push();){
            GL11.glTranslated((double)wheelPos.x, (double)wheelPos.y, (double)wheelPos.z);
            GL11.glRotated((double)angle, (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-wheelPos.x), (double)(-wheelPos.y), (double)(-wheelPos.z));
            matrix.render(this.wheel);
        }
    }
}

