/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.impl.ImmersiveConnectableTileEntity;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GasGeneratorTileEntity
extends ImmersiveConnectableTileEntity
implements ITickableTileEntity,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.ISoundTile,
EnergyHelper.IIEInternalFluxConnector,
EnergyHelper.IIEInternalFluxHandler,
EnergyTransferHandler.EnergyConnector {
    public static final int FLUX_CAPACITY = 8000;
    protected WireType wireType;
    protected boolean isActive = false;
    protected Direction facing = Direction.NORTH;
    protected FluxStorage energyStorage = new FluxStorage(this.getMaxStorage(), Integer.MAX_VALUE, this.getMaxOutput());
    protected FluidTank tank = new FluidTank(8000, fluid -> fluid != null && fluid != FluidStack.EMPTY && FuelHandler.isValidFuel(fluid.getFluid()));
    EnergyHelper.IEForgeEnergyWrapper energyWrapper;
    private LazyOptional<IFluidHandler> fluidHandler;

    public GasGeneratorTileEntity() {
        super((TileEntityType)IPTileTypes.GENERATOR.get());
    }

    public int getMaxOutput() {
        return IEServerConfig.MACHINES.lvCapConfig.output.getAsInt();
    }

    private int getMaxStorage() {
        return IEServerConfig.MACHINES.lvCapConfig.storage.getAsInt();
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.isActive = nbt.func_74767_n("isActive");
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
        this.energyStorage.readFromNBT(nbt.func_74775_l("buffer"));
        this.wireType = nbt.func_74764_b("wiretype") ? WireUtils.getWireTypeFromNBT((CompoundNBT)nbt, (String)"wiretype") : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        nbt.func_74757_a("isActive", this.isActive);
        nbt.func_218657_a("tank", (INBT)this.tank.writeToNBT(new CompoundNBT()));
        nbt.func_218657_a("buffer", (INBT)this.energyStorage.writeToNBT(new CompoundNBT()));
        if (this.wireType != null) {
            nbt.func_74778_a("wiretype", this.wireType.getUniqueName());
        }
        return nbt;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_196082_o();
            this.tank.readFromNBT(nbt.func_74775_l("tank"));
            this.energyStorage.readFromNBT(nbt.func_74775_l("energy"));
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.field_145850_b.func_195593_d(this.field_174879_c, state.func_177230_c());
    }

    public List<ItemStack> getTileDrops(LootContext context) {
        ItemStack stack = context != null ? new ItemStack((IItemProvider)((BlockState)context.func_216031_c(LootParameters.field_216287_g)).func_177230_c()) : new ItemStack((IItemProvider)this.func_195044_w().func_177230_c());
        CompoundNBT nbt = new CompoundNBT();
        if (this.tank.getFluidAmount() > 0) {
            CompoundNBT tankNbt = this.tank.writeToNBT(new CompoundNBT());
            nbt.func_218657_a("tank", (INBT)tankNbt);
        }
        if (this.energyStorage.getEnergyStored() > 0) {
            CompoundNBT energyNbt = this.energyStorage.writeToNBT(new CompoundNBT());
            nbt.func_218657_a("energy", (INBT)energyNbt);
        }
        if (!nbt.isEmpty()) {
            stack.func_77982_d(nbt);
        }
        return ImmutableList.of((Object)stack);
    }

    public int getAvailableEnergy() {
        return Math.min(this.getMaxOutput(), this.energyStorage.getEnergyStored());
    }

    public void extractEnergy(int amount) {
        this.energyStorage.extractEnergy(amount, false);
    }

    public boolean isSource(ConnectionPoint cp) {
        return true;
    }

    public boolean isSink(ConnectionPoint cp) {
        return false;
    }

    public boolean shouldPlaySound(String sound) {
        return this.isActive;
    }

    public FluxStorage getFluxStorage() {
        return this.energyStorage;
    }

    public IEEnums.IOSideConfig getEnergySideConfig(Direction facing) {
        return IEEnums.IOSideConfig.OUTPUT;
    }

    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(Direction facing) {
        if (facing != this.facing) {
            return null;
        }
        if (this.energyWrapper == null || this.energyWrapper.side != this.facing) {
            this.energyWrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, this.facing);
        }
        return this.energyWrapper;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || side == Direction.UP)) {
            if (this.fluidHandler == null) {
                this.fluidHandler = LazyOptional.of(() -> this.tank);
            }
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.fluidHandler != null) {
            this.fluidHandler.invalidate();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.fluidHandler != null) {
            this.fluidHandler.invalidate();
        }
    }

    public ITextComponent[] getOverlayText(PlayerEntity player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack((ItemStack)player.func_184586_b(Hand.MAIN_HAND))) {
            Object s = null;
            s = this.tank.getFluid().getAmount() > 0 ? ((IFormattableTextComponent)this.tank.getFluid().getDisplayName()).func_240702_b_(": " + this.tank.getFluidAmount() + "mB") : new TranslationTextComponent("gui.immersiveengineering.empty");
            return new ITextComponent[]{s};
        }
        return null;
    }

    public boolean useNixieFont(PlayerEntity player, RayTraceResult mop) {
        return false;
    }

    public boolean interact(Direction side, PlayerEntity player, Hand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)this.tank)) {
            this.func_70296_d();
            return true;
        }
        if (player.func_225608_bj_()) {
            boolean added = false;
            if (player.field_71071_by.func_70448_g().func_190926_b()) {
                added = true;
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.getTileDrops(null).get(0));
            } else {
                added = player.field_71071_by.func_70441_a(this.getTileDrops(null).get(0));
            }
            if (added) {
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            }
            return true;
        }
        return false;
    }

    public Direction getFacing() {
        return this.facing;
    }

    public void setFacing(Direction facing) {
        this.facing = facing;
    }

    public IEBlockInterfaces.IDirectionalTile.PlacementLimitation getFacingLimitation() {
        return IEBlockInterfaces.IDirectionalTile.PlacementLimitation.HORIZONTAL;
    }

    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return false;
    }

    public boolean canHammerRotate(Direction side, Vector3d hit, LivingEntity entity) {
        return true;
    }

    public boolean canRotate(Direction axis) {
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            ImmersiveEngineering.proxy.handleTileSound(IESounds.dieselGenerator, (TileEntity)this, this.isActive, 0.3f, 0.75f);
            if (this.isActive && this.field_145850_b.func_82737_E() % 4L == 0L) {
                Direction fl = this.facing;
                Direction fw = this.facing.func_176746_e();
                Vector3i vec = fw.func_176734_d().func_176730_m();
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)((float)(fl.func_82601_c() * 2) / 16.0f) + (double)((float)(-fw.func_82601_c()) * 0.6125f);
                double y = (double)this.field_174879_c.func_177956_o() + 0.4;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)((float)(fl.func_82599_e() * 2) / 16.0f) + (double)((float)(-fw.func_82599_e()) * 0.6125f);
                this.field_145850_b.func_195594_a((IParticleData)(this.field_145850_b.field_73012_v.nextInt(10) == 0 ? ParticleTypes.field_197594_E : ParticleTypes.field_197601_L), x, y, z, (double)vec.func_177958_n() * 0.025, 0.0, (double)vec.func_177952_p() * 0.025);
            }
        } else {
            Fluid fluid;
            int amount;
            boolean lastActive = this.isActive;
            this.isActive = false;
            if (!this.field_145850_b.func_175640_z(this.field_174879_c) && this.tank.getFluid() != null && (amount = FuelHandler.getFuelUsedPerTick(fluid = this.tank.getFluid().getFluid())) > 0 && this.tank.getFluidAmount() >= amount && this.energyStorage.receiveEnergy(FuelHandler.getFluxGeneratedPerTick(fluid), false) > 0) {
                this.tank.drain(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
                this.isActive = true;
            }
            if (lastActive != this.isActive || !this.field_145850_b.field_72995_K && this.isActive) {
                this.func_70296_d();
            }
        }
    }

    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        this.wireType = cableType;
        this.func_70296_d();
    }

    public void removeCable(@Nullable Connection connection, ConnectionPoint attachedPoint) {
        this.wireType = null;
        this.func_70296_d();
    }

    public boolean canConnect() {
        return true;
    }

    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vector3i offset) {
        if (this.field_145850_b.func_180495_p(target.getPosition()).func_177230_c() != this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()) {
            return false;
        }
        return this.wireType == null && (cableType.getCategory().equals("LV") || cableType.getCategory().equals("MV"));
    }

    public BlockPos getConnectionMaster(@Nullable WireType cableType, TargetingInfo target) {
        return this.field_174879_c;
    }

    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vector3i offset) {
        return new ConnectionPoint(this.field_174879_c, 0);
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return Arrays.asList(new ConnectionPoint(this.field_174879_c, 0));
    }

    public Vector3d getConnectionOffset(@Nonnull Connection con, ConnectionPoint here) {
        float xo = (float)this.facing.func_176730_m().func_177958_n() * 0.5f + 0.5f;
        float zo = (float)this.facing.func_176730_m().func_177952_p() * 0.5f + 0.5f;
        return new Vector3d((double)xo, 0.5, (double)zo);
    }
}

