/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.lubehandlers;

import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CrusherTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import flaxbeard.immersivepetroleum.api.crafting.LubricatedHandler;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.IPModels;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.AutoLubricatorTileEntity;
import java.util.Iterator;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrusherLubricationHandler
implements LubricatedHandler.ILubricationHandler<CrusherTileEntity> {
    private static Vector3i size = new Vector3i(3, 3, 5);
    private static final ResourceLocation TEXTURE = new ResourceLocation("immersivepetroleum", "textures/models/lube_pipe.png");
    private static Supplier<IPModel> pipes;

    @Override
    public Vector3i getStructureDimensions() {
        return size;
    }

    @Override
    public boolean isMachineEnabled(World world, CrusherTileEntity mbte) {
        return mbte.shouldRenderAsActive();
    }

    @Override
    public TileEntity isPlacedCorrectly(World world, AutoLubricatorTileEntity lubricator, Direction facing) {
        CrusherTileEntity master;
        BlockPos target = lubricator.func_174877_v().func_177972_a(facing);
        TileEntity te = world.func_175625_s(target);
        if (te instanceof CrusherTileEntity && (master = (CrusherTileEntity)((CrusherTileEntity)te).master()) != null && master.getFacing().func_176734_d() == facing) {
            return master;
        }
        return null;
    }

    @Override
    public void lubricate(World world, int ticks, CrusherTileEntity mbte) {
        if (!world.field_72995_K) {
            int consume;
            Iterator processIterator = mbte.processQueue.iterator();
            PoweredMultiblockTileEntity.MultiblockProcess process = (PoweredMultiblockTileEntity.MultiblockProcess)processIterator.next();
            if (ticks % 4 == 0 && (consume = mbte.energyStorage.extractEnergy(process.energyPerTick, true)) >= process.energyPerTick) {
                mbte.energyStorage.extractEnergy(process.energyPerTick, false);
                if (process.processTick < process.maxTicks) {
                    ++process.processTick;
                }
                if (process.processTick >= process.maxTicks && mbte.processQueue.size() > 1) {
                    process = (PoweredMultiblockTileEntity.MultiblockProcess)processIterator.next();
                    if (process.processTick < process.maxTicks) {
                        ++process.processTick;
                    }
                }
            }
        } else {
            mbte.animation_barrelRotation += 4.5f;
            mbte.animation_barrelRotation %= 360.0f;
        }
    }

    @Override
    public void spawnLubricantParticles(World world, AutoLubricatorTileEntity lubricator, Direction facing, CrusherTileEntity mbte) {
        Direction f = mbte.getIsMirrored() ? facing : facing.func_176734_d();
        float location = world.field_73012_v.nextFloat();
        boolean flip = f.func_176740_k() == Direction.Axis.Z ^ facing.func_176743_c() == Direction.AxisDirection.POSITIVE ^ !mbte.getIsMirrored();
        float xO = 2.5f;
        float zO = -0.1f;
        float yO = 1.3f;
        if (location > 0.5f) {
            xO = 1.0f;
            yO = 3.0f;
            zO = 1.65f;
        }
        if (facing.func_176743_c() == Direction.AxisDirection.NEGATIVE) {
            xO = -xO + 1.0f;
        }
        if (!flip) {
            zO = -zO + 1.0f;
        }
        float x = (float)lubricator.func_174877_v().func_177958_n() + (f.func_176740_k() == Direction.Axis.X ? xO : zO);
        float y = (float)lubricator.func_174877_v().func_177956_o() + yO;
        float z = (float)lubricator.func_174877_v().func_177952_p() + (f.func_176740_k() == Direction.Axis.X ? zO : xO);
        for (int i = 0; i < 3; ++i) {
            float r1 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r2 = (world.field_73012_v.nextFloat() - 0.5f) * 2.0f;
            float r3 = world.field_73012_v.nextFloat();
            BlockState n = IPContent.Fluids.lubricant.block.func_176223_P();
            world.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197628_u, n), (double)x, (double)y, (double)z, (double)(r1 * 0.04f), (double)(r3 * 0.0125f), (double)(r2 * 0.025f));
        }
    }

    @Override
    public Tuple<BlockPos, Direction> getGhostBlockPosition(World world, CrusherTileEntity mbte) {
        if (!mbte.isDummy()) {
            BlockPos pos = mbte.func_174877_v().func_177967_a(mbte.getFacing(), 2);
            Direction f = mbte.getFacing().func_176734_d();
            return new Tuple((Object)pos, (Object)f);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderPipes(AutoLubricatorTileEntity lubricator, CrusherTileEntity mbte, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        IPModel model;
        matrix.func_227861_a_(0.0, -1.0, 0.0);
        BlockPos offset = mbte.func_174877_v().func_177973_b((Vector3i)lubricator.func_174877_v());
        matrix.func_227861_a_((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
        Direction rotation = mbte.getFacing();
        switch (rotation) {
            case NORTH: {
                matrix.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                matrix.func_227861_a_(-1.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                matrix.func_227863_a_(new Quaternion(0.0f, 270.0f, 0.0f, true));
                matrix.func_227861_a_(0.0, 0.0, -1.0);
                break;
            }
            case EAST: {
                matrix.func_227861_a_(0.0, 0.0, 0.0);
                break;
            }
            case WEST: {
                matrix.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                matrix.func_227861_a_(-1.0, 0.0, -1.0);
                break;
            }
        }
        if (pipes == null) {
            pipes = IPModels.getSupplier("crusher_lubepipes");
        }
        if ((model = pipes.get()) != null) {
            model.func_225598_a_(matrix, buffer.getBuffer(model.func_228282_a_(TEXTURE)), combinedLight, combinedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

