/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.crude_burner;

import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.mrh0.createaddition.recipe.crude_burning.CrudeBurningRecipe;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CrudeBurnerTileEntity
extends AbstractFurnaceTileEntity
implements IHaveGoggleInformation {
    private static final int[] SLOTS = new int[0];
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected FluidTank tankInventory;
    private Optional<CrudeBurningRecipe> recipeCache = Optional.empty();
    private Fluid lastFluid = null;
    private int updateTimeout = 10;
    private boolean changed = true;
    boolean first = true;

    public CrudeBurnerTileEntity(TileEntityType<?> type) {
        super(type, IRecipeType.field_222150_b);
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(4000, this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.func_145830_o()) {
            return;
        }
        this.update(newFluidStack);
    }

    private void update(FluidStack stack) {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (stack.getFluid() != this.lastFluid) {
            this.recipeCache = this.find(stack, this.field_145850_b);
        }
        this.lastFluid = stack.getFluid();
        this.changed = true;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("");
    }

    protected Container func_213906_a(int window, PlayerInventory inv) {
        return null;
    }

    protected boolean func_214008_b(IRecipe<?> recipe) {
        return true;
    }

    private boolean burning() {
        return this.field_214018_j > 0;
    }

    public int getBurnTime(FluidStack fluid) {
        return this.recipeCache.isPresent() ? this.recipeCache.get().getBurnTime() / 10 : 0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.first) {
            this.update(this.tankInventory.getFluid());
        }
        this.first = false;
        --this.updateTimeout;
        if (this.updateTimeout < 0) {
            this.updateTimeout = 0;
        }
        if (this.updateTimeout == 0 && this.changed) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
                if (this.field_145850_b != null) {
                    this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 22);
                }
                this.changed = false;
            }
            this.updateTimeout = 10;
        }
        boolean flag = this.burning();
        boolean flag1 = false;
        if (this.burning()) {
            --this.field_214018_j;
        }
        if (!this.field_145850_b.func_201670_d()) {
            if (!this.burning()) {
                this.field_214018_j = this.getBurnTime(this.tankInventory.getFluid());
                if (this.burning()) {
                    flag1 = true;
                    this.updateTimeout = 0;
                    this.tankInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (flag != this.burning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.burning())), 3);
            }
            if (flag1) {
                this.func_70296_d();
            }
        }
    }

    public int[] func_180463_a(Direction dir) {
        return SLOTS;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.tankInventory.readFromNBT(nbt.func_74775_l("TankContent"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_218657_a("TankContent", (INBT)this.tankInventory.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(nbt);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    public Optional<CrudeBurningRecipe> find(FluidStack stack, World world) {
        return world.func_199532_z().func_215371_a(CrudeBurningRecipe.TYPE, (IInventory)new FluidRecipeWrapper(stack), world);
    }
}

