/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.electric_motor;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.electric_motor.ElectricMotorBlock;
import com.mrh0.createaddition.compat.computercraft.ElectricMotorPeripheral;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.item.Multimeter;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.GeneratingKineticTileEntity;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class ElectricMotorTileEntity
extends GeneratingKineticTileEntity {
    protected ScrollValueBehaviour generatedSpeed;
    protected final InternalEnergyStorage energy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
    private LazyOptional<IEnergyStorage> lazyEnergy = LazyOptional.of(() -> this.energy);
    private LazyOptional<ElectricMotorPeripheral> lazyPeripheral = null;
    private boolean cc_update_rpm = false;
    private int cc_new_rpm = 32;
    private static final Integer RPM_RANGE = (Integer)Config.ELECTRIC_MOTOR_RPM_RANGE.get();
    private static final Integer DEFAULT_SPEED = 32;
    private static final Integer MAX_IN = (Integer)Config.ELECTRIC_MOTOR_MAX_INPUT.get();
    private static final Integer MIN_CONSUMPTION = (Integer)Config.ELECTRIC_MOTOR_MINIMUM_CONSUMPTION.get();
    private static final Integer MAX_OUT = 0;
    private static final Integer CAPACITY = (Integer)Config.ELECTRIC_MOTOR_CAPACITY.get();
    private static final Integer STRESS = (Integer)Config.BASELINE_STRESS.get();
    private boolean active = false;
    int cc_antiSpam = 0;
    boolean first = true;

    public ElectricMotorTileEntity(TileEntityType<? extends ElectricMotorTileEntity> type) {
        super(type);
        if (CreateAddition.CC_ACTIVE) {
            this.lazyPeripheral = LazyOptional.of(() -> Peripherals.createElectricMotorPeripheral(this));
        }
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        CenteredSideValueBoxTransform slot = new CenteredSideValueBoxTransform((motor, side) -> motor.func_177229_b((Property)ElectricMotorBlock.FACING) == side.func_176734_d());
        this.generatedSpeed = new ScrollValueBehaviour((ITextComponent)Lang.translate((String)"generic.speed", (Object[])new Object[0]), (SmartTileEntity)this, (ValueBoxTransform)slot);
        this.generatedSpeed.between(-RPM_RANGE.intValue(), RPM_RANGE.intValue());
        this.generatedSpeed.value = DEFAULT_SPEED;
        this.generatedSpeed.scrollableValue = DEFAULT_SPEED;
        this.generatedSpeed.withUnit(i -> Lang.translate((String)"generic.unit.rpm", (Object[])new Object[0]));
        this.generatedSpeed.withCallback(i -> this.updateGeneratedRotation((int)i));
        this.generatedSpeed.withStepFunction(ElectricMotorTileEntity::step);
        behaviours.add((TileEntityBehaviour)this.generatedSpeed);
    }

    public static int step(ScrollValueBehaviour.StepContext context) {
        int current = context.currentValue;
        int step = 1;
        if (!context.shift) {
            int magnitude = Math.abs(current) - (context.forward == current > 0 ? 0 : 1);
            if (magnitude >= 4) {
                step *= 4;
            }
            if (magnitude >= 32) {
                step *= 4;
            }
            if (magnitude >= 128) {
                step *= 4;
            }
        }
        return step;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)STRESS.intValue() / 256.0f;
        return capacity;
    }

    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new TranslationTextComponent("createaddition.tooltip.energy.consumption").func_240699_a_(TextFormatting.GRAY)));
        tooltip.add((ITextComponent)new StringTextComponent("    ").func_230529_a_((ITextComponent)new StringTextComponent(" " + Multimeter.format(ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue())) + "fe/t ").func_240699_a_(TextFormatting.AQUA)).func_230529_a_((ITextComponent)Lang.translate((String)"gui.goggles.at_current_speed", (Object[])new Object[0]).func_240699_a_(TextFormatting.DARK_GRAY)));
        added = true;
        return added;
    }

    public void updateGeneratedRotation(int i) {
        super.updateGeneratedRotation();
        this.cc_new_rpm = i;
    }

    public void initialize() {
        super.initialize();
        if (!this.hasSource() || this.getGeneratedSpeed() > this.getTheoreticalSpeed()) {
            this.updateGeneratedRotation();
        }
    }

    public float getGeneratedSpeed() {
        if (!CABlocks.ELECTRIC_MOTOR.has(this.func_195044_w())) {
            return 0.0f;
        }
        return ElectricMotorTileEntity.convertToDirection((float)(this.active ? (float)this.generatedSpeed.getValue() : 0.0f), (Direction)((Direction)this.func_195044_w().func_177229_b((Property)ElectricMotorBlock.FACING)));
    }

    protected Block getStressConfigKey() {
        return (Block)AllBlocks.WATER_WHEEL.get();
    }

    public InternalEnergyStorage getEnergyStorage() {
        return this.energy;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (this.isEnergyInput(side) || this.isEnergyOutput(side))) {
            return this.lazyEnergy.cast();
        }
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.lazyPeripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean isEnergyInput(Direction side) {
        return side != this.func_195044_w().func_177229_b((Property)ElectricMotorBlock.FACING);
    }

    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        super.fromTag(state, compound, clientPacket);
        this.energy.read(compound);
        this.active = compound.func_74767_n("active");
    }

    public void write(CompoundNBT compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.energy.write(compound);
        compound.func_74757_a("active", this.active);
    }

    public void lazyTick() {
        super.lazyTick();
        this.cc_antiSpam = 5;
    }

    public static int getEnergyConsumptionRate(int rpm) {
        return Math.abs(rpm) > 0 ? (int)Math.max((double)((Integer)Config.FE_RPM.get()).intValue() * ((double)Math.abs(rpm) / 256.0), (double)MIN_CONSUMPTION.intValue()) : 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.lazyEnergy.invalidate();
        if (this.lazyPeripheral != null) {
            this.lazyPeripheral.invalidate();
        }
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (this.first) {
            this.updateGeneratedRotation();
            this.first = false;
        }
        if (this.cc_update_rpm && this.cc_antiSpam > 0) {
            this.generatedSpeed.setValue(this.cc_new_rpm);
            this.cc_update_rpm = false;
            --this.cc_antiSpam;
            this.updateGeneratedRotation();
        }
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        int con = ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
        if (!this.active) {
            if (this.energy.getEnergyStored() > con * 2) {
                this.active = true;
                this.updateGeneratedRotation();
            }
        } else {
            int ext = this.energy.internalConsumeEnergy(con);
            if (ext < con) {
                this.active = false;
                this.updateGeneratedRotation();
            }
        }
    }

    public int getDurationAngle(int deg, float initialProgress, float speed) {
        speed = Math.abs(speed);
        deg = Math.abs(deg);
        if (speed < 0.1f) {
            return 0;
        }
        double degreesPerTick = speed * 360.0f / 60.0f / 20.0f;
        return (int)((double)((1.0f - initialProgress) * (float)deg) / degreesPerTick + 1.0);
    }

    public int getDurationDistance(int dis, float initialProgress, float speed) {
        speed = Math.abs(speed);
        dis = Math.abs(dis);
        if (speed < 0.1f) {
            return 0;
        }
        double metersPerTick = speed / 512.0f;
        return (int)((double)((1.0f - initialProgress) * (float)dis) / metersPerTick);
    }

    public boolean setRPM(int rpm) {
        this.cc_new_rpm = rpm = Math.max(Math.min(rpm, RPM_RANGE), -RPM_RANGE.intValue());
        this.cc_update_rpm = true;
        return this.cc_antiSpam > 0;
    }

    public int getRPM() {
        return this.cc_new_rpm;
    }

    public int getGeneratedStress() {
        return (int)this.calculateAddedStressCapacity();
    }

    public int getEnergyConsumption() {
        return ElectricMotorTileEntity.getEnergyConsumptionRate(this.generatedSpeed.getValue());
    }

    public World getWorld() {
        return this.func_145831_w();
    }
}

