/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class InternalEnergyStorage
extends EnergyStorage {
    public InternalEnergyStorage(int capacity) {
        super(capacity, capacity, capacity, 0);
    }

    public InternalEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer, maxTransfer, 0);
    }

    public InternalEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract, 0);
    }

    public InternalEnergyStorage(int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74768_a("energy", this.energy);
        return nbt;
    }

    public void read(CompoundNBT nbt) {
        this.setEnergy(nbt.func_74762_e("energy"));
    }

    public CompoundNBT write(CompoundNBT nbt, String name) {
        nbt.func_74768_a("energy_" + name, this.energy);
        return nbt;
    }

    public void read(CompoundNBT nbt, String name) {
        this.setEnergy(nbt.func_74762_e("energy_" + name));
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int internalConsumeEnergy(int consume) {
        int oenergy = this.energy;
        this.energy = Math.max(0, this.energy - consume);
        return oenergy - this.energy;
    }

    public int internalProduceEnergy(int produce) {
        int oenergy = this.energy;
        this.energy = Math.min(this.capacity, this.energy + produce);
        return oenergy - this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    @Deprecated
    public void outputToSide(World world, BlockPos pos, Direction side, int max) {
        TileEntity te = world.func_175625_s(pos.func_177972_a(side));
        if (te == null) {
            return;
        }
        LazyOptional opt = te.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
        IEnergyStorage ies = (IEnergyStorage)opt.orElse(null);
        if (ies == null) {
            return;
        }
        int ext = this.extractEnergy(max, false);
        this.receiveEnergy(ext - ies.receiveEnergy(ext, false), false);
    }

    public String toString() {
        return this.getEnergyStored() + "/" + this.getMaxEnergyStored();
    }
}

