/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.network;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.network.IObserveTileEntity;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class ObservePacket {
    private BlockPos pos;
    private int node;
    private static int cooldown = 0;

    public ObservePacket(BlockPos pos, int node) {
        this.pos = pos;
        this.node = node;
    }

    public static void encode(ObservePacket packet, PacketBuffer tag) {
        tag.func_179255_a(packet.pos);
        tag.writeInt(packet.node);
    }

    public static ObservePacket decode(PacketBuffer buf) {
        ObservePacket scp = new ObservePacket(buf.func_179259_c(), buf.readInt());
        return scp;
    }

    public static void handle(ObservePacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    ObservePacket.sendUpdate(pkt, player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void sendUpdate(ObservePacket pkt, ServerPlayerEntity player) {
        TileEntity te = player.field_70170_p.func_175625_s(pkt.pos);
        if (te != null && te instanceof IObserveTileEntity) {
            IObserveTileEntity ote = (IObserveTileEntity)te;
            ote.onObserved(player, pkt);
            SUpdateTileEntityPacket supdatetileentitypacket = te.func_189518_D_();
            if (supdatetileentitypacket != null) {
                player.field_71135_a.func_147359_a((IPacket)supdatetileentitypacket);
            }
        }
    }

    public static void tick() {
        if (--cooldown < 0) {
            cooldown = 0;
        }
    }

    public static void send(BlockPos pos, int node) {
        if (cooldown > 0) {
            return;
        }
        cooldown = 10;
        CreateAddition.Network.sendToServer((Object)new ObservePacket(pos, node));
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getNode() {
        return this.node;
    }
}

