/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_293;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private class_287 bufferBuilder = new class_287(256);
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinder;
    private int prevTextureId;
    private class_293 prevFormat;
    private class_1921 renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinder, class_1921 renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinder = textureBinder;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            class_287 bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            this.renderType.method_23516();
            bufferBuilder.method_1326();
            for (Integer texture : this.texturesForDrawCalls) {
                textureBinder.accept(texture);
                class_286.method_1309((class_287)bufferBuilder);
            }
            textureBinder.accept(0);
            this.renderType.method_23518();
        }
        this.texturesForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    public class_287 begin(int mode, class_293 format, int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId || !Objects.equals(this.prevFormat, format)) {
            if (this.prevTextureId != -1) {
                this.bufferBuilder.method_1326();
            }
            this.bufferBuilder.method_1328(mode, format);
            this.prevTextureId = textureId;
            this.prevFormat = format;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

