/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_4493;
import net.minecraft.class_4588;
import org.lwjgl.opengl.GL11;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;

public class MinimapRendererHelper {
    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float factor) {
        this.drawMyTexturedModalRect(x, y, textureX, textureY, width, height, height, factor);
    }

    public void drawMyTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1585);
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + height), 0.0).method_22913((float)(textureX + 0) * f, (float)(textureY + 0) * f1).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_22913(((float)textureX + width) * f, (float)(textureY + 0) * f1).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + 0.0f), 0.0).method_22913(((float)textureX + width) * f, ((float)textureY + theight) * f1).method_1344();
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + 0.0f), 0.0).method_22913((float)(textureX + 0) * f, ((float)textureY + theight) * f1).method_1344();
        tessellator.method_1350();
    }

    public void drawMyTexturedModalRect(class_1159 matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1585);
        vertexBuffer.method_22918(matrix, x + 0.0f, y + height, 0.0f).method_22913((float)(textureX + 0) * f, (float)(textureY + 0) * f1).method_1344();
        vertexBuffer.method_22918(matrix, x + width, y + height, 0.0f).method_22913(((float)textureX + width) * f, (float)(textureY + 0) * f1).method_1344();
        vertexBuffer.method_22918(matrix, x + width, y + 0.0f, 0.0f).method_22913(((float)textureX + width) * f, ((float)textureY + theight) * f1).method_1344();
        vertexBuffer.method_22918(matrix, x + 0.0f, y + 0.0f, 0.0f).method_22913((float)(textureX + 0) * f, ((float)textureY + theight) * f1).method_1344();
        tessellator.method_1350();
    }

    public void prepareMyTexturedColoredModalRect(class_1159 matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, float r, float g, float b, float a, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        class_287 vertexBuffer = renderer.begin(7, class_290.field_1575, textureId);
        vertexBuffer.method_22918(matrix, x + 0.0f, y + height, 0.0f).method_22913((float)(textureX + 0) * f, (float)(textureY + 0) * f1).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + width, y + height, 0.0f).method_22913(((float)textureX + width) * f, (float)(textureY + 0) * f1).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + width, y + 0.0f, 0.0f).method_22913(((float)textureX + width) * f, ((float)textureY + theight) * f1).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + 0.0f, y + 0.0f, 0.0f).method_22913((float)(textureX + 0) * f, ((float)textureY + theight) * f1).method_22915(r, g, b, a).method_1344();
    }

    public void prepareMyTexturedModalRect(class_1159 matrix, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, int textureId, MultiTextureRenderTypeRenderer renderer) {
        float f;
        float f1 = f = 1.0f / factor;
        class_287 vertexBuffer = renderer.begin(7, class_290.field_1585, textureId);
        vertexBuffer.method_22918(matrix, x + 0.0f, y + height, 0.0f).method_22913((float)(textureX + 0) * f, (float)(textureY + 0) * f1).method_1344();
        vertexBuffer.method_22918(matrix, x + width, y + height, 0.0f).method_22913(((float)textureX + width) * f, (float)(textureY + 0) * f1).method_1344();
        vertexBuffer.method_22918(matrix, x + width, y + 0.0f, 0.0f).method_22913(((float)textureX + width) * f, ((float)textureY + theight) * f1).method_1344();
        vertexBuffer.method_22918(matrix, x + 0.0f, y + 0.0f, 0.0f).method_22913((float)(textureX + 0) * f, ((float)textureY + theight) * f1).method_1344();
    }

    void drawTexturedElipseInsideRectangle(double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float widthFactor) {
        this.drawTexturedElipseInsideRectangle(startAngle, sides, x, y, textureX, textureY, width, width, widthFactor);
    }

    void drawTexturedElipseInsideRectangle(double startAngle, int sides, float x, float y, int textureX, int textureY, float width, float theight, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        float halfWidth = width / 2.0f;
        double centerX = x + halfWidth;
        double centerY = y + halfWidth;
        float centerU = ((float)textureX + halfWidth) * f;
        float centerV = (float)(((double)textureY + (double)theight * 0.5) * (double)f1);
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalV = 0.0f;
        vertexBuffer.method_1328(4, class_290.field_1585);
        for (int i = 0; i <= sides; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalV = (float)((double)theight * (1.0 - 0.5 * (1.0 - cos)));
            if (i > 0) {
                vertexBuffer.method_22912((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0).method_22913(((float)textureX + vertexLocalX) * f, ((float)textureY + vertexLocalV) * f1).method_1344();
                vertexBuffer.method_22912((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0).method_22913(((float)textureX + prevVertexLocalX) * f, ((float)textureY + prevVertexLocalV) * f1).method_1344();
                vertexBuffer.method_22912(centerX, centerY, 0.0).method_22913(centerU, centerV).method_1344();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalV = vertexLocalV;
        }
        tessellator.method_1350();
    }

    void drawTexturedElipseInsideRectangleFrame(boolean resetTexture, boolean reverseTexture, double startAngle, int startIndex, int endIndex, int sides, float thickness, float x, float y, int textureX, int textureY, float width, float twidth, float theight, int seamWidth, float widthFactor) {
        float f;
        float f1 = f = 1.0f / widthFactor;
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        float halfWidth = width / 2.0f;
        double fullCircle = Math.PI * 2;
        float prevVertexLocalX = 0.0f;
        float prevVertexLocalY = 0.0f;
        float prevVertexLocalOuterX = 0.0f;
        float prevVertexLocalOuterY = 0.0f;
        float prevSegmentTextureX = 0.0f;
        vertexBuffer.method_1328(7, class_290.field_1585);
        float outerRadius = halfWidth + thickness;
        float segmentOuterWidth = (float)(fullCircle / (double)sides * (double)outerRadius);
        startIndex = Math.max(Math.min(startIndex, sides), 0);
        endIndex = Math.max(Math.min(endIndex, sides), startIndex);
        int textureStartIndex = resetTexture ? (reverseTexture ? endIndex : startIndex) : 0;
        float seamThreshold = reverseTexture ? (float)seamWidth + segmentOuterWidth : (float)seamWidth;
        for (int i = startIndex; i <= endIndex; ++i) {
            double angle = startAngle + (double)i / (double)sides * fullCircle;
            double sin = Math.sin(angle);
            double cos = Math.cos(angle);
            float vertexLocalX = halfWidth + (float)((double)halfWidth * sin);
            float vertexLocalY = (float)((double)halfWidth * (1.0 - cos));
            float vertexLocalOuterX = halfWidth + (float)((double)outerRadius * sin);
            float vertexLocalOuterY = (float)((double)halfWidth - (double)outerRadius * cos);
            float segmentTextureStartX = textureX;
            float offsetX = Math.abs(segmentOuterWidth * (float)(i - textureStartIndex));
            if (offsetX >= seamThreshold) {
                segmentTextureStartX = textureX + seamWidth;
                if ((offsetX -= seamThreshold) >= twidth) {
                    offsetX %= twidth;
                }
            }
            float segmentTextureX = segmentTextureStartX + offsetX;
            if (i > startIndex) {
                vertexBuffer.method_22912((double)(x + prevVertexLocalX), (double)(y + prevVertexLocalY), 0.0).method_22913(prevSegmentTextureX * f, ((float)textureY + theight) * f1).method_1344();
                vertexBuffer.method_22912((double)(x + vertexLocalX), (double)(y + vertexLocalY), 0.0).method_22913(segmentTextureX * f, ((float)textureY + theight) * f1).method_1344();
                vertexBuffer.method_22912((double)(x + vertexLocalOuterX), (double)(y + vertexLocalOuterY), 0.0).method_22913(segmentTextureX * f, (float)textureY * f1).method_1344();
                vertexBuffer.method_22912((double)(x + prevVertexLocalOuterX), (double)(y + prevVertexLocalOuterY), 0.0).method_22913(prevSegmentTextureX * f, (float)textureY * f1).method_1344();
            }
            prevVertexLocalX = vertexLocalX;
            prevVertexLocalY = vertexLocalY;
            prevVertexLocalOuterX = vertexLocalOuterX;
            prevVertexLocalOuterY = vertexLocalOuterY;
            prevSegmentTextureX = segmentTextureX;
        }
        tessellator.method_1350();
    }

    public void addTexturedRectToExistingBuffer(class_4588 vertexBuffer, float x, float y, int u, int v, int w, int h) {
        float f = 0.00390625f;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.method_22912((double)x, (double)(y + (float)h), 0.0).method_22913(normalizedU1, normalizedV2).method_1344();
        vertexBuffer.method_22912((double)(x + (float)w), (double)(y + (float)h), 0.0).method_22913(normalizedU2, normalizedV2).method_1344();
        vertexBuffer.method_22912((double)(x + (float)w), (double)y, 0.0).method_22913(normalizedU2, normalizedV1).method_1344();
        vertexBuffer.method_22912((double)x, (double)y, 0.0).method_22913(normalizedU1, normalizedV1).method_1344();
    }

    public void addTexturedColoredRectToExistingBuffer(class_1159 matrix, class_4588 vertexBuffer, float x, float y, int u, int v, int w, int h, float r, float g, float b, float a, float factor) {
        float f = 1.0f / factor;
        float normalizedU1 = (float)u * f;
        float normalizedV1 = (float)v * f;
        float normalizedU2 = (float)(u + w) * f;
        float normalizedV2 = (float)(v + h) * f;
        vertexBuffer.method_22918(matrix, x, y + (float)h, 0.0f).method_22913(normalizedU1, normalizedV1).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + (float)w, y + (float)h, 0.0f).method_22913(normalizedU2, normalizedV1).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + (float)w, y, 0.0f).method_22913(normalizedU2, normalizedV2).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x, y, 0.0f).method_22913(normalizedU1, normalizedV2).method_22915(r, g, b, a).method_1344();
    }

    public void addColoredRectToExistingBuffer(class_1159 matrix, class_4588 vertexBuffer, float x, float y, int w, int h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.addColoredRectToExistingBuffer(matrix, vertexBuffer, x, y, w, h, r, g, b, a);
    }

    public void addColoredRectToExistingBuffer(class_1159 matrix, class_4588 vertexBuffer, float x, float y, int w, int h, float r, float g, float b, float a) {
        vertexBuffer.method_22918(matrix, x, y + (float)h, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + (float)w, y + (float)h, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x + (float)w, y, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    public void drawMyColoredRect(float x1, float y1, float x2, float y2) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1592);
        vertexBuffer.method_22912((double)x1, (double)y2, 0.0).method_1344();
        vertexBuffer.method_22912((double)x2, (double)y2, 0.0).method_1344();
        vertexBuffer.method_22912((double)x2, (double)y1, 0.0).method_1344();
        vertexBuffer.method_22912((double)x1, (double)y1, 0.0).method_1344();
        tessellator.method_1350();
    }

    public void addColoredLineToExistingBuffer(class_1159 matrix, class_4588 vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.method_22918(matrix, x1, y1, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x2, y2, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    public void drawMyColoredRect(class_1159 matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1576);
        vertexBuffer.method_22918(matrix, x1, y2, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x2, y2, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x2, y1, 0.0f).method_22915(r, g, b, a).method_1344();
        vertexBuffer.method_22918(matrix, x1, y1, 0.0f).method_22915(r, g, b, a).method_1344();
        tessellator.method_1350();
    }

    void bindTextureBuffer(ByteBuffer image, int width, int height, int par0) {
        class_4493.method_22081((int)par0);
        GL11.glTexImage2D((int)3553, (int)0, (int)6407, (int)width, (int)height, (int)0, (int)6407, (int)5121, (ByteBuffer)image);
    }

    void putColor(byte[] bytes, int x, int y, int red, int green, int blue, int size) {
        int pixel = (y * size + x) * 3;
        bytes[pixel] = (byte)red;
        bytes[++pixel] = (byte)green;
        bytes[++pixel] = (byte)blue;
    }

    void gridOverlay(int[] result, int grid, int red, int green, int blue) {
        result[0] = (red * 3 + (grid >> 16 & 0xFF)) / 4;
        result[1] = (green * 3 + (grid >> 8 & 0xFF)) / 4;
        result[2] = (blue * 3 + (grid & 0xFF)) / 4;
    }

    void slimeOverlay(int[] result, int red, int green, int blue) {
        result[0] = (red + 82) / 2;
        result[1] = (green + 241) / 2;
        result[2] = (blue + 64) / 2;
    }

    public void defaultOrtho() {
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)512.0, (double)512.0, (double)0.0, (double)1000.0, (double)3000.0);
    }
}

