/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import java.nio.IntBuffer;
import net.minecraft.class_4493;
import org.lwjgl.opengl.GL11;
import xaero.common.AXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.exception.OpenGLException;
import xaero.common.minimap.render.radar.EntityIcon;

public final class EntityIconAtlas {
    private final int textureId;
    private final int width;
    private int currentIndex;
    private final int iconWidth;
    private final int sideIconCount;
    private final int maxIconCount;

    private EntityIconAtlas(int textureId, int width, int iconWidth) {
        this.textureId = textureId;
        this.width = width;
        this.iconWidth = iconWidth;
        this.sideIconCount = width / iconWidth;
        this.maxIconCount = this.sideIconCount * this.sideIconCount;
    }

    public int getTextureId() {
        return this.textureId;
    }

    public int getWidth() {
        return this.width;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public boolean isFull() {
        return this.currentIndex >= this.maxIconCount;
    }

    public EntityIcon createIcon() {
        if (!this.isFull()) {
            int offsetX = this.currentIndex % this.sideIconCount * this.iconWidth;
            int offsetY = this.currentIndex / this.sideIconCount * this.iconWidth;
            ++this.currentIndex;
            return new EntityIcon(this, offsetX, offsetY);
        }
        return null;
    }

    public static class Builder {
        private final AXaeroMinimap modMain;
        private int width;
        private int preparedTexture;
        private int iconWidth;

        public Builder(AXaeroMinimap modMain) {
            this.modMain = modMain;
        }

        public Builder setDefault() {
            this.setIconWidth(64);
            return this;
        }

        public Builder setPreparedTexture(int preparedTexture) {
            this.preparedTexture = preparedTexture;
            return this;
        }

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setIconWidth(int iconWidth) {
            this.iconWidth = iconWidth;
            return this;
        }

        private int createGlTexture(int actualWidth) {
            int texture = class_4493.method_21914();
            OpenGLException.checkGLError();
            if (texture == 0) {
                return 0;
            }
            class_4493.method_22081((int)texture);
            GL11.glTexParameteri((int)3553, (int)33085, (int)0);
            GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
            GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            class_4493.method_21954((int)3553, (int)0, (int)32856, (int)actualWidth, (int)actualWidth, (int)0, (int)32993, (int)32821, (IntBuffer)null);
            class_4493.method_22081((int)0);
            OpenGLException.checkGLError();
            return texture;
        }

        public EntityIconAtlas build() throws Exception {
            int texture;
            if (this.width == 0 || this.iconWidth <= 0) {
                throw new IllegalStateException();
            }
            if (this.width / this.iconWidth * this.iconWidth != this.width) {
                throw new IllegalArgumentException();
            }
            int n = texture = this.preparedTexture == 0 ? this.createGlTexture(this.width) : this.preparedTexture;
            if (texture == 0) {
                MinimapLogs.LOGGER.error("Failed to create a GL texture for a new entity icon atlas!");
                return null;
            }
            return new EntityIconAtlas(texture, this.width, this.iconWidth);
        }

        public static Builder begin(AXaeroMinimap modMain) {
            return new Builder(modMain).setDefault();
        }
    }
}

