/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;
import net.minecraft.class_4595;
import net.minecraft.class_4608;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.lwjgl.opengl.GL11;
import xaero.common.MinimapLogs;
import xaero.common.minimap.render.radar.ModelPartRenderDetectionInfo;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.misc.Misc;

public class EntityIconModelPartsRenderer {
    public Method ageableModelHeadPartsMethod = Misc.getMethodReflection(class_4592.class, "method_22946", "headParts", "getHeadParts", new Class[0]);
    public Method ageableModelBodyPartsMethod = Misc.getMethodReflection(class_4592.class, "method_22948", "bodyParts", "getBodyParts", new Class[0]);
    public Method segmentedModelPartsMethod = Misc.getMethodReflection(class_4595.class, "method_22960", "parts", "getParts", new Class[0]);
    private Field cubeListField = Misc.getFieldReflection(class_630.class, "field_3663", "cubes", "cuboids");
    private Field childModelsField = Misc.getFieldReflection(class_630.class, "field_3661", "children");

    private ObjectList<class_630.class_628> getCubeList(class_630 modelRenderer) {
        return (ObjectList)Misc.getReflectFieldValue(modelRenderer, this.cubeListField);
    }

    private ObjectList<class_630> getChildModels(class_630 modelRenderer) {
        return (ObjectList)Misc.getReflectFieldValue(modelRenderer, this.childModelsField);
    }

    private boolean hasCubes(class_630 mr) {
        ObjectList<class_630.class_628> mrCubeList = this.getCubeList(mr);
        if (mrCubeList != null && !mrCubeList.isEmpty()) {
            return true;
        }
        ObjectList<class_630> mrChildren = this.getChildModels(mr);
        for (class_630 child : mrChildren) {
            if (!this.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public void renderPart(class_4587 matrixStack, class_4588 vertexBuilder, class_630 mr, ArrayList<class_630> renderedModels, class_630 mainModelPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (mr == null) {
            return;
        }
        if (renderedModels.contains(mr)) {
            return;
        }
        ModelPartRenderDetectionInfo renderInfo = mrde.getModelPartRenderInfo(mr);
        if (renderInfo == null) {
            return;
        }
        if (!this.hasCubes(mr)) {
            return;
        }
        float rotationPointBUX = mr.field_3657;
        float rotationPointBUY = mr.field_3656;
        float rotationPointBUZ = mr.field_3655;
        float rotateAngleBUX = mr.field_3654;
        float rotateAngleBUY = mr.field_3675;
        float rotateAngleBUZ = mr.field_3674;
        boolean showModelBU = mr.field_3665;
        float centerPointX = mainModelPart.field_3657;
        float centerPointY = mainModelPart.field_3656;
        float centerPointZ = mainModelPart.field_3655;
        ObjectList<class_630.class_628> mainCubeList = this.getCubeList(mainModelPart);
        if (mainCubeList != null && !mainCubeList.isEmpty()) {
            float biggestSize = 0.0f;
            class_630.class_628 biggestCuboid = null;
            for (class_630.class_628 cuboid : mainCubeList) {
                float size = Math.abs((cuboid.field_3648 - cuboid.field_3645) * (cuboid.field_3647 - cuboid.field_3644) * (cuboid.field_3646 - cuboid.field_3643));
                if (!(size >= biggestSize)) continue;
                biggestCuboid = cuboid;
                biggestSize = size;
            }
            centerPointY += (biggestCuboid.field_3647 + biggestCuboid.field_3644) / 2.0f;
            centerPointZ += (biggestCuboid.field_3646 + biggestCuboid.field_3643) / 2.0f;
        }
        if (zeroRotation) {
            mr.field_3654 = 0.0f;
            mr.field_3675 = 0.0f;
            mr.field_3674 = 0.0f;
        }
        mr.field_3665 = true;
        try {
            mr.method_2851(mr.field_3657 - centerPointX, mr.field_3656 - centerPointY, mr.field_3655 - centerPointZ);
            mr.method_22699(matrixStack, vertexBuilder, 0xF000F0, class_4608.field_21444, renderInfo.red, renderInfo.green, renderInfo.blue, renderInfo.alpha);
            renderedModels.add(mr);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.info("Exception when rendering entity part. " + mr);
        }
        while (GL11.glGetError() != 0) {
        }
        mr.field_3657 = rotationPointBUX;
        mr.field_3656 = rotationPointBUY;
        mr.field_3655 = rotationPointBUZ;
        if (zeroRotation) {
            mr.field_3654 = rotateAngleBUX;
            mr.field_3675 = rotateAngleBUY;
            mr.field_3674 = rotateAngleBUZ;
        }
        mr.field_3665 = showModelBU;
    }

    public class_630 renderDeclaredMethod(class_4587 matrixStack, class_4588 vertexBuilder, Method m, class_583 entityModel, ArrayList<class_630> renderedModels, class_630 mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        Iterable<class_630> renderers = this.handleDeclaredMethod(m, entityModel);
        return this.renderPartsIterable(renderers, matrixStack, vertexBuilder, renderedModels, mainPart, zeroRotation, mrde);
    }

    public Iterable<class_630> handleDeclaredMethod(Method m, class_583 entityModel) {
        if (m != null) {
            return (Iterable)Misc.getReflectMethodValue(entityModel, m, new Object[0]);
        }
        return null;
    }

    public class_630 renderPartsIterable(Iterable<class_630> parts, class_4587 matrixStack, class_4588 vertexBuilder, ArrayList<class_630> renderedModels, class_630 mainPart, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        if (parts == null) {
            return mainPart;
        }
        Iterator<class_630> partsIterator = parts.iterator();
        if (partsIterator.hasNext()) {
            if (mainPart == null) {
                mainPart = partsIterator.next();
                this.renderPart(matrixStack, vertexBuilder, mainPart, renderedModels, mainPart, zeroRotation, mrde);
            }
            while (partsIterator.hasNext()) {
                this.renderPart(matrixStack, vertexBuilder, partsIterator.next(), renderedModels, mainPart, zeroRotation, mrde);
            }
        }
        return mainPart;
    }
}

