/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics.renderer.multitexture;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.function.IntConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_4493;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;

public class MultiTextureRenderTypeRendererProvider {
    private Deque<MultiTextureRenderTypeRenderer> availableRenderers = new ArrayDeque<MultiTextureRenderTypeRenderer>();
    private HashSet<MultiTextureRenderTypeRenderer> usedRenderers;

    public MultiTextureRenderTypeRendererProvider(int rendererCount) {
        for (int i = 0; i < rendererCount; ++i) {
            this.availableRenderers.add(new MultiTextureRenderTypeRenderer());
        }
        this.usedRenderers = new HashSet();
    }

    public MultiTextureRenderTypeRenderer getRenderer(IntConsumer textureBinder, class_1921 renderType) {
        if (this.availableRenderers.isEmpty()) {
            throw new RuntimeException("No renderers available!");
        }
        MultiTextureRenderTypeRenderer renderer = this.availableRenderers.removeFirst();
        renderer.init(textureBinder, renderType);
        this.usedRenderers.add(renderer);
        return renderer;
    }

    public void draw(MultiTextureRenderTypeRenderer renderer) {
        if (!this.usedRenderers.remove(renderer)) {
            throw new RuntimeException("The renderer requested for drawing was not provided by this provider!");
        }
        renderer.draw();
        this.availableRenderers.add(renderer);
    }

    public static void defaultTextureBind(int texture) {
        class_4493.method_22077((int)33984);
        class_4493.method_22081((int)texture);
    }
}

