/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;
import xaero.map.gui.IDropDownCallback;

public class GuiDropDown
extends class_332 {
    public static final int DEFAULT_BACKGROUND = -939524096;
    public static final int SELECTED_DEFAULT_BACKGROUND = -922757376;
    public static final int SELECTED_DEFAULT_HOVERED_BACKGROUND = -10496;
    public static final int trim = -6250336;
    public static final int trimOpen = -1;
    public static final int trimInside = -13487566;
    protected static final int h = 11;
    private int x;
    private int y;
    private int xOffset = 0;
    private int yOffset = 0;
    private int w;
    private String[] realOptions = new String[0];
    private String[] options = new String[0];
    protected int selected = 0;
    private boolean closed = true;
    private int scroll;
    private long scrollTime;
    private int autoScrolling;
    protected boolean openingUp;
    private IDropDownCallback callback;
    private boolean hasEmptyOption;
    protected int selectedBackground;
    protected int selectedHoveredBackground;
    protected boolean shortenFromTheRight;

    public GuiDropDown(String[] options, int x, int y, int w, Integer selected, IDropDownCallback callback) {
        this(options, x, y, w, selected, callback, true);
    }

    public GuiDropDown(String[] options, int x, int y, int w, Integer selected, IDropDownCallback callback, boolean hasEmptyOption) {
        this(options, x, y, w, selected, false, callback, hasEmptyOption);
    }

    public GuiDropDown(String[] options, int x, int y, int w, Integer selected, boolean openingUp, IDropDownCallback callback, boolean hasEmptyOption) {
        this.x = x;
        this.y = y + (openingUp ? 11 : 0);
        this.w = w;
        this.realOptions = options;
        this.callback = callback;
        int emptyOptionCount = hasEmptyOption ? 1 : 0;
        this.options = new String[this.realOptions.length + emptyOptionCount];
        System.arraycopy(this.realOptions, 0, this.options, emptyOptionCount, this.realOptions.length);
        this.selectId(selected, false);
        this.openingUp = openingUp;
        this.hasEmptyOption = hasEmptyOption;
        this.selectedBackground = -922757376;
        this.selectedHoveredBackground = -10496;
    }

    public int size() {
        return this.realOptions.length;
    }

    public int getXWithOffset() {
        return this.x + this.xOffset;
    }

    public int getYWithOffset() {
        return this.y + this.yOffset;
    }

    private void drawSlot(class_4587 matrixStack, String text, int slotIndex, int pos, int mouseX, int mouseY, boolean scrolling, int optionLimit, int xWithOffset, int yWithOffset) {
        int slotBackground;
        int emptyOptionCount;
        int n = emptyOptionCount = this.hasEmptyOption ? 1 : 0;
        if (this.closed && this.onDropDown(mouseX, mouseY, scrolling, optionLimit) || !this.closed && this.onDropDownSlot(mouseX, mouseY, slotIndex, scrolling, optionLimit)) {
            slotBackground = slotIndex - emptyOptionCount == this.selected ? this.selectedHoveredBackground : -13487566;
        } else {
            int n2 = slotBackground = slotIndex - emptyOptionCount == this.selected ? this.selectedBackground : -939524096;
        }
        if (this.openingUp) {
            pos = -pos - 1;
        }
        GuiDropDown.method_25294((class_4587)matrixStack, (int)xWithOffset, (int)(yWithOffset + 11 * pos), (int)(xWithOffset + this.w), (int)(yWithOffset + 11 + 11 * pos), (int)slotBackground);
        this.method_25292(matrixStack, xWithOffset + 1, xWithOffset + this.w - 1, yWithOffset + 11 * pos, -13487566);
        int textWidth = class_310.method_1551().field_1772.method_1727(text);
        boolean shortened = false;
        while (textWidth > this.w - 2) {
            text = this.shortenFromTheRight ? text.substring(0, text.length() - 1) : text.substring(1);
            textWidth = class_310.method_1551().field_1772.method_1727("..." + text);
            shortened = true;
        }
        if (shortened) {
            text = this.shortenFromTheRight ? text + "..." : "..." + text;
        }
        int textColor = 0xFFFFFF;
        GuiDropDown.method_25300((class_4587)matrixStack, (class_327)class_310.method_1551().field_1772, (String)text, (int)(xWithOffset + this.w / 2), (int)(yWithOffset + 2 + 11 * pos), (int)textColor);
    }

    private void drawMenu(class_4587 matrixStack, int amount, int mouseX, int mouseY, int scaledHeight, int optionLimit) {
        int first;
        boolean scrolling = this.scrolling(optionLimit);
        int totalH = 11 * (amount + (scrolling ? 2 : 0));
        int height = scaledHeight;
        this.yOffset = !this.openingUp && this.y + totalH + 1 > height ? height - this.y - totalH - 1 : (this.openingUp && this.y - totalH < 0 ? totalH - this.y : 0);
        int xWithOffset = this.getXWithOffset();
        int yWithOffset = this.getYWithOffset();
        int n = first = this.closed ? 0 : this.scroll;
        if (scrolling) {
            this.drawSlot(matrixStack, (this.scroll == 0 ? "\u00a78" : "\u00a77") + class_1074.method_4662((String)(this.openingUp ? "gui.xaero_down" : "gui.xaero_up"), (Object[])new Object[0]), -1, 0, mouseX, mouseY, scrolling, optionLimit, xWithOffset, yWithOffset);
            this.drawSlot(matrixStack, (this.scroll + optionLimit >= this.options.length ? "\u00a78" : "\u00a77") + class_1074.method_4662((String)(this.openingUp ? "gui.xaero_up" : "gui.xaero_down"), (Object[])new Object[0]), -2, amount + 1, mouseX, mouseY, scrolling, optionLimit, xWithOffset, yWithOffset);
        }
        for (int i = first; i < first + amount; ++i) {
            String slotText = this.hasEmptyOption && i == 0 ? (!this.closed ? "-" : class_1074.method_4662((String)this.realOptions[this.selected], (Object[])new Object[0]).replace("\u00a7\u00a7", ":")) : class_1074.method_4662((String)this.options[i], (Object[])new Object[0]).replace("\u00a7\u00a7", ":");
            this.drawSlot(matrixStack, slotText, i, i - first + (scrolling ? 1 : 0), mouseX, mouseY, scrolling, optionLimit, xWithOffset, yWithOffset);
        }
        int trimPosY = yWithOffset - (this.openingUp ? totalH : 0);
        int trim = this.closed ? -6250336 : -1;
        this.method_25301(matrixStack, xWithOffset, trimPosY, trimPosY + totalH, trim);
        this.method_25301(matrixStack, xWithOffset + this.w, trimPosY, trimPosY + totalH, trim);
        this.method_25292(matrixStack, xWithOffset, xWithOffset + this.w, trimPosY, trim);
        this.method_25292(matrixStack, xWithOffset, xWithOffset + this.w, trimPosY + totalH, trim);
    }

    private boolean scrolling(int optionLimit) {
        return this.options.length > optionLimit && !this.closed;
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton, int scaledHeight) {
        if (!this.closed) {
            int optionLimit = this.optionLimit(scaledHeight);
            int clickedId = this.getHoveredId(mouseX, mouseY, this.scrolling(optionLimit), optionLimit);
            if (clickedId >= 0) {
                this.selectId(clickedId - (this.hasEmptyOption ? 1 : 0), true);
            } else {
                this.autoScrolling = clickedId == -1 ? 1 : -1;
                this.scrollTime = System.currentTimeMillis();
                this.mouseScrolledInternal(this.autoScrolling, mouseX, mouseY, optionLimit);
            }
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        } else if (this.options.length > 1) {
            this.setClosed(false);
            this.scroll = 0;
        }
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton, int scaledHeight) {
        this.autoScrolling = 0;
    }

    private int getHoveredId(int mouseX, int mouseY, boolean scrolling, int optionLimit) {
        int yOnMenu = mouseY - this.getYWithOffset();
        int visibleSlotIndex = (this.openingUp ? -yOnMenu - 1 : yOnMenu) / 11;
        if (scrolling && visibleSlotIndex == 0) {
            return -1;
        }
        if (visibleSlotIndex >= optionLimit + (scrolling ? 1 : 0)) {
            return -2;
        }
        int slot = this.scroll + visibleSlotIndex - (scrolling ? 1 : 0);
        if (slot >= this.options.length) {
            slot = this.options.length - 1;
        }
        return slot;
    }

    public boolean onDropDown(int mouseX, int mouseY, int scaledHeight) {
        int optionLimit = this.optionLimit(scaledHeight);
        return this.onDropDown(mouseX, mouseY, this.scrolling(optionLimit), optionLimit);
    }

    public boolean onDropDown(int mouseX, int mouseY, boolean scrolling, int optionLimit) {
        int menuHeight;
        int menuTop = this.getYWithOffset();
        int n = this.closed ? 11 : (menuHeight = (Math.min(this.options.length, optionLimit) + (scrolling ? 2 : 0)) * 11);
        if (this.openingUp) {
            menuTop -= menuHeight;
        }
        int xOnMenu = mouseX - this.getXWithOffset();
        int yOnMenu = mouseY - menuTop;
        return xOnMenu >= 0 && yOnMenu >= 0 && xOnMenu <= this.w && yOnMenu < menuHeight;
    }

    private boolean onDropDownSlot(int mouseX, int mouseY, int id, boolean scrolling, int optionLimit) {
        if (!this.onDropDown(mouseX, mouseY, scrolling, optionLimit)) {
            return false;
        }
        int hoveredSlot = this.getHoveredId(mouseX, mouseY, scrolling, optionLimit);
        return hoveredSlot == id;
    }

    public void selectId(int id, boolean callCallback) {
        boolean newId;
        if (id == -1) {
            this.setClosed(true);
            return;
        }
        boolean bl = newId = id != this.selected;
        if (newId && (!callCallback || this.callback.onSelected(this, id))) {
            this.selected = id;
        }
        this.setClosed(true);
    }

    public void drawButton(class_4587 matrixStack, int mouseX, int mouseY, int scaledHeight) {
        int optionLimit = this.optionLimit(scaledHeight);
        if (this.autoScrolling != 0 && System.currentTimeMillis() - this.scrollTime > 100L) {
            this.scrollTime = System.currentTimeMillis();
            this.mouseScrolledInternal(this.autoScrolling, mouseX, mouseY, optionLimit);
        }
        this.drawMenu(matrixStack, this.closed ? 1 : Math.min(optionLimit, this.options.length), mouseX, mouseY, scaledHeight, optionLimit);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        if (!closed && this.closed) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        }
        this.closed = closed;
    }

    public void mouseScrolled(int wheel, int mouseXScaled, int mouseYScaled, int scaledHeight) {
        this.mouseScrolledInternal(wheel * (this.openingUp ? -1 : 1), mouseXScaled, mouseYScaled, this.optionLimit(scaledHeight));
    }

    private void mouseScrolledInternal(int wheel, int mouseXScaled, int mouseYScaled, int optionLimit) {
        int newScroll = this.scroll - wheel;
        if (newScroll + optionLimit > this.options.length) {
            newScroll = this.options.length - optionLimit;
        }
        if (newScroll < 0) {
            newScroll = 0;
        }
        this.scroll = newScroll;
    }

    private int optionLimit(int scaledHeight) {
        return Math.max(1, scaledHeight / 11 - 2);
    }

    public int getSelected() {
        return this.selected;
    }
}

