/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_270;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTSeparateShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.gui.IScreenBase;
import xaero.map.mods.SupportMods;

public class Misc {
    private static final long[] ZERO_LONG_586 = new long[586];
    private static long cpuTimerPreTime;
    private static long glTimerPreTime;
    private static int shadersType;
    private static boolean EXTgeometryShader;

    public static int myFloor(double d) {
        int asInt = (int)d;
        if ((double)asInt != d && d < 0.0) {
            --asInt;
        }
        return asInt;
    }

    public static double round(double a, int komaarvu) {
        double x = Math.pow(10.0, komaarvu);
        return (double)Math.round(a * x) / x;
    }

    public static class_2680 getStateById(int id) {
        try {
            return class_2248.method_9531((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static class_2680 getDefaultBlockStateForStateId(int id) {
        try {
            return class_2248.method_9531((int)id).method_26204().method_9564();
        }
        catch (Exception e) {
            return class_2246.field_10124.method_9564();
        }
    }

    public static void glTimerPre() {
        GL11.glFinish();
        glTimerPreTime = System.nanoTime();
    }

    public static int glTimerResult() {
        GL11.glFinish();
        return (int)(System.nanoTime() - glTimerPreTime);
    }

    public static void timerPre() {
        cpuTimerPreTime = System.nanoTime();
    }

    public static int timerResult() {
        return (int)(System.nanoTime() - cpuTimerPreTime);
    }

    public static double getMouseX(class_310 mc) {
        return mc.field_1729.method_1603() * (double)mc.method_22683().method_4489() / (double)mc.method_22683().method_4480();
    }

    public static double getMouseY(class_310 mc) {
        return mc.field_1729.method_1604() * (double)mc.method_22683().method_4506() / (double)mc.method_22683().method_4507();
    }

    public static void minecraftOrtho(class_310 mc) {
        class_1041 mainwindow = mc.method_22683();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)mainwindow.method_4489() / mainwindow.method_4495()), (double)((double)mainwindow.method_4506() / mainwindow.method_4495()), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static void clearHeightsData586(long[] data) {
        System.arraycopy(ZERO_LONG_586, 0, data, 0, 586);
    }

    public static <T extends Comparable<? super T>> void addToListOfSmallest(int maxSize, List<T> list, T element) {
        int currentSize = list.size();
        if (currentSize == maxSize && ((Comparable)list.get(currentSize - 1)).compareTo(element) <= 0) {
            return;
        }
        int iterLimit = currentSize == maxSize ? maxSize : currentSize + 1;
        for (int i = 0; i < iterLimit; ++i) {
            if (i != currentSize && element.compareTo(list.get(i)) >= 0) continue;
            list.add(i, element);
            if (currentSize != maxSize) break;
            list.remove(currentSize);
            break;
        }
    }

    public static void setShaderProgram(int program) {
        if (shadersType == -500) {
            shadersType = GL.getCapabilities().OpenGL20 ? 0 : (GL.getCapabilities().GL_ARB_shader_objects ? 1 : (GL.getCapabilities().GL_EXT_separate_shader_objects ? 2 : -1));
            EXTgeometryShader = GL.getCapabilities().GL_EXT_geometry_shader4 || GL.getCapabilities().GL_ARB_geometry_shader4;
        }
        switch (shadersType) {
            case 0: {
                class_4493.method_22045((int)program);
                break;
            }
            case 1: {
                ARBShaderObjects.glUseProgramObjectARB((int)program);
                break;
            }
            case 2: {
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35633, (int)program);
                if (EXTgeometryShader) {
                    EXTSeparateShaderObjects.glUseShaderProgramEXT((int)36313, (int)program);
                }
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35632, (int)program);
                EXTSeparateShaderObjects.glActiveProgramEXT((int)program);
                break;
            }
        }
    }

    public static String getKeyName(class_304 kb) {
        if (KeyBindingHelper.getBoundKeyOf((class_304)kb).method_1444() == -1) {
            return "(unset)";
        }
        return kb.method_16007().getString().toUpperCase();
    }

    public static boolean inputMatchesKeyBinding(class_3675.class_307 type, int code, class_304 kb) {
        return code != -1 && KeyBindingHelper.getBoundKeyOf((class_304)kb).method_1442() == type && KeyBindingHelper.getBoundKeyOf((class_304)kb).method_1444() == code;
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFile(file, attempts);
            }
            throw e;
        }
    }

    public static boolean screenShouldSkipWorldRender(class_437 screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && SupportMods.minimap() && SupportMods.xaeroMinimap.screenShouldSkipWorldRender(screen);
    }

    public static void drawNormalText(class_4587 matrices, String name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        class_310.method_1551().field_1772.method_27521(name, x, y, color, shadow, matrices.method_23760().method_23761(), (class_4597)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawPiercingText(class_4587 matrices, String name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        class_310.method_1551().field_1772.method_27521(name, x, y, color, shadow, matrices.method_23760().method_23761(), (class_4597)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawPiercingText(class_4587 matrices, class_2561 name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        class_310.method_1551().field_1772.method_30882(name, x, y, color, shadow, matrices.method_23760().method_23761(), (class_4597)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(class_4587 matrices, String name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(class_310.method_1551().field_1772.method_1727(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(class_4587 matrices, class_2561 name, float x, float y, int color, boolean shadow, class_4597.class_4598 renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(class_310.method_1551().field_1772.method_27525((class_5348)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static boolean hasItem(class_1657 player, class_1792 item) {
        return Misc.hasItem((class_2371<class_1799>)player.field_7514.field_7544, -1, item) || Misc.hasItem((class_2371<class_1799>)player.field_7514.field_7548, -1, item) || Misc.hasItem((class_2371<class_1799>)player.field_7514.field_7547, 9, item);
    }

    public static boolean hasItem(class_2371<class_1799> inventory, int limit, class_1792 item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((class_1799)inventory.get(i)).method_7909() != item) continue;
            return true;
        }
        return false;
    }

    public static int getTeamColour(class_1297 e) {
        Integer teamColour = null;
        class_270 team = e.method_5781();
        if (team != null) {
            teamColour = team.method_1202().method_532();
        }
        return teamColour == null ? -1 : teamColour;
    }

    static {
        shadersType = -500;
    }
}

