/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.patreon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import net.minecraft.class_1664;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_742;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.map.WorldMap;
import xaero.map.patreon.PatreonMod;
import xaero.map.patreon.decrypt.DecryptInputStream;

public class Patreon {
    private static HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    private static boolean notificationDisplayed;
    private static boolean loaded;
    private static boolean showCapes;
    private static int patronPledge;
    private static String updateLocation;
    private static HashMap<String, Object> mods;
    private static ArrayList<Object> outdatedMods;
    private static Cipher cipher;
    private static int KEY_VERSION;
    private static String publicKeyString;
    private static boolean shouldRedirectToMinimap;
    private static File optionsFile;
    private static String rendersCapes;
    private static class_2960 cape1;
    private static class_2960 cape2;
    private static class_2960 cape3;
    private static class_2960 cape4;
    private static boolean pauseCapes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.checkPatreon();
            return;
        }
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon.loadSettings();
            String s = "http://data.chocolateminecraft.com/Versions_" + KEY_VERSION + "/Patreon.dat";
            s = s.replaceAll(" ", "%20");
            try {
                String[] args;
                String line;
                URL url = new URL(s);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(900);
                conn.setConnectTimeout(900);
                if (conn.getContentLengthLong() > 524288L) {
                    throw new IOException("Input too long to trust!");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new DecryptInputStream(conn.getInputStream(), cipher)));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(class_310.method_1551().method_1548().method_1677().getName())) continue;
                    patronPledge = pledge;
                }
                updateLocation = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    args = line.split("\\t");
                    mods.put(args[0], new PatreonMod(args[0], args[1], args[2], args[3]));
                }
                reader.close();
            }
            catch (Throwable e) {
                WorldMap.LOGGER.error("suppressed exception", e);
                patrons.clear();
                mods.clear();
            }
            finally {
                loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutdatedMod(Object mod) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.addOutdatedMod((Object)mod);
            return;
        }
        ArrayList<Object> arrayList = Patreon.getOutdatedMods();
        synchronized (arrayList) {
            Patreon.getOutdatedMods().add(mod);
        }
    }

    public static int getPatronPledge(String name) {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getPatronPledge((String)name);
        }
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.saveSettings();
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + showCapes);
            writer.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static void loadSettings() {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.loadSettings();
            return;
        }
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                showCapes = args[1].equals("true");
            }
            reader.close();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static class_2960 getPlayerCape(String modID, class_742 playerEntity) {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getPlayerCape((String)modID, (class_742)playerEntity);
        }
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            class_2960 cape = null;
            int pledge = Patreon.getPatronPledge(playerEntity.method_5477().getString());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            class_2960 realCape = playerEntity.method_3119();
            boolean realIsWearing = playerEntity.method_7348(class_1664.field_7559);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(String modID, class_742 playerEntity) {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.isWearingCape((String)modID, (class_742)playerEntity);
        }
        if (!pauseCapes && showCapes && modID.equals(rendersCapes)) {
            pauseCapes = true;
            class_2960 realCape = playerEntity.method_3119();
            boolean realIsWearing = playerEntity.method_7348(class_1664.field_7559);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon.getPatronPledge(playerEntity.method_5477().getString());
            return pledge >= 2;
        }
        return null;
    }

    public static ArrayList<Object> getOutdatedMods() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getOutdatedMods();
        }
        return outdatedMods;
    }

    public static boolean needsNotification() {
        if (shouldRedirectToMinimap) {
            return false;
        }
        return !Patreon.isNotificationDisplayed() && !outdatedMods.isEmpty();
    }

    public static int getPatronPledge() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getPatronPledge();
        }
        return patronPledge;
    }

    public static void setPatronPledge(int patronPledge) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.setPatronPledge((int)patronPledge);
            return;
        }
        Patreon.patronPledge = patronPledge;
    }

    public static boolean isNotificationDisplayed() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.isNotificationDisplayed();
        }
        return notificationDisplayed;
    }

    public static void setNotificationDisplayed(boolean notificationDisplayed) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.setNotificationDisplayed((boolean)notificationDisplayed);
            return;
        }
        Patreon.notificationDisplayed = notificationDisplayed;
    }

    public static HashMap<String, Object> getMods() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getMods();
        }
        return mods;
    }

    public static String getUpdateLocation() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getUpdateLocation();
        }
        return updateLocation;
    }

    public static String getRendersCapes() {
        if (shouldRedirectToMinimap) {
            return xaero.common.patreon.Patreon.getRendersCapes();
        }
        return rendersCapes;
    }

    public static void setRendersCapes(String rendersCapes) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.Patreon.setRendersCapes((String)rendersCapes);
            return;
        }
        Patreon.rendersCapes = rendersCapes;
    }

    public static void setModInfo(Object mod, File modJAR, String versionID, String latestVersion, String latestVersionMD5, Runnable onVersionIgnore) {
        if (shouldRedirectToMinimap) {
            xaero.common.patreon.PatreonMod patreonEntry = (xaero.common.patreon.PatreonMod)mod;
            patreonEntry.modJar = modJAR;
            patreonEntry.currentVersion = versionID;
            patreonEntry.latestVersion = latestVersion;
            patreonEntry.md5 = latestVersionMD5;
            patreonEntry.onVersionIgnore = onVersionIgnore;
            return;
        }
        PatreonMod patreonEntry = (PatreonMod)mod;
        patreonEntry.modJar = modJAR;
        patreonEntry.currentVersion = versionID;
        patreonEntry.latestVersion = latestVersion;
        patreonEntry.md5 = latestVersionMD5;
        patreonEntry.onVersionIgnore = onVersionIgnore;
    }

    public static String getPublicKeyString() {
        if (shouldRedirectToMinimap) {
            if (SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION < 10) {
                return xaero.common.patreon.Patreon.getPublicKeyString();
            }
            return xaero.common.patreon.Patreon.getPublicKeyString2();
        }
        return publicKeyString;
    }

    public static int getKEY_VERSION() {
        if (shouldRedirectToMinimap) {
            if (SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION < 10) {
                return xaero.common.patreon.Patreon.getKEY_VERSION();
            }
            return xaero.common.patreon.Patreon.getKEY_VERSION2();
        }
        return KEY_VERSION;
    }

    static {
        loaded = false;
        showCapes = true;
        patronPledge = -1;
        mods = new HashMap();
        outdatedMods = new ArrayList();
        cipher = null;
        KEY_VERSION = 4;
        publicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoBeELcruvAEIeLF/UsWF/v5rxyRXIpCs+eORLCbDw5cz9jHsnoypQKx0RTk5rcXIeA0HbEfY0eREB25quHjhZKul7MnzotQT+F2Qb1bPfHa6+SPie+pj79GGGAFP3npki6RqoU/wyYkd1tOomuD8v5ytEkOPC4U42kxxvx23A7vH6w46dew/E/HvfbBvZF2KrqdJtwKAunk847C3FgyhVq8/vzQc6mqAW6Mmn4zlwFvyCnTOWjIRw/I93WIM/uvhE3lt6pmtrWA2yIbKIj1z4pgG/K72EqHfYLGkBFTh7fV1wwCbpNTXZX2JnTfmvMGqzHjq7FijwVfCpFB/dWR3wQIDAQAB";
        shouldRedirectToMinimap = false;
        try {
            Class.forName("xaero.common.patreon.Patreon");
            shouldRedirectToMinimap = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!shouldRedirectToMinimap) {
            try {
                cipher = Cipher.getInstance("RSA");
                KeyFactory factory = KeyFactory.getInstance("RSA");
                byte[] byteKey = Base64.getDecoder().decode(Patreon.getPublicKeyString().getBytes());
                X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
                PublicKey publicKey = factory.generatePublic(X509publicKey);
                cipher.init(2, publicKey);
            }
            catch (Exception e) {
                cipher = null;
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        optionsFile = new File("./config/xaeropatreon.txt");
        rendersCapes = null;
        cape1 = new class_2960("xaeropatreon", "capes/cape1.png");
        cape2 = new class_2960("xaeropatreon", "capes/cape2.png");
        cape3 = new class_2960("xaeropatreon", "capes/cape3.png");
        cape4 = new class_2960("xaeropatreon", "capes/cape4.png");
        pauseCapes = false;
    }
}

